/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.process;

import astavie.thermallogistics.util.RequesterReference;
import cofh.core.network.PacketBase;
import java.util.Objects;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Source<I> {
    public final RequesterReference<I> crafter;
    public final byte side;

    public Source(byte side, RequesterReference<I> crafter) {
        this.crafter = crafter;
        this.side = side;
    }

    public Source(byte side) {
        this.crafter = null;
        this.side = side;
    }

    public static <I> Source<I> readPacket(PacketBase packet) {
        if (packet.getBool()) {
            return new Source(0, RequesterReference.readPacket(packet));
        }
        return new Source<I>(0);
    }

    public static void writePacket(PacketBase packet, Source<?> source) {
        packet.addBool(source.isCrafter());
        if (source.isCrafter()) {
            RequesterReference.writePacket(packet, source.crafter);
        }
    }

    public static <I> Source<I> readNbt(NBTBase nbt) {
        if (nbt instanceof NBTTagCompound) {
            return new Source(((NBTTagCompound)nbt).func_74771_c("des"), RequesterReference.readNBT((NBTTagCompound)nbt));
        }
        if (nbt instanceof NBTTagByte) {
            return new Source<I>(((NBTTagByte)nbt).func_150290_f());
        }
        throw new IllegalArgumentException();
    }

    public static NBTBase writeNbt(Source<?> source) {
        if (source.isCrafter()) {
            NBTTagCompound nbt = RequesterReference.writeNBT(source.crafter);
            nbt.func_74774_a("des", source.side);
            return nbt;
        }
        return new NBTTagByte(source.side);
    }

    public boolean isCrafter() {
        return this.crafter != null;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.side).append(this.crafter).build();
    }

    public boolean equals(Object obj) {
        return obj instanceof Source && ((Source)obj).side == this.side && Objects.equals(((Source)obj).crafter, this.crafter);
    }
}

