/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.process;

import astavie.thermallogistics.process.Source;
import astavie.thermallogistics.util.collection.MissingList;
import astavie.thermallogistics.util.type.Type;
import cofh.core.network.PacketBase;
import java.util.function.Function;
import net.minecraft.nbt.NBTTagCompound;

public class Request<I> {
    public final Type<I> type;
    public final int index;
    public final MissingList missing;
    public final boolean complex;
    public long amount;
    public Source<I> source;

    public Request(Type<I> type, long amount, Source<I> source, int index) {
        this.type = type;
        this.amount = amount;
        this.source = source;
        this.index = index;
        this.missing = null;
        this.complex = false;
    }

    public Request(Type<I> type, long amount, int index, MissingList missing, boolean complex) {
        this.type = type;
        this.amount = amount;
        this.source = null;
        this.index = index;
        this.missing = missing;
        this.complex = complex;
    }

    public static <I> Request<I> readPacket(PacketBase packet, Function<PacketBase, Type<I>> func) {
        Type<I> type = func.apply(packet);
        long amount = packet.getLong();
        int index = packet.getInt();
        if (packet.getBool()) {
            return new Request<I>(type, amount, index, packet.getBool() ? new MissingList(packet) : null, packet.getBool());
        }
        return new Request<I>(type, amount, Source.readPacket(packet), index);
    }

    public static <I> void writePacket(PacketBase packet, Request<I> request, int index) {
        request.type.writePacket(packet);
        packet.addLong(request.amount);
        packet.addInt(index);
        packet.addBool(request.isError());
        if (request.isError()) {
            packet.addBool(request.missing != null);
            if (request.missing != null) {
                request.missing.write(packet);
            }
            packet.addBool(request.complex);
        } else if (request.source != null) {
            Source.writePacket(packet, request.source);
        } else {
            packet.addBool(false);
        }
    }

    public static <I> Request<I> readNBT(NBTTagCompound nbt, Function<NBTTagCompound, Type<I>> func, int index) {
        Type<I> type = func.apply(nbt);
        long amount = nbt.func_74763_f("Count");
        Source source = nbt.func_74764_b("source") ? Source.readNbt(nbt.func_74781_a("source")) : null;
        return new Request<I>(type, amount, source, index);
    }

    public static NBTTagCompound writeNBT(Request<?> request) {
        NBTTagCompound nbt = request.type.writeNbt();
        nbt.func_74772_a("Count", request.amount);
        if (request.source != null) {
            nbt.func_74782_a("source", Source.writeNbt(request.source));
        }
        return nbt;
    }

    public boolean isError() {
        return this.missing != null || this.complex;
    }
}

