/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.item;

import astavie.thermallogistics.attachment.DistributorFluid;
import astavie.thermallogistics.attachment.DistributorItem;
import astavie.thermallogistics.item.ItemAttachmentLogistics;
import cofh.core.util.helpers.RecipeHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermaldynamics.duct.Attachment;
import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.attachments.servo.ServoBase;
import cofh.thermaldynamics.duct.attachments.servo.ServoFluid;
import cofh.thermaldynamics.duct.attachments.servo.ServoItem;
import cofh.thermaldynamics.duct.tiles.DuctToken;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import cofh.thermaldynamics.item.ItemServo;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class ItemDistributor
extends ItemAttachmentLogistics {
    public ItemDistributor(String name) {
        super(name);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        int type = stack.func_77960_j();
        if (!StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.getInfoText((String)"item.logistics.distributor.info"));
            if (StringHelper.displayShiftForDetail) {
                tooltip.add(StringHelper.shiftForDetails());
            }
            return;
        }
        if (ServoBase.canAlterRS((int)type)) {
            tooltip.add(StringHelper.localize((String)"info.thermaldynamics.servo.redstoneInt"));
        } else {
            tooltip.add(StringHelper.localize((String)"info.thermaldynamics.servo.redstoneExt"));
        }
        tooltip.add("\u00a7e" + StringHelper.localize((String)"info.cofh.items") + "\u00a7r");
        tooltip.add("  " + StringHelper.localize((String)"info.thermaldynamics.servo.extractRate") + ": " + "\u00a7f" + (ServoItem.tickDelays[type] % 20 == 0 ? Integer.toString(ServoItem.tickDelays[type] / 20) : Float.toString((float)ServoItem.tickDelays[type] / 20.0f)) + "s" + "\u00a7r");
        tooltip.add("  " + StringHelper.localize((String)"info.thermaldynamics.servo.maxStackSize") + ": " + "\u00a7f" + ServoItem.maxSize[type] + "\u00a7r");
        ItemServo.addFiltering(tooltip, (int)type, (Duct.Type)Duct.Type.ITEM);
        if (ServoItem.multiStack[type]) {
            tooltip.add("  " + StringHelper.localize((String)"info.thermaldynamics.servo.slotMulti"));
        } else {
            tooltip.add("  " + StringHelper.localize((String)"info.thermaldynamics.servo.slotSingle"));
        }
        if (ServoItem.speedBoost[type] != 1) {
            tooltip.add("  " + StringHelper.localize((String)"info.thermaldynamics.servo.speedBoost") + ": " + "\u00a7f" + ServoItem.speedBoost[type] + "x " + "\u00a7r");
        }
        tooltip.add("\u00a7e" + StringHelper.localize((String)"info.cofh.fluids") + "\u00a7r");
        tooltip.add("  " + StringHelper.localize((String)"info.thermaldynamics.servo.extractRate") + ": " + "\u00a7f" + (int)(ServoFluid.throttle[type] * 100.0f) + "%" + "\u00a7r");
        ItemServo.addFiltering(tooltip, (int)type, (Duct.Type)Duct.Type.FLUID);
    }

    public Attachment getAttachment(EnumFacing side, ItemStack stack, TileGrid tile) {
        int type = stack.func_77952_i();
        if (tile.getDuct(DuctToken.FLUID) != null) {
            return new DistributorFluid(tile, (byte)(side.ordinal() ^ 1), type);
        }
        if (tile.getDuct(DuctToken.ITEMS) != null) {
            return new DistributorItem(tile, (byte)(side.ordinal() ^ 1), type);
        }
        return null;
    }

    public boolean initialize() {
        ItemStack distributorBasic = new ItemStack((Item)this, 1, 0);
        ItemStack distributorHardened = new ItemStack((Item)this, 1, 1);
        ItemStack distributorReinforced = new ItemStack((Item)this, 1, 2);
        ItemStack distributorSignalum = new ItemStack((Item)this, 1, 3);
        ItemStack distributorResonant = new ItemStack((Item)this, 1, 4);
        RecipeHelper.addShapedRecipe((ItemStack)distributorBasic, (Object[])new Object[]{"iCi", "IRI", Character.valueOf('i'), "nuggetIron", Character.valueOf('R'), ItemServo.servoBasic, Character.valueOf('I'), "ingotIron", Character.valueOf('C'), Items.field_151132_bS});
        RecipeHelper.addShapedRecipe((ItemStack)distributorHardened, (Object[])new Object[]{"iCi", "IRI", Character.valueOf('i'), "nuggetIron", Character.valueOf('R'), ItemServo.servoHardened, Character.valueOf('I'), "ingotInvar", Character.valueOf('C'), Items.field_151132_bS});
        RecipeHelper.addShapelessRecipe((ItemStack)distributorHardened, (Object[])new Object[]{distributorBasic, "ingotInvar"});
        RecipeHelper.addShapedRecipe((ItemStack)distributorReinforced, (Object[])new Object[]{"iCi", "IRI", Character.valueOf('i'), "nuggetIron", Character.valueOf('R'), ItemServo.servoReinforced, Character.valueOf('I'), "ingotElectrum", Character.valueOf('C'), Items.field_151132_bS});
        RecipeHelper.addShapelessRecipe((ItemStack)distributorReinforced, (Object[])new Object[]{distributorBasic, "ingotElectrum"});
        RecipeHelper.addShapelessRecipe((ItemStack)distributorReinforced, (Object[])new Object[]{distributorHardened, "ingotElectrum"});
        RecipeHelper.addShapedRecipe((ItemStack)distributorSignalum, (Object[])new Object[]{"iCi", "IRI", Character.valueOf('i'), "nuggetIron", Character.valueOf('R'), ItemServo.servoSignalum, Character.valueOf('I'), "ingotSignalum", Character.valueOf('C'), Items.field_151132_bS});
        RecipeHelper.addShapelessRecipe((ItemStack)distributorSignalum, (Object[])new Object[]{distributorBasic, "ingotSignalum"});
        RecipeHelper.addShapelessRecipe((ItemStack)distributorSignalum, (Object[])new Object[]{distributorHardened, "ingotSignalum"});
        RecipeHelper.addShapelessRecipe((ItemStack)distributorSignalum, (Object[])new Object[]{distributorReinforced, "ingotSignalum"});
        RecipeHelper.addShapedRecipe((ItemStack)distributorResonant, (Object[])new Object[]{"iCi", "IRI", Character.valueOf('i'), "nuggetIron", Character.valueOf('R'), ItemServo.servoResonant, Character.valueOf('I'), "ingotEnderium", Character.valueOf('C'), Items.field_151132_bS});
        RecipeHelper.addShapelessRecipe((ItemStack)distributorResonant, (Object[])new Object[]{distributorBasic, "ingotEnderium"});
        RecipeHelper.addShapelessRecipe((ItemStack)distributorResonant, (Object[])new Object[]{distributorHardened, "ingotEnderium"});
        RecipeHelper.addShapelessRecipe((ItemStack)distributorResonant, (Object[])new Object[]{distributorReinforced, "ingotEnderium"});
        RecipeHelper.addShapelessRecipe((ItemStack)distributorResonant, (Object[])new Object[]{distributorSignalum, "ingotEnderium"});
        return true;
    }
}

