/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.client.gui;

import astavie.thermallogistics.ThermalLogistics;
import astavie.thermallogistics.client.gui.GuiOverlay;
import astavie.thermallogistics.client.gui.IFocusGui;
import astavie.thermallogistics.client.gui.element.ElementStack;
import astavie.thermallogistics.client.gui.element.ElementTextFieldAmount;
import astavie.thermallogistics.client.gui.element.ElementTextFieldClear;
import astavie.thermallogistics.compat.jei.CompatJEI;
import astavie.thermallogistics.process.Request;
import astavie.thermallogistics.tile.TileTerminal;
import astavie.thermallogistics.util.Shared;
import astavie.thermallogistics.util.StackHandler;
import astavie.thermallogistics.util.type.Type;
import cofh.core.gui.GuiContainerCore;
import cofh.core.gui.element.ElementBase;
import cofh.core.gui.element.ElementButton;
import cofh.core.gui.element.ElementSlider;
import cofh.core.gui.element.ElementTextField;
import cofh.core.gui.element.listbox.SliderVertical;
import cofh.core.gui.element.tab.TabBase;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketTileInfo;
import cofh.core.util.helpers.ChatHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.RenderHelper;
import cofh.core.util.helpers.StringHelper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.lang3.tuple.Triple;

public abstract class GuiTerminal<I>
extends GuiOverlay
implements IFocusGui {
    protected final List<Triple<Type<I>, Long, Boolean>> filter = NonNullList.func_191196_a();
    protected final TileTerminal<I> tile;
    public Shared<ElementTextField> search = new Shared();
    protected ElementSlider slider;
    protected Shared<ElementTextField> amount = new Shared<ElementTextFieldAmount>(new ElementTextFieldAmount(this, 20, 4, 57, 10, true));
    protected Type<I> selected;
    protected int rows = 2;
    protected int split = 27;
    protected int size;
    private int bar;
    private String cache = "";

    public GuiTerminal(TileTerminal<I> tile, Container container, ResourceLocation texture) {
        super(container, texture);
        this.tile = tile;
    }

    protected void request(Type<I> stack, long amount) {
        this.tile.terminal.remove(stack, amount);
        this.updateFilter();
        PacketTileInfo packet = PacketTileInfo.newPacket(this.tile);
        packet.addByte(0);
        stack.writePacket((PacketBase)packet);
        packet.addLong(amount);
        PacketHandler.sendToServer((PacketBase)packet);
    }

    protected Slot requester() {
        return (Slot)this.field_147002_h.field_75151_b.get(0);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.recalculateSize();
        this.name = this.tile.customName;
        if (this.name.isEmpty()) {
            this.name = StringHelper.localize((String)this.tile.getTileName());
        }
        String prev = this.search.get() == null ? "" : this.search.get().getText();
        this.search.accept(new ElementTextFieldClear(this, 80, 5, 88, 10, true){

            protected void onCharacterEntered(boolean success) {
                if (ThermalLogistics.INSTANCE.jei.getBoolean() && Loader.isModLoaded((String)"jei")) {
                    CompatJEI.synchronize(this.getText());
                }
            }
        });
        this.slider = new SliderVertical((GuiContainerCore)this, 174, 18, 12, 34, 0);
        if (!prev.isEmpty()) {
            this.search.get().setText(prev);
        }
        this.addElement((ElementBase)this.search.get());
        this.addElement((ElementBase)this.slider);
        final Supplier<Integer> autofocus = () -> ThermalLogistics.INSTANCE.autofocus.getBoolean() ? 210 : 194;
        this.addElement((ElementBase)new ElementButton(this, -18, 0, 16, 16, autofocus.get(), 37, autofocus.get(), 53, this.texture.toString()){

            public void onClick() {
                ThermalLogistics.INSTANCE.autofocus.set(!ThermalLogistics.INSTANCE.autofocus.getBoolean());
                ThermalLogistics.INSTANCE.config.save();
                this.setSheetX((Integer)autofocus.get());
                this.setHoverX((Integer)autofocus.get());
                this.setToolTipLocalized(StringHelper.localize((String)("info.logistics.terminal.autofocus." + ThermalLogistics.INSTANCE.autofocus.getBoolean())));
                if (ThermalLogistics.INSTANCE.autofocus.getBoolean()) {
                    GuiTerminal.this.search.get().onMousePressed(1000, 0, 0);
                } else {
                    GuiTerminal.this.search.get().setFocused(false);
                }
            }
        }.setToolTipLocalized(StringHelper.localize((String)("info.logistics.terminal.autofocus." + ThermalLogistics.INSTANCE.autofocus.getBoolean()))));
        if (Loader.isModLoaded((String)"jei")) {
            final Supplier<Integer> synch = () -> ThermalLogistics.INSTANCE.jei.getBoolean() ? 210 : 194;
            this.addElement((ElementBase)new ElementButton(this, -18, 18, 16, 16, synch.get(), 69, synch.get(), 85, this.texture.toString()){

                public void onClick() {
                    ThermalLogistics.INSTANCE.jei.set(!ThermalLogistics.INSTANCE.jei.getBoolean());
                    ThermalLogistics.INSTANCE.config.save();
                    this.setSheetX((Integer)synch.get());
                    this.setHoverX((Integer)synch.get());
                    this.setToolTipLocalized(StringHelper.localize((String)("info.logistics.terminal.jei." + ThermalLogistics.INSTANCE.jei.getBoolean())));
                }
            }.setToolTipLocalized(StringHelper.localize((String)("info.logistics.terminal.jei." + ThermalLogistics.INSTANCE.jei.getBoolean()))));
        }
        if (ThermalLogistics.INSTANCE.autofocus.getBoolean()) {
            this.search.get().setFocused(true);
        }
        this.slider.setLimits(0, Math.max((this.filter.size() - 1) / 9 - this.rows + 1, 0));
        this.slider.setEnabled(this.filter.size() > this.rows * 9);
    }

    protected void func_146976_a(float partialTick, int x, int y) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTexture(this.texture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.split);
        for (int i = 0; i < this.rows - 1; ++i) {
            this.func_73729_b(this.field_147003_i, this.field_147009_r + this.split + 18 * i, 0, this.split, this.field_146999_f, 18);
        }
        this.func_73729_b(this.field_147003_i, this.field_147009_r + this.split + 18 * (this.rows - 1), 0, this.split + 18, this.field_146999_f, this.size - this.split - 18);
        this.mouseX = x - this.field_147003_i;
        this.mouseY = y - this.field_147009_r;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
        this.drawElements(partialTick, false);
        this.drawTabs(partialTick, false);
        GlStateManager.func_179121_F();
    }

    protected void recalculateSize() {
        int prev = this.rows;
        this.rows = MathHelper.clamp((int)((this.field_146295_m - this.size) / 18 + 2), (int)1, (int)9);
        this.field_147000_g -= prev * 18;
        this.field_147000_g += this.rows * 18;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        for (Slot slot : this.field_147002_h.field_75151_b) {
            if (slot.field_75221_f <= this.split) continue;
            slot.field_75221_f -= prev * 18;
            slot.field_75221_f += this.rows * 18;
        }
        this.bar = 20 + this.rows * 18;
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.tile.refresh || !this.search.get().getText().equals(this.cache)) {
            this.tile.refresh = false;
            this.cache = this.search.get().getText();
            this.updateFilter();
            this.slider.setLimits(0, Math.max((this.filter.size() - 1) / 9 - this.rows + 1, 0));
            this.slider.setEnabled(this.filter.size() > this.rows * 9);
        }
    }

    public ElementBase addElement(ElementBase element) {
        if (element.getPosY() > this.split) {
            element.setPosition(element.getPosX(), element.getPosY() + (this.rows - 2) * 18);
        } else if (!(element instanceof ElementButton) && element.getPosY() + element.getHeight() > this.split) {
            element.setSize(element.getWidth(), element.getHeight() + (this.rows - 2) * 18);
        }
        return super.addElement(element);
    }

    public TabBase addTab(TabBase tab) {
        tab.setOffsets(this.getTabOffsetX(), this.getTabOffsetY() + (this.rows - 2) * 18);
        tab.setCurrentShift(0, 0);
        return super.addTab(tab);
    }

    protected abstract int getTabOffsetX();

    protected abstract int getTabOffsetY();

    public Object getStackAt(int mouseX, int mouseY) {
        int i = this.slider.getValue() * 9;
        block0: for (int y = 0; y < this.rows; ++y) {
            for (int x = 0; x < 9; ++x) {
                int slot = i + x + y * 9;
                if (slot >= this.filter.size()) break block0;
                int posX = 8 + x * 18;
                int posY = 18 + y * 18;
                if (mouseX < posX - 1 || mouseX >= posX + 17 || mouseY < posY - 1 || mouseY >= posY + 17) continue;
                return ((Type)this.filter.get(slot).getLeft()).getAsStack();
            }
        }
        int max = Math.min(8, this.tile.requests.size());
        for (int j = 0; j < max; ++j) {
            Request request = this.tile.requests.get(this.tile.requests.size() - j - 1);
            if (mouseX < 25 + j * 18 || mouseX >= 43 + j * 18 || mouseY < this.bar - 1 || mouseY >= this.bar + 17) continue;
            return request.type.getAsStack();
        }
        return null;
    }

    @Override
    public void addTooltips(List<String> tooltip) {
        super.addTooltips(tooltip);
        if (!this.withinOverlay(this.mouseX, this.mouseY)) {
            int i = this.slider.getValue() * 9;
            block0: for (int y = 0; y < this.rows; ++y) {
                for (int x = 0; x < 9; ++x) {
                    int slot = i + x + y * 9;
                    if (slot >= this.filter.size()) break block0;
                    int posX = 8 + x * 18;
                    int posY = 18 + y * 18;
                    if (this.mouseX < posX - 1 || this.mouseX >= posX + 17 || this.mouseY < posY - 1 || this.mouseY >= posY + 17) continue;
                    tooltip.addAll(((Type)this.filter.get(slot).getLeft()).getTooltip(this));
                }
            }
        }
        int max = Math.min(8, this.tile.requests.size());
        for (int j = 0; j < max; ++j) {
            Request request = this.tile.requests.get(this.tile.requests.size() - j - 1);
            if (this.mouseX < 25 + j * 18 || this.mouseX >= 43 + j * 18 || this.mouseY < this.bar - 1 || this.mouseY >= this.bar + 17) continue;
            tooltip.addAll(request.type.getTooltip(this));
            if (request.isError()) {
                tooltip.add("");
                if (request.complex) {
                    tooltip.add(StringHelper.localize((String)"gui.logistics.terminal.complex"));
                } else {
                    tooltip.add(StringHelper.localize((String)"gui.logistics.terminal.missing"));
                    for (Map.Entry<Type<?>, Long> entry : request.missing.map.entrySet()) {
                        tooltip.add("\u00a77" + entry.getKey().getMissingLocalization(entry.getValue()));
                    }
                }
            }
            tooltip.add("");
            tooltip.add("\u00a77" + StringHelper.localize((String)"gui.logistics.terminal.cancel"));
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        RenderHelper.enableGUIStandardItemLighting();
        int i = this.slider.getValue() * 9;
        block0: for (int y = 0; y < this.rows; ++y) {
            for (int x = 0; x < 9; ++x) {
                int slot = i + x + y * 9;
                if (slot >= this.filter.size()) break block0;
                int posX = 8 + x * 18;
                int posY = 18 + y * 18;
                Triple<Type<I>, Long, Boolean> triple = this.filter.get(slot);
                GlStateManager.func_179126_j();
                StackHandler.render((GuiContainerCore)this, posX, posY, ((Type)triple.getLeft()).getAsStack(), (Long)triple.getMiddle() == 0L ? (ThermalLogistics.INSTANCE.smallText ? "Craft" : "+") : StackHandler.getScaledNumber((Long)triple.getMiddle()));
            }
        }
        int max = Math.min(8, this.tile.requests.size());
        for (int j = 0; j < max; ++j) {
            Request request = this.tile.requests.get(this.tile.requests.size() - j - 1);
            if (request.isError()) {
                int l = j == 0 ? 0 : -1;
                int r = j == 7 ? 0 : 1;
                GlStateManager.func_179140_f();
                GlStateManager.func_179097_i();
                this.func_73733_a(l + 26 + j * 18, this.bar, r + 42 + j * 18, this.bar + 16, -48060, -48060);
                GlStateManager.func_179145_e();
                GlStateManager.func_179126_j();
            }
            GlStateManager.func_179126_j();
            StackHandler.render((GuiContainerCore)this, 26 + j * 18, this.bar, request.type.getAsStack(), StackHandler.getScaledNumber(request.amount));
        }
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)100.0f);
        GlStateManager.func_179140_f();
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void func_73864_a(int mX, int mY, int mouseButton) throws IOException {
        if (!(mouseButton != 0 && mouseButton != 1 || this.withinOverlay(mX - this.field_147003_i, mY - this.field_147009_r))) {
            int pos;
            int mouseX = mX - this.field_147003_i - 7;
            int mouseY = mY - this.field_147009_r - 17;
            if (mouseX >= 0 && mouseX < 162 && mouseY >= 0 && mouseY < this.rows * 18) {
                int posX = mouseX / 18;
                int posY = mouseY / 18;
                int slot = this.slider.getValue() * 9 + posX + posY * 9;
                if (slot < this.filter.size()) {
                    if (this.requester().func_75216_d()) {
                        this.selected = (Type)this.filter.get(slot).getLeft();
                        if (mouseButton == 1) {
                            this.amount.get().setText("");
                        } else if (((Boolean)this.filter.get(slot).getRight()).booleanValue()) {
                            this.amount.get().setText(Long.toString(StringHelper.isShiftKeyDown() ? (long)this.selected.maxSize() : (long)this.selected.normalSize()));
                        } else {
                            this.amount.get().setText(Long.toString(Math.min(StringHelper.isShiftKeyDown() ? (long)this.selected.maxSize() : (long)this.selected.normalSize(), (Long)this.filter.get(slot).getMiddle())));
                        }
                        GuiOverlay.Overlay overlay = new GuiOverlay.Overlay(this, posX * 18 + 7, posY * 18 + 17, 97, 18){

                            @Override
                            public boolean onMouseWheel(int mouseX, int mouseY, int movement) {
                                long amt = GuiTerminal.this.amount.get().getText().isEmpty() ? 1L : Long.parseLong(GuiTerminal.this.amount.get().getText());
                                if ((amt += (long)(movement > 0 ? 1 : -1)) < 1L) {
                                    amt = 1L;
                                }
                                GuiTerminal.this.amount.get().setText(Long.toString(amt));
                                return true;
                            }
                        };
                        overlay.elements.add(new ElementStack(this, 0, 0, this.selected, false));
                        overlay.elements.add((ElementBase)this.amount.get());
                        overlay.elements.add((ElementBase)new ElementButton(this, 81, 2, 14, 14, 222, 0, 222, 14, this.texture.toString()){

                            public void onClick() {
                                GuiTerminal.this.request(GuiTerminal.this.selected, GuiTerminal.this.amount.get().getText().isEmpty() ? 1L : Long.parseLong(GuiTerminal.this.amount.get().getText()));
                                GuiTerminal.this.setOverlay(null);
                            }
                        });
                        this.setOverlay(overlay);
                    } else {
                        ChatHelper.sendIndexedChatMessageToPlayer((EntityPlayer)this.field_146297_k.field_71439_g, (ITextComponent)new TextComponentTranslation("info.logistics.terminal.requester", new Object[0]));
                        this.setOverlay(null);
                    }
                } else {
                    this.setOverlay(null);
                }
                return;
            }
            if (mouseButton == 1 && mouseX >= 18 && mouseX < 162 && mouseY >= this.bar - 17 && mouseY < this.bar + 1 && (pos = this.tile.requests.size() - mouseX / 18) >= 0 && pos < this.tile.requests.size()) {
                Request request = this.tile.requests.remove(pos);
                int start = request.index;
                int end = this.tile.requests.size() <= pos ? Integer.MAX_VALUE : this.tile.requests.get((int)pos).index;
                PacketTileInfo packet = PacketTileInfo.newPacket(this.tile);
                packet.addByte(1);
                packet.addInt(start);
                packet.addInt(end);
                PacketHandler.sendToServer((PacketBase)packet);
                GuiTerminal.playClickSound((float)1.0f);
                return;
            }
        }
        super.func_73864_a(mX, mY, mouseButton);
    }

    protected void func_73869_a(char characterTyped, int keyPressed) throws IOException {
        if (Loader.isModLoaded((String)"jei") && CompatJEI.checkKey(keyPressed)) {
            return;
        }
        if (keyPressed == 1) {
            if (this.selected != null) {
                this.setOverlay(null);
            } else {
                this.field_146297_k.field_71439_g.func_71053_j();
            }
        } else if (keyPressed == 28 && this.amount.get().isFocused()) {
            this.request(this.selected, this.amount.get().getText().isEmpty() ? 1L : Long.parseLong(this.amount.get().getText()));
            this.setOverlay(null);
        } else {
            super.func_73869_a(characterTyped, keyPressed);
        }
    }

    @Override
    public void setOverlay(GuiOverlay.Overlay overlay) {
        super.setOverlay(overlay);
        if (overlay == null) {
            this.selected = null;
            this.amount.get().setFocused(false);
        } else {
            this.amount.get().onMousePressed(1000, 0, 0);
        }
    }

    @Override
    public void onFocus(ElementTextField text) {
        if (!this.search.test(text)) {
            this.search.get().setFocused(false);
        }
    }

    @Override
    public void onLeave(ElementTextField text) {
        if (ThermalLogistics.INSTANCE.autofocus.getBoolean() && !this.search.test(text)) {
            this.search.get().onMousePressed(1000, 0, 0);
        }
    }

    protected abstract void updateFilter();

    protected boolean onMouseWheel(int mouseX, int mouseY, int wheelMovement) {
        return mouseX >= 7 && mouseX < 169 && mouseY >= 17 && mouseY < 71 && this.slider.onMouseWheel(mouseX, mouseY, wheelMovement);
    }

    protected void func_146286_b(int mX, int mY, int mouseButton) {
        mX -= this.field_147003_i;
        mY -= this.field_147009_r;
        if (mouseButton >= 0 && mouseButton <= 2) {
            for (TabBase tab : this.tabs) {
                if (!tab.isFullyOpened()) continue;
                tab.onMouseReleased(this.mouseX, this.mouseY);
                break;
            }
        }
        super.func_146286_b(mX += this.field_147003_i, mY += this.field_147009_r, mouseButton);
    }

    protected int getCenteredOffset(String string) {
        return 8;
    }
}

