/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.attachment;

import astavie.thermallogistics.ThermalLogistics;
import astavie.thermallogistics.attachment.ICrafter;
import astavie.thermallogistics.client.TLTextures;
import astavie.thermallogistics.process.IProcessRequesterFluid;
import astavie.thermallogistics.process.ProcessFluid;
import astavie.thermallogistics.process.Request;
import astavie.thermallogistics.util.RequesterReference;
import astavie.thermallogistics.util.StackHandler;
import astavie.thermallogistics.util.collection.FluidList;
import astavie.thermallogistics.util.collection.StackList;
import astavie.thermallogistics.util.type.Type;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.IconTransformation;
import cofh.thermaldynamics.duct.attachments.retriever.RetrieverFluid;
import cofh.thermaldynamics.duct.attachments.servo.ServoFluid;
import cofh.thermaldynamics.duct.attachments.servo.ServoItem;
import cofh.thermaldynamics.duct.fluid.DuctUnitFluid;
import cofh.thermaldynamics.duct.fluid.GridFluid;
import cofh.thermaldynamics.duct.tiles.DuctUnit;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import cofh.thermaldynamics.render.RenderDuct;
import cofh.thermaldynamics.util.ListWrapper;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.tuple.Pair;

public class RequesterFluid
extends RetrieverFluid
implements IProcessRequesterFluid {
    public static final ResourceLocation ID = new ResourceLocation("thermallogistics", "requester_fluid");
    private final ProcessFluid process = new ProcessFluid(this);
    private Map<RequesterReference<FluidStack>, StackList<FluidStack>> requests = new HashMap<RequesterReference<FluidStack>, StackList<FluidStack>>();

    public RequesterFluid(TileGrid tile, byte side) {
        super(tile, side);
    }

    public RequesterFluid(TileGrid tile, byte side, int type) {
        super(tile, side, type);
        this.filter.handleFlagByte(24);
    }

    public static ListWrapper<Pair<DuctUnit<?, ?, ?>, Byte>> getSources(DuctUnitFluid fluidDuct, byte s) {
        LinkedList<Pair> list = new LinkedList<Pair>();
        for (DuctUnitFluid duct : ((GridFluid)fluidDuct.getGrid()).nodeSet) {
            for (byte side = 0; side < 6; side = (byte)(side + 1)) {
                DuctUnitFluid.Cache cache;
                if (duct == fluidDuct && side == s || (cache = ((DuctUnitFluid.Cache[])duct.tileCache)[side]) == null || !duct.isOutput((int)side) && !duct.isInput((int)side)) continue;
                list.add(Pair.of((Object)duct, (Object)side));
            }
        }
        ListWrapper wrapper = new ListWrapper();
        wrapper.setList(list, ListWrapper.SortType.NORMAL);
        return wrapper;
    }

    public String getInfo() {
        return "tab.thermallogistics.requesterFluid";
    }

    public ResourceLocation getId() {
        return ID;
    }

    public ItemStack getPickBlock() {
        return new ItemStack((Item)ThermalLogistics.Items.requester, 1, this.type);
    }

    public String getName() {
        return this.getPickBlock().func_77977_a() + ".name";
    }

    public boolean render(IBlockAccess world, BlockRenderLayer layer, CCRenderState ccRenderState) {
        if (layer != BlockRenderLayer.SOLID) {
            return false;
        }
        Translation trans = Vector3.fromTileCenter((TileEntity)this.baseTile).translation();
        RenderDuct.modelConnection[this.isPowered ? 1 : 2][this.side].render(ccRenderState, new IVertexOperation[]{trans, new IconTransformation(TLTextures.REQUESTER[this.stuffed ? 1 : 0][this.type])});
        return true;
    }

    public void tick(int pass) {
        GridFluid grid = (GridFluid)this.fluidDuct.getGrid();
        if (pass != 1 || grid == null || !this.isPowered || !this.isValidInput) {
            return;
        }
        this.process.update(false);
    }

    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74782_a("requests", (NBTBase)StackHandler.writeRequestMap(this.requests));
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.requests = StackHandler.readRequestMap(tag.func_150295_c("requests", 10), FluidList::new);
    }

    @Override
    public boolean referencedBy(RequesterReference<?> reference) {
        return reference.dim == this.baseTile.world().field_73011_w.getDimension() && reference.pos.equals((Object)this.baseTile.func_174877_v()) && reference.side == this.side;
    }

    @Override
    public RequesterReference<FluidStack> createReference() {
        return new RequesterReference<FluidStack>(this.baseTile.world().field_73011_w.getDimension(), this.baseTile.func_174877_v(), this.side);
    }

    @Override
    public void onFail(RequesterReference<FluidStack> crafter, Type<FluidStack> type, long amount) {
        StackList<FluidStack> list;
        if (this.requests.containsKey(crafter) && (list = this.requests.get(crafter)) != null) {
            list.remove(type, amount);
            if (list.isEmpty()) {
                this.requests.remove(crafter);
                this.markDirty();
            }
        }
    }

    @Override
    public ItemStack getIcon() {
        return this.getPickBlock();
    }

    @Override
    public ItemStack getTileIcon() {
        return this.myTile == null ? ItemStack.field_190927_a : this.myTile.func_145838_q().func_185473_a(this.myTile.func_145831_w(), this.myTile.func_174877_v(), this.myTile.func_145831_w().func_180495_p(this.myTile.func_174877_v()));
    }

    @Override
    public StackList<FluidStack> getRequestedStacks() {
        return new FluidList();
    }

    @Override
    public StackList<FluidStack> getRequestedStacks(ICrafter<FluidStack> crafter) {
        return this.requests.getOrDefault(crafter.createReference(), new FluidList());
    }

    @Override
    public void onFail(Type<FluidStack> type, long amount) {
    }

    @Override
    public void onCrafterSend(ICrafter<FluidStack> crafter, Type<FluidStack> type, long amount) {
        this.onFail(crafter.createReference(), type, amount);
    }

    @Override
    public BlockPos getDestination() {
        return this.baseTile.func_174877_v().func_177972_a(EnumFacing.func_82600_a((int)this.side));
    }

    @Override
    @Nullable
    public DuctUnit<?, ?, ?> getDuct() {
        return this.fluidDuct;
    }

    @Override
    public byte getSide() {
        return (byte)(this.side ^ 1);
    }

    @Override
    public Map<RequesterReference<FluidStack>, StackList<FluidStack>> getRequests() {
        HashMap<RequesterReference<FluidStack>, StackList<FluidStack>> copy = new HashMap<RequesterReference<FluidStack>, StackList<FluidStack>>();
        for (Map.Entry<RequesterReference<FluidStack>, StackList<FluidStack>> entry : this.requests.entrySet()) {
            copy.put(entry.getKey(), entry.getValue().copy());
        }
        return copy;
    }

    @Override
    public ListWrapper<Pair<DuctUnit<?, ?, ?>, Byte>> getSources() {
        return RequesterFluid.getSources(this.fluidDuct, this.side);
    }

    @Override
    public boolean hasWants() {
        return true;
    }

    @Override
    public long amountRequired(Type<FluidStack> type) {
        return this.filter.allowFluid(type.getAsStack()) ? (long)this.maxFill(type) : 0L;
    }

    private int maxFill(Type<FluidStack> type) {
        DuctUnitFluid.Cache cache = ((DuctUnitFluid.Cache[])this.fluidDuct.tileCache)[this.side];
        if (cache == null) {
            return 0;
        }
        IFluidHandler inv = cache.getHandler(this.side ^ 1);
        if (inv == null) {
            return 0;
        }
        int max = inv.fill(type.withAmount(Integer.MAX_VALUE), false);
        GridFluid grid = (GridFluid)this.fluidDuct.getGrid();
        if (grid != null && type.references(grid.getFluid())) {
            max -= grid.getFluid().amount;
        }
        for (StackList<FluidStack> list : this.requests.values()) {
            max = (int)((long)max - list.amount((FluidStack)type));
        }
        return Math.max(max, 0);
    }

    @Override
    public void addRequest(Request<FluidStack> request) {
        if (!request.isError()) {
            this.requests.computeIfAbsent(request.source.crafter, c -> new FluidList());
            this.requests.get(request.source.crafter).add(request.type, request.amount);
            this.markDirty();
        }
    }

    public void markDirty() {
        this.baseTile.markChunkDirty();
    }

    @Override
    public int tickDelay() {
        return ServoItem.tickDelays[this.type];
    }

    @Override
    public float throttle() {
        return ServoFluid.throttle[this.type];
    }

    @Override
    public int maxSize() {
        return ServoItem.maxSize[this.type] * 1000;
    }
}

