/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.attachment;

import astavie.thermallogistics.ThermalLogistics;
import astavie.thermallogistics.attachment.CrafterFluid;
import astavie.thermallogistics.attachment.CrafterItem;
import astavie.thermallogistics.attachment.ICrafter;
import astavie.thermallogistics.attachment.IRequester;
import astavie.thermallogistics.attachment.RequesterFluid;
import astavie.thermallogistics.process.IProcessRequester;
import astavie.thermallogistics.process.IProcessRequesterFluid;
import astavie.thermallogistics.process.IProcessRequesterItem;
import astavie.thermallogistics.process.Process;
import astavie.thermallogistics.process.ProcessFluid;
import astavie.thermallogistics.process.ProcessItem;
import astavie.thermallogistics.process.Proposal;
import astavie.thermallogistics.process.Request;
import astavie.thermallogistics.util.RequesterReference;
import astavie.thermallogistics.util.Snapshot;
import astavie.thermallogistics.util.collection.EmptyList;
import astavie.thermallogistics.util.collection.EmptyListWrapper;
import astavie.thermallogistics.util.collection.FluidList;
import astavie.thermallogistics.util.collection.ItemList;
import astavie.thermallogistics.util.collection.ListWrapperWrapper;
import astavie.thermallogistics.util.collection.MissingList;
import astavie.thermallogistics.util.collection.StackList;
import astavie.thermallogistics.util.type.Type;
import cofh.thermaldynamics.duct.attachments.servo.ServoBase;
import cofh.thermaldynamics.duct.attachments.servo.ServoFluid;
import cofh.thermaldynamics.duct.attachments.servo.ServoItem;
import cofh.thermaldynamics.duct.fluid.GridFluid;
import cofh.thermaldynamics.duct.item.DuctUnitItem;
import cofh.thermaldynamics.duct.item.GridItem;
import cofh.thermaldynamics.duct.item.StackMap;
import cofh.thermaldynamics.duct.tiles.DuctUnit;
import cofh.thermaldynamics.multiblock.Route;
import cofh.thermaldynamics.util.ListWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public abstract class Recipe<I>
implements ICrafter<I>,
IProcessRequester<I> {
    public final List<RequesterReference<?>> linked = NonNullList.func_191196_a();
    public boolean enabled = false;
    public int index;
    public List<I> inputs = new ArrayList<I>();
    public List<I> outputs = new ArrayList<I>();
    public Map<RequesterReference<I>, StackList<I>> requestOutput = new LinkedHashMap<RequesterReference<I>, StackList<I>>();
    public StackList<I> leftovers;
    public StackList<I> missing;
    public Map<RequesterReference<I>, StackList<I>> requestInput = new LinkedHashMap<RequesterReference<I>, StackList<I>>();
    public Process<I> process;
    private ServoBase parent;
    private DuctUnit<?, ?, ?> duct;
    private Supplier<StackList<I>> supplier;

    public Recipe(ServoBase parent, DuctUnit<?, ?, ?> duct, Supplier<StackList<I>> supplier, int index) {
        this.parent = parent;
        this.duct = duct;
        this.supplier = supplier;
        this.leftovers = supplier.get();
        this.missing = supplier.get();
        this.index = index;
    }

    private static <I> void applyLinkedProposal(Proposal<I> linked) {
        ((ICrafter)linked.me.get()).applyProposal(null, linked);
    }

    public boolean isDone() {
        return !this.enabled || this.requestOutput.values().stream().allMatch(s -> s.isEmpty());
    }

    @Override
    public Collection<RequesterReference<?>> getLinked() {
        return this.linked;
    }

    @Override
    public boolean isLinked(RequesterReference<?> reference) {
        return this.linked.contains(reference);
    }

    @Override
    public void link(ICrafter<?> crafter) {
        Collection<RequesterReference<?>> collection;
        this.checkLinked();
        if (crafter instanceof Recipe) {
            ((Recipe)crafter).checkLinked();
        }
        RequesterReference<I> mee = this.createReference();
        RequesterReference you = crafter.createReference();
        LinkedList tmpLinked = new LinkedList(this.linked);
        for (RequesterReference<?> reference : this.linked) {
            collection = ((ICrafter)reference.get()).getLinked();
            collection.add(you);
            collection.addAll(crafter.getLinked());
        }
        this.linked.add(you);
        this.linked.addAll(crafter.getLinked());
        for (RequesterReference<?> reference : crafter.getLinked()) {
            collection = ((ICrafter)reference.get()).getLinked();
            collection.add(mee);
            collection.addAll(tmpLinked);
        }
        crafter.getLinked().add(mee);
        crafter.getLinked().addAll(tmpLinked);
        this.markDirty();
        this.setEnabled(false);
        for (RequesterReference<?> reference : this.linked) {
            ((ICrafter)reference.get()).setEnabled(false);
        }
    }

    private void markDirty() {
        this.parent.baseTile.markChunkDirty();
    }

    @Override
    public void unlink(ICrafter<?> crafter) {
        this.checkLinked();
        this.setEnabled(false);
        for (RequesterReference<?> reference : this.linked) {
            ((ICrafter)reference.get()).setEnabled(false);
        }
        RequesterReference reference = crafter.createReference();
        for (RequesterReference<?> link : this.linked) {
            ICrafter oldie = (ICrafter)link.get();
            oldie.unlink(reference);
            crafter.unlink(link);
        }
        this.linked.remove(reference);
        crafter.unlink(this.createReference());
        this.markDirty();
    }

    @Override
    public void link(RequesterReference<?> reference) {
        if (!this.isLinked(reference)) {
            this.linked.add(reference);
            this.markDirty();
        }
    }

    @Override
    public void unlink(RequesterReference<?> reference) {
        this.linked.remove(reference);
        this.markDirty();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled && this.parent.isPowered;
    }

    @Override
    public StackList<I> getOutputs() {
        return this.getCondensedOutputs();
    }

    public void onDisable() {
        this.requestOutput.clear();
        this.requestInput.clear();
        this.leftovers.clear();
        this.missing.clear();
    }

    @Override
    public boolean requestInternal(Type<I> type, long amount, MissingList missing, Proposal<I> proposal, Set<ICrafter<?>> used, long timeStarted, boolean doLinked) {
        if (System.currentTimeMillis() - timeStarted > (long)ThermalLogistics.INSTANCE.calculationTimeout) {
            return false;
        }
        if (!used.add(this)) {
            return false;
        }
        StackList<I> inputs = this.getCondensedInputs();
        boolean ignoreMod = this.parent.filter.getFlag(4);
        boolean ignoreOreDict = this.parent.filter.getFlag(3);
        boolean ignoreMetadata = this.parent.filter.getFlag(1);
        boolean ignoreNbt = this.parent.filter.getFlag(2);
        for (Type<I> type2 : inputs.types()) {
            long subAmount;
            if (this.process.requestInternal(missing, proposal, used, timeStarted, ignoreMod, ignoreOreDict, ignoreMetadata, ignoreNbt, type2, subAmount = inputs.amount((I)type2))) continue;
            return false;
        }
        if (doLinked) {
            this.checkLinked();
            for (RequesterReference requesterReference : this.linked) {
                if (this.requestLinked(requesterReference, missing, proposal, used, timeStarted)) continue;
                return false;
            }
        }
        used.remove(this);
        StackList<I> leftovers = Snapshot.INSTANCE.getLeftovers(this.createReference());
        leftovers.addAll(this.getCondensedOutputs());
        if (type != null) {
            leftovers.remove(type, amount);
        }
        return true;
    }

    public boolean updateMissing() {
        boolean done = false;
        LinkedList requests = new LinkedList();
        boolean ignoreMod = this.parent.filter.getFlag(4);
        boolean ignoreOreDict = this.parent.filter.getFlag(3);
        boolean ignoreMetadata = this.parent.filter.getFlag(1);
        boolean ignoreNbt = this.parent.filter.getFlag(2);
        for (Type<I> type : this.missing.types()) {
            long requested = this.process.request(type, this.missing.amount((I)type), requests, ignoreMod, ignoreOreDict, ignoreMetadata, ignoreNbt);
            if (requested <= 0L) continue;
            done = true;
            this.missing.remove(type, requested);
            this.markDirty();
        }
        for (Request request : requests) {
            if (request.isError()) continue;
            this.requestInput.computeIfAbsent(request.source.crafter, r -> this.supplier.get());
            this.requestInput.get(request.source.crafter).add(request.type, request.amount);
        }
        return done;
    }

    private <O> boolean requestLinked(RequesterReference<O> reference, MissingList missing, Proposal<I> proposal, Set<ICrafter<?>> used, long timeStarted) {
        Proposal<O> linked = new Proposal<O>(reference, null, 0L);
        ICrafter crafter = (ICrafter)reference.get();
        if (!crafter.requestInternal(null, 0L, missing, linked, used, timeStarted, false)) {
            return false;
        }
        proposal.linked.add(linked);
        return true;
    }

    @Override
    public void applyProposal(IRequester<I> requester, Proposal<I> proposal) {
        if (requester != null) {
            RequesterReference<I> reference = requester.createReference();
            this.requestOutput.computeIfAbsent(reference, r -> this.supplier.get());
            this.requestOutput.get(reference).add(proposal.type, proposal.amount);
        }
        for (Proposal proposal2 : proposal.children) {
            if (proposal2.missing) {
                this.missing.add(proposal2.type, proposal2.amount);
            } else {
                this.requestInput.computeIfAbsent(proposal2.me, r -> this.supplier.get());
                this.requestInput.get(proposal2.me).add(proposal2.type, proposal2.amount);
            }
            if (proposal2.me == null) continue;
            ((ICrafter)proposal2.me.get()).applyProposal(this, proposal2);
        }
        for (Proposal<Object> proposal3 : proposal.linked) {
            Recipe.applyLinkedProposal(proposal3);
        }
        this.markDirty();
    }

    @Override
    public void applyLeftovers(StackList<I> leftovers) {
        this.leftovers = leftovers;
        this.markDirty();
    }

    public void toggleEnabled() {
        this.checkLinked();
        this.setEnabled(!this.enabled);
        for (RequesterReference<?> reference : this.linked) {
            ((ICrafter)reference.get()).setEnabled(this.enabled);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (!enabled) {
            this.onDisable();
        }
        this.markDirty();
    }

    public void checkEnabled() {
        if (this.enabled) {
            for (RequesterReference<?> reference : this.linked) {
                if (((ICrafter)reference.get()).isEnabled()) continue;
                this.enabled = false;
                return;
            }
        }
    }

    public void check() {
        this.checkLinked();
        this.checkEnabled();
        this.checkOutput();
        this.balanceLeftovers();
    }

    public void checkOutput() {
        Iterator<Map.Entry<RequesterReference<I>, StackList<I>>> iterator = this.requestOutput.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<RequesterReference<I>, StackList<I>> entry = iterator.next();
            IRequester<I> requester = entry.getKey().get();
            if (requester == null) {
                this.leftovers.addAll(entry.getValue());
                iterator.remove();
                continue;
            }
            StackList<I> stacks = requester.getRequestedStacks(this);
            for (Type<I> type : entry.getValue().types()) {
                long dif = entry.getValue().amount((I)type) - stacks.amount((I)type);
                if (dif <= 0L) continue;
                this.leftovers.add(type, dif);
                entry.getValue().remove(type, dif);
                if (!entry.getValue().isEmpty()) continue;
                iterator.remove();
            }
        }
    }

    @Override
    public long getLeftoverRecipes() {
        long output = Long.MAX_VALUE;
        StackList<I> co = this.getCondensedOutputs();
        for (Type<I> type : co.types()) {
            output = Math.min(output, this.leftovers.amount((I)type) / co.amount((I)type));
        }
        if (output == 0L) {
            return 0L;
        }
        long input = Long.MAX_VALUE;
        boolean ignoreMod = this.parent.filter.getFlag(4);
        boolean ignoreOreDict = this.parent.filter.getFlag(3);
        boolean ignoreMetadata = this.parent.filter.getFlag(1);
        boolean ignoreNbt = this.parent.filter.getFlag(2);
        StackList<I> ci = this.getCondensedInputs();
        for (Type<I> type : ci.types()) {
            long i = this.missing.amount((I)type);
            for (StackList<I> in : this.getRequests().values()) {
                i += in.amount(type, ignoreMod, ignoreOreDict, ignoreMetadata, ignoreNbt);
            }
            input = Math.min(input, i / ci.amount((I)type));
        }
        if (input == 0L) {
            return 0L;
        }
        return Math.min(output, input);
    }

    private void balanceLeftovers() {
        long subtract = this.getLeftoverRecipes();
        if (subtract == 0L) {
            return;
        }
        for (RequesterReference<?> reference : this.linked) {
            if ((subtract = Math.min(subtract, ((ICrafter)reference.get()).getLeftoverRecipes())) != 0L) continue;
            return;
        }
        this.removeRecipes(subtract);
        for (RequesterReference<?> reference : this.linked) {
            ((ICrafter)reference.get()).removeRecipes(subtract);
        }
    }

    @Override
    public void removeRecipes(long subtract) {
        StackList<I> co = this.getCondensedOutputs();
        StackList<I> ci = this.getCondensedInputs();
        boolean ignoreMod = this.parent.filter.getFlag(4);
        boolean ignoreOreDict = this.parent.filter.getFlag(3);
        boolean ignoreMetadata = this.parent.filter.getFlag(1);
        boolean ignoreNbt = this.parent.filter.getFlag(2);
        for (Type<I> type : co.types()) {
            this.leftovers.remove(type, co.amount((I)type) * subtract);
        }
        for (Type<I> type : ci.types()) {
            long amount = ci.amount((I)type) * subtract;
            if ((amount = this.missing.remove(type, amount)) == 0L) continue;
            Iterator<Map.Entry<RequesterReference<I>, StackList<I>>> iterator = this.requestInput.entrySet().iterator();
            block2: while (iterator.hasNext() && amount > 0L) {
                Map.Entry<RequesterReference<I>, StackList<I>> entry = iterator.next();
                for (Type<I> compare : entry.getValue().types()) {
                    IRequester<I> requester;
                    long remain;
                    long subtracted;
                    if (!compare.isIdentical(type, ignoreMod, ignoreOreDict, ignoreMetadata, ignoreNbt) || (subtracted = amount - (remain = entry.getValue().remove(compare, amount))) <= 0L) continue;
                    if (entry.getValue().isEmpty()) {
                        iterator.remove();
                    }
                    amount = remain;
                    if (entry.getKey() != null && (requester = entry.getKey().get()) instanceof ICrafter) {
                        ((ICrafter)entry.getKey().get()).cancel(this, compare, subtracted);
                    }
                    if (amount != 0L) continue;
                    continue block2;
                }
            }
        }
        this.markDirty();
    }

    private StackList<I> getCondensedInputs() {
        StackList<I> list = this.supplier.get();
        for (I stack : this.inputs) {
            list.add(stack);
        }
        return list;
    }

    private StackList<I> getCondensedOutputs() {
        StackList<I> list = this.supplier.get();
        for (I stack : this.outputs) {
            list.add(stack);
        }
        return list;
    }

    @Override
    public void cancel(IRequester<I> requester, Type<I> type, long amount) {
        StackList<I> list;
        RequesterReference<I> reference = requester.createReference();
        if (this.requestOutput.containsKey(reference) && (list = this.requestOutput.get(reference)) != null) {
            amount -= list.remove(type, amount);
            if (list.isEmpty()) {
                this.requestOutput.remove(reference);
                this.markDirty();
            }
            this.leftovers.add(type, amount);
            this.markDirty();
        }
        this.checkLinked();
        this.balanceLeftovers();
    }

    @Override
    public void onFail(Type<I> type, long amount) {
        this.onFail(null, type, amount);
    }

    @Override
    public void onFail(RequesterReference<I> reference, Type<I> type, long amount) {
        StackList<I> list;
        if (this.requestInput.containsKey(reference) && (list = this.requestInput.get(reference)) != null) {
            long remain = list.remove(type, amount);
            amount -= remain;
            this.markDirty();
            if (list.isEmpty()) {
                this.requestInput.remove(reference);
            }
        }
        if (amount == 0L) {
            return;
        }
        boolean ignoreMod = this.parent.filter.getFlag(4);
        boolean ignoreOreDict = this.parent.filter.getFlag(3);
        boolean ignoreMetadata = this.parent.filter.getFlag(1);
        boolean ignoreNbt = this.parent.filter.getFlag(2);
        for (Type<I> t : this.getCondensedInputs().types()) {
            if (!t.isIdentical(type, ignoreMod, ignoreOreDict, ignoreMetadata, ignoreNbt)) continue;
            this.missing.add(t, amount);
            break;
        }
    }

    @Override
    public long reserved(IRequester<I> requester, Type<I> type) {
        return ((StackList)this.requestOutput.getOrDefault(requester.createReference(), EmptyList.getInstance())).amount(type);
    }

    @Override
    public void finish(IRequester<I> requester, Type<I> type, long amount) {
        ((StackList)this.requestOutput.getOrDefault(requester.createReference(), EmptyList.getInstance())).remove(type, amount);
        this.markDirty();
    }

    @Override
    public boolean referencedBy(RequesterReference<?> reference) {
        return reference.dim == this.parent.baseTile.world().field_73011_w.getDimension() && reference.pos.equals((Object)this.parent.baseTile.func_174877_v()) && reference.side == this.parent.side && reference.index == this.index;
    }

    @Override
    public RequesterReference<I> createReference() {
        return new RequesterReference(this.parent.baseTile.world().field_73011_w.getDimension(), this.parent.baseTile.func_174877_v(), this.parent.side, this.index);
    }

    @Override
    public ItemStack getIcon() {
        return this.parent.getPickBlock();
    }

    @Override
    public ItemStack getTileIcon() {
        TileEntity tile = (TileEntity)ReflectionHelper.getPrivateValue(ServoBase.class, (Object)this.parent, (String[])new String[]{"myTile"});
        return tile == null ? ItemStack.field_190927_a : tile.func_145838_q().func_185473_a(tile.func_145831_w(), tile.func_174877_v(), tile.func_145831_w().func_180495_p(tile.func_174877_v()));
    }

    @Override
    public BlockPos getDestination() {
        return this.parent.baseTile.func_174877_v().func_177972_a(EnumFacing.func_82600_a((int)this.parent.side));
    }

    @Override
    public DuctUnit<?, ?, ?> getDuct() {
        return this.duct;
    }

    @Override
    public byte getSide() {
        return (byte)(this.parent.side ^ 1);
    }

    @Override
    public StackList<I> getRequestedStacks() {
        return this.requestInput.getOrDefault(null, this.supplier.get());
    }

    @Override
    public StackList<I> getRequestedStacks(ICrafter<I> crafter) {
        return this.requestInput.getOrDefault(crafter.createReference(), this.supplier.get());
    }

    @Override
    public void checkLinked() {
        Iterator<RequesterReference<?>> iterator = this.linked.iterator();
        while (iterator.hasNext()) {
            IRequester<?> requester = iterator.next().get();
            if (!(requester instanceof ICrafter)) {
                iterator.remove();
                this.markDirty();
                continue;
            }
            ICrafter crafter = (ICrafter)requester;
            if (crafter.isLinked(this.createReference())) continue;
            iterator.remove();
            this.markDirty();
        }
    }

    @Override
    public Map<RequesterReference<I>, StackList<I>> getRequests() {
        HashMap<RequesterReference<I>, StackList<I>> copy = new HashMap<RequesterReference<I>, StackList<I>>();
        for (Map.Entry<RequesterReference<I>, StackList<I>> entry : this.requestInput.entrySet()) {
            copy.put(entry.getKey(), entry.getValue().copy());
        }
        return copy;
    }

    @Override
    public void onCrafterSend(ICrafter<I> crafter, Type<I> type, long amount) {
        long remain = this.requestInput.getOrDefault(crafter.createReference(), this.supplier.get()).remove(type, amount);
        long subtracted = amount - remain;
        this.requestInput.computeIfAbsent(null, n -> this.supplier.get());
        this.requestInput.get(null).add(type, subtracted);
        this.markDirty();
    }

    @Override
    public void addRequest(Request<I> request) {
    }

    @Override
    public boolean hasWants() {
        return false;
    }

    @Override
    public long amountRequired(Type<I> type) {
        return 0L;
    }

    @Override
    public StackList<I> getLeftovers() {
        return this.leftovers;
    }

    public static class Fluid
    extends Recipe<FluidStack>
    implements IProcessRequesterFluid {
        private final CrafterFluid parent;

        public Fluid(CrafterFluid parent, int index) {
            super((ServoBase)parent, (DuctUnit<?, ?, ?>)parent.fluidDuct, FluidList::new, index);
            this.parent = parent;
            this.process = new ProcessFluid(this);
        }

        @Override
        public int tickDelay() {
            return ServoItem.tickDelays[this.parent.type];
        }

        @Override
        public float throttle() {
            return ServoFluid.throttle[this.parent.type];
        }

        @Override
        public int maxSize() {
            return ServoItem.maxSize[this.parent.type] * 1000;
        }

        @Override
        public ListWrapper<Pair<DuctUnit<?, ?, ?>, Byte>> getSources() {
            return RequesterFluid.getSources(this.parent.fluidDuct, this.parent.side);
        }

        @Override
        public Map<RequesterReference<FluidStack>, StackList<FluidStack>> getRequests() {
            Map<RequesterReference<FluidStack>, StackList<FluidStack>> requests = super.getRequests();
            if (requests.containsKey(null)) {
                StackList<FluidStack> list = requests.get(null);
                FluidStack fluid = ((GridFluid)this.getDuct().getGrid()).myTank.getFluid();
                if (fluid != null) {
                    list.remove(fluid);
                }
            }
            return requests;
        }
    }

    public static class Item
    extends Recipe<ItemStack>
    implements IProcessRequesterItem {
        private final CrafterItem parent;

        public Item(CrafterItem parent, int index) {
            super((ServoBase)parent, (DuctUnit<?, ?, ?>)parent.itemDuct, ItemList::new, index);
            this.parent = parent;
            this.process = new ProcessItem(this);
        }

        @Override
        public long amountEmpty(Type<ItemStack> type) {
            return Math.max((long)this.parent.filter.getMaxStock() - this.amountInside(type), 0L);
        }

        private long amountInside(Type<ItemStack> type) {
            DuctUnitItem.Cache cache = ((DuctUnitItem.Cache[])this.parent.itemDuct.tileCache)[this.parent.side];
            if (cache == null) {
                return 0L;
            }
            IItemHandler inv = cache.getItemHandler(this.parent.side ^ 1);
            if (inv == null) {
                return 0L;
            }
            int travelling = 0;
            StackMap map = ((GridItem)this.parent.itemDuct.getGrid()).travelingItems.getOrDefault(this.getDestination(), new StackMap());
            for (ItemStack item : map.getItems()) {
                if (!type.references(item)) continue;
                travelling += item.func_190916_E();
            }
            return DuctUnitItem.getNumItems((IItemHandler)inv, (int)(this.parent.side ^ 1), (ItemStack)type.getAsStack(), (int)Integer.MAX_VALUE) + travelling;
        }

        @Override
        public int maxSize() {
            return this.parent.getMaxSend();
        }

        @Override
        public boolean multiStack() {
            return ServoItem.multiStack[this.parent.type];
        }

        @Override
        public byte speedBoost() {
            return this.parent.getSpeed();
        }

        @Override
        public ListWrapper<Pair<DuctUnit<?, ?, ?>, Byte>> getSources() {
            if (!this.parent.verifyCache()) {
                return new EmptyListWrapper();
            }
            return new ListWrapperWrapper<Route, Pair>(this.parent.routesWithInsertSideList, r -> Pair.of((Object)((DuctUnit)r.endPoint), (Object)r.getLastSide()));
        }

        @Override
        public StackList<ItemStack> getRequestedStacks() {
            StackList<ItemStack> list = super.getRequestedStacks().copy();
            StackMap map = ((GridItem)this.getDuct().getGrid()).travelingItems.getOrDefault(this.getDestination(), new StackMap());
            for (ItemStack item : map.getItems()) {
                list.remove(item);
            }
            return list;
        }

        @Override
        public Map<RequesterReference<ItemStack>, StackList<ItemStack>> getRequests() {
            Map<RequesterReference<ItemStack>, StackList<ItemStack>> requests = super.getRequests();
            if (requests.containsKey(null)) {
                StackList<ItemStack> list = requests.get(null);
                StackMap map = ((GridItem)this.getDuct().getGrid()).travelingItems.getOrDefault(this.getDestination(), new StackMap());
                for (ItemStack item : map.getItems()) {
                    list.remove(item);
                }
            }
            return requests;
        }
    }
}

