/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.attachment;

import astavie.thermallogistics.ThermalLogistics;
import astavie.thermallogistics.attachment.CrafterItem;
import astavie.thermallogistics.attachment.IAttachmentCrafter;
import astavie.thermallogistics.attachment.ICrafter;
import astavie.thermallogistics.attachment.Recipe;
import astavie.thermallogistics.client.TLTextures;
import astavie.thermallogistics.client.gui.GuiCrafter;
import astavie.thermallogistics.compat.ICrafterWrapper;
import astavie.thermallogistics.container.ContainerCrafter;
import astavie.thermallogistics.util.RequesterReference;
import astavie.thermallogistics.util.StackHandler;
import astavie.thermallogistics.util.collection.EmptyList;
import astavie.thermallogistics.util.collection.FluidList;
import astavie.thermallogistics.util.collection.StackList;
import astavie.thermallogistics.util.type.FluidType;
import astavie.thermallogistics.util.type.Type;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.IconTransformation;
import cofh.api.tileentity.IRedstoneControl;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketTileInfo;
import cofh.core.util.helpers.BlockHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.thermaldynamics.ThermalDynamics;
import cofh.thermaldynamics.duct.attachments.filter.IFilterFluid;
import cofh.thermaldynamics.duct.attachments.servo.ServoFluid;
import cofh.thermaldynamics.duct.fluid.DuctUnitFluid;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import cofh.thermaldynamics.render.RenderDuct;
import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class CrafterFluid
extends ServoFluid
implements IAttachmentCrafter<FluidStack> {
    public static final ResourceLocation ID = new ResourceLocation("thermallogistics", "crafter_fluid");
    private final List<Recipe<FluidStack>> recipes = NonNullList.func_191196_a();
    private final IFilterFluid filter2 = fluid -> this.checkCache() && this.matchesInput(fluid);
    private boolean processParallel = false;
    private int currentRecipe = 0;

    public CrafterFluid(TileGrid tile, byte side) {
        super(tile, side);
        this.rsMode = IRedstoneControl.ControlMode.DISABLED;
    }

    public CrafterFluid(TileGrid tile, byte side, int type) {
        super(tile, side, type);
        Recipe<FluidStack> recipe = this.newRecipe(0);
        recipe.inputs.addAll(Collections.nCopies(CrafterItem.SIZE[type] * 2, null));
        recipe.outputs.addAll(Collections.nCopies(CrafterItem.SIZE[type], null));
        this.recipes.add(recipe);
        this.rsMode = IRedstoneControl.ControlMode.DISABLED;
    }

    @Override
    public boolean processParallel() {
        return this.processParallel;
    }

    @Override
    public void processParallel(boolean parallel) {
        this.processParallel = parallel;
    }

    @Override
    public int currentRecipe() {
        return this.currentRecipe;
    }

    public boolean canAlterRS() {
        return false;
    }

    private Recipe<FluidStack> newRecipe(int index) {
        return new Recipe.Fluid(this, index);
    }

    public IFilterFluid getFluidFilter() {
        return this.filter2;
    }

    private boolean matchesInput(FluidStack fluid) {
        for (Recipe<FluidStack> recipe : this.recipes) {
            for (FluidStack stack : recipe.inputs) {
                if (stack == null || !stack.isFluidEqual(fluid)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canSend() {
        return false;
    }

    public boolean allowDuctConnection() {
        return true;
    }

    public String getInfo() {
        return "tab.thermallogistics.crafterItem";
    }

    public ResourceLocation getId() {
        return ID;
    }

    public ItemStack getPickBlock() {
        return new ItemStack((Item)ThermalLogistics.Items.crafter, 1, this.type);
    }

    public String getName() {
        return this.getPickBlock().func_77977_a() + ".name";
    }

    public boolean render(IBlockAccess world, BlockRenderLayer layer, CCRenderState ccRenderState) {
        if (layer != BlockRenderLayer.SOLID) {
            return false;
        }
        Translation trans = Vector3.fromTileCenter((TileEntity)this.baseTile).translation();
        RenderDuct.modelConnection[this.isPowered ? 1 : 2][this.side].render(ccRenderState, new IVertexOperation[]{trans, new IconTransformation(TLTextures.CRAFTER[this.stuffed ? 1 : 0][this.type])});
        return true;
    }

    public void tick(int pass) {
        if (pass == 0) {
            this.checkCache();
        }
        if (pass != 1 || this.fluidDuct.getGrid() == null || !this.isPowered || !this.isValidInput) {
            return;
        }
        for (Recipe<FluidStack> recipe : this.recipes) {
            recipe.check();
        }
        boolean onlyCheck = false;
        for (int i = 0; i < this.recipes.size(); ++i) {
            boolean actuallyDoIt;
            Recipe<FluidStack> recipe = this.recipes.get(i);
            if (!recipe.isEnabled()) continue;
            boolean bl = actuallyDoIt = !onlyCheck && (this.processParallel || this.currentRecipe == i);
            if (actuallyDoIt) {
                onlyCheck = recipe.updateMissing();
            }
            if (!recipe.process.update(!actuallyDoIt)) continue;
            onlyCheck = true;
        }
        if (!this.processParallel) {
            int lastRecipe = this.currentRecipe;
            if (this.currentRecipe == -1) {
                this.currentRecipe = 0;
            }
            while (this.currentRecipe < this.recipes.size() && this.recipes.get(this.currentRecipe).isDone()) {
                ++this.currentRecipe;
            }
            if (this.currentRecipe >= this.recipes.size()) {
                this.currentRecipe = 0;
            }
            while (this.currentRecipe < lastRecipe && this.recipes.get(this.currentRecipe).isDone()) {
                ++this.currentRecipe;
            }
            if (this.recipes.get(this.currentRecipe).isDone()) {
                this.currentRecipe = -1;
            }
            if (lastRecipe != this.currentRecipe) {
                PacketHandler.sendToAllAround((PacketBase)this.getGuiPacket(), (TileEntity)this.baseTile);
            }
        } else {
            this.currentRecipe = -1;
        }
    }

    private boolean checkCache() {
        if (((DuctUnitFluid.Cache[])this.fluidDuct.tileCache)[this.side] != null && !(((DuctUnitFluid.Cache[])this.fluidDuct.tileCache)[this.side] instanceof CacheWrapper)) {
            ((DuctUnitFluid.Cache[])this.fluidDuct.tileCache)[this.side] = new CacheWrapper(((DuctUnitFluid.Cache[])this.fluidDuct.tileCache)[this.side].tile, this);
            return false;
        }
        return true;
    }

    @Override
    public Class<FluidStack> getItemClass() {
        return FluidStack.class;
    }

    @Override
    public List<Recipe<FluidStack>> getRecipes() {
        return this.recipes;
    }

    @Override
    public Supplier<StackList<FluidStack>> getSupplier() {
        return FluidList::new;
    }

    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        NBTTagList recipes = new NBTTagList();
        for (Recipe<FluidStack> recipe : this.recipes) {
            Object stack22;
            NBTTagList inputs = new NBTTagList();
            for (Object stack22 : recipe.inputs) {
                inputs.func_74742_a((NBTBase)(stack22 == null ? new NBTTagCompound() : stack22.writeToNBT(new NBTTagCompound())));
            }
            NBTTagList outputs = new NBTTagList();
            stack22 = recipe.outputs.iterator();
            while (stack22.hasNext()) {
                FluidStack stack3 = (FluidStack)stack22.next();
                outputs.func_74742_a((NBTBase)(stack3 == null ? new NBTTagCompound() : stack3.writeToNBT(new NBTTagCompound())));
            }
            NBTTagList linked = new NBTTagList();
            for (RequesterReference requesterReference : recipe.linked) {
                linked.func_74742_a((NBTBase)RequesterReference.writeNBT(requesterReference));
            }
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74782_a("inputs", (NBTBase)inputs);
            nbt.func_74782_a("outputs", (NBTBase)outputs);
            nbt.func_74782_a("linked", (NBTBase)linked);
            nbt.func_74782_a("requestInput", (NBTBase)StackHandler.writeRequestMap(recipe.requestInput));
            nbt.func_74782_a("requestOutput", (NBTBase)StackHandler.writeRequestMap(recipe.requestOutput));
            nbt.func_74782_a("leftovers", (NBTBase)recipe.leftovers.writeNbt());
            nbt.func_74782_a("missing", (NBTBase)recipe.missing.writeNbt());
            nbt.func_74757_a("disabled", !recipe.enabled);
            recipes.func_74742_a((NBTBase)nbt);
        }
        tag.func_74757_a("parallel", this.processParallel);
        tag.func_74768_a("recipe", this.currentRecipe);
        tag.func_74782_a("recipes", (NBTBase)recipes);
    }

    public void readFromNBT(NBTTagCompound tag) {
        boolean enabled;
        super.readFromNBT(tag);
        this.recipes.clear();
        boolean bl = enabled = tag.func_74764_b("rsMode") && tag.func_74771_c("rsMode") == 0;
        if (tag.func_74764_b("Inputs") || tag.func_74764_b("Outputs") || tag.func_74764_b("Linked")) {
            Recipe<FluidStack> recipe = this.newRecipe(0);
            recipe.enabled = true;
            recipe.inputs.addAll(Collections.nCopies(CrafterItem.SIZE[this.type] * 2, null));
            recipe.outputs.addAll(Collections.nCopies(CrafterItem.SIZE[this.type], null));
            NBTTagList inputs = tag.func_150295_c("Inputs", 10);
            for (int i = 0; i < inputs.func_74745_c(); ++i) {
                NBTTagCompound compound = inputs.func_150305_b(i);
                recipe.inputs.set(compound.func_74762_e("Slot"), FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound));
            }
            NBTTagList outputs = tag.func_150295_c("Outputs", 10);
            for (int i = 0; i < outputs.func_74745_c(); ++i) {
                NBTTagCompound compound = outputs.func_150305_b(i);
                recipe.outputs.set(compound.func_74762_e("Slot"), FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound));
            }
            this.recipes.add(recipe);
            NBTTagList linked = tag.func_150295_c("Linked", 10);
            for (int i = 0; i < linked.func_74745_c(); ++i) {
                NBTTagCompound compound = linked.func_150305_b(i);
                recipe.linked.add(RequesterReference.readNBT(compound));
            }
        } else if (tag.func_74764_b("sent") || tag.func_74764_b("process") || tag.func_74764_b("linked")) {
            NBTTagList recipes = tag.func_150295_c("recipes", 10);
            for (int i = 0; i < recipes.func_74745_c(); ++i) {
                NBTTagCompound nbt = recipes.func_150305_b(i);
                Recipe<FluidStack> recipe = this.newRecipe(i);
                recipe.enabled = enabled;
                NBTTagList inputs = nbt.func_150295_c("inputs", 10);
                for (int j = 0; j < inputs.func_74745_c(); ++j) {
                    recipe.inputs.add(FluidStack.loadFluidStackFromNBT((NBTTagCompound)inputs.func_150305_b(j)));
                }
                NBTTagList outputs = nbt.func_150295_c("outputs", 10);
                for (int j = 0; j < outputs.func_74745_c(); ++j) {
                    recipe.outputs.add(FluidStack.loadFluidStackFromNBT((NBTTagCompound)outputs.func_150305_b(j)));
                }
                this.recipes.add(recipe);
            }
            NBTTagList linked = tag.func_150295_c("linked", 10);
            for (int i = 0; i < linked.func_74745_c(); ++i) {
                NBTTagCompound compound = linked.func_150305_b(i);
                for (int j = 0; j < this.recipes.size(); ++j) {
                    compound.func_74768_a("index", j);
                    this.recipes.get((int)j).linked.add(RequesterReference.readNBT(compound));
                }
            }
        } else {
            this.processParallel = tag.func_74767_n("parallel");
            this.currentRecipe = tag.func_74762_e("recipe");
            NBTTagList recipes = tag.func_150295_c("recipes", 10);
            for (int i = 0; i < recipes.func_74745_c(); ++i) {
                NBTTagCompound nbt = recipes.func_150305_b(i);
                Recipe<FluidStack> recipe = this.newRecipe(i);
                NBTTagList inputs = nbt.func_150295_c("inputs", 10);
                for (int j = 0; j < inputs.func_74745_c(); ++j) {
                    recipe.inputs.add(FluidStack.loadFluidStackFromNBT((NBTTagCompound)inputs.func_150305_b(j)));
                }
                NBTTagList outputs = nbt.func_150295_c("outputs", 10);
                for (int j = 0; j < outputs.func_74745_c(); ++j) {
                    recipe.outputs.add(FluidStack.loadFluidStackFromNBT((NBTTagCompound)outputs.func_150305_b(j)));
                }
                NBTTagList linked = nbt.func_150295_c("linked", 10);
                for (int j = 0; j < linked.func_74745_c(); ++j) {
                    recipe.linked.add(RequesterReference.readNBT(linked.func_150305_b(j)));
                }
                recipe.requestInput = StackHandler.readRequestMap(nbt.func_150295_c("requestInput", 10), FluidList::new);
                recipe.requestOutput = StackHandler.readRequestMap(nbt.func_150295_c("requestOutput", 10), FluidList::new);
                recipe.leftovers.readNbt(nbt.func_150295_c("leftovers", 10));
                recipe.missing.readNbt(nbt.func_150295_c("missing", 10));
                recipe.enabled = enabled || nbt.func_74764_b("disabled") && !nbt.func_74767_n("disabled");
                this.recipes.add(recipe);
            }
        }
    }

    public void writePortableData(EntityPlayer player, NBTTagCompound tag) {
        super.writePortableData(player, tag);
        NBTTagList recipes = new NBTTagList();
        for (Recipe<FluidStack> recipe : this.recipes) {
            Object stack2;
            NBTTagList inputs = new NBTTagList();
            for (Object stack2 : recipe.inputs) {
                inputs.func_74742_a((NBTBase)(stack2 == null ? new NBTTagCompound() : stack2.writeToNBT(new NBTTagCompound())));
            }
            NBTTagList outputs = new NBTTagList();
            stack2 = recipe.outputs.iterator();
            while (stack2.hasNext()) {
                FluidStack stack3 = (FluidStack)stack2.next();
                outputs.func_74742_a((NBTBase)(stack3 == null ? new NBTTagCompound() : stack3.writeToNBT(new NBTTagCompound())));
            }
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74782_a("inputs", (NBTBase)inputs);
            nbt.func_74782_a("outputs", (NBTBase)outputs);
            recipes.func_74742_a((NBTBase)nbt);
        }
        tag.func_74778_a("DisplayType", new ItemStack((Item)ThermalLogistics.Items.crafter).func_77977_a() + ".name");
        tag.func_74768_a("recipesType", this.type);
        tag.func_74778_a("recipesClass", "FluidStack");
        tag.func_74782_a("recipes", (NBTBase)recipes);
    }

    public void readPortableData(EntityPlayer player, NBTTagCompound tag) {
        super.readPortableData(player, tag);
        if (tag.func_74762_e("recipesType") == this.type && tag.func_74779_i("recipesClass").equals("FluidStack")) {
            this.processParallel = tag.func_74767_n("parallel");
            this.recipes.clear();
            NBTTagList recipes = tag.func_150295_c("recipes", 10);
            for (int i = 0; i < recipes.func_74745_c(); ++i) {
                NBTTagCompound nbt = recipes.func_150305_b(i);
                Recipe<FluidStack> recipe = this.newRecipe(i);
                NBTTagList inputs = nbt.func_150295_c("inputs", 10);
                for (int j = 0; j < inputs.func_74745_c(); ++j) {
                    recipe.inputs.add(FluidStack.loadFluidStackFromNBT((NBTTagCompound)inputs.func_150305_b(j)));
                }
                NBTTagList outputs = nbt.func_150295_c("outputs", 10);
                for (int j = 0; j < outputs.func_74745_c(); ++j) {
                    recipe.outputs.add(FluidStack.loadFluidStackFromNBT((NBTTagCompound)outputs.func_150305_b(j)));
                }
                this.recipes.add(recipe);
            }
            this.markDirty();
        }
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerCrafter(inventory, this);
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiCrafter(inventory, this);
    }

    public void handleInfoPacketType(byte a, PacketBase payload, boolean isServer, EntityPlayer player) {
        if (a == 0) {
            if (isServer) {
                byte message = payload.getByte();
                if (message == 0) {
                    int recipe = payload.getInt();
                    boolean input = payload.getBool();
                    int index = payload.getInt();
                    FluidStack stack = payload.getFluidStack();
                    if (recipe < this.recipes.size()) {
                        Recipe<FluidStack> r = this.recipes.get(recipe);
                        if (input) {
                            if (index < r.inputs.size()) {
                                r.inputs.set(index, stack);
                                this.markDirty();
                            }
                        } else if (index < r.outputs.size()) {
                            r.outputs.set(index, stack);
                            this.markDirty();
                        }
                    }
                } else if (message == 1) {
                    int split = payload.getInt();
                    if (Ints.contains((int[])CrafterItem.SPLITS[this.type], (int)split)) {
                        this.split(split);
                        this.markDirty();
                    }
                } else if (message == 2) {
                    int index1 = payload.getInt();
                    int index2 = payload.getInt();
                    if (index1 < this.recipes.size()) {
                        Recipe<FluidStack> recipe = this.recipes.get(index1);
                        if (index2 < recipe.linked.size()) {
                            recipe.unlink((ICrafter)recipe.linked.get(index2).get());
                        }
                    }
                } else if (message == 3) {
                    ICrafterWrapper<?> wrapper;
                    TileEntity tile = BlockHelper.getAdjacentTileEntity((TileEntity)this.baseTile, (int)this.side);
                    if (tile != null && (wrapper = ThermalLogistics.INSTANCE.getWrapper(tile.getClass())) != null) {
                        List<RequesterReference<?>> linked = this.recipes.get((int)0).linked;
                        this.recipes.clear();
                        Recipe<FluidStack> recipe = this.newRecipe(0);
                        recipe.inputs.addAll(Collections.nCopies(CrafterItem.SIZE[this.type] * 2, null));
                        recipe.outputs.addAll(Collections.nCopies(CrafterItem.SIZE[this.type], null));
                        wrapper.populateCast(tile, (byte)(this.side ^ 1), recipe, FluidStack.class);
                        recipe.linked.addAll(linked);
                        this.recipes.add(recipe);
                        this.markDirty();
                    }
                } else if (message == 4) {
                    int recipe = payload.getInt();
                    if (recipe < this.recipes.size()) {
                        int i;
                        Recipe<FluidStack> r = this.recipes.get(recipe);
                        for (i = 0; i < r.inputs.size(); ++i) {
                            r.inputs.set(i, payload.getFluidStack());
                        }
                        for (i = 0; i < r.outputs.size(); ++i) {
                            r.outputs.set(i, payload.getFluidStack());
                        }
                        this.markDirty();
                    }
                } else if (message == 5) {
                    ItemStack stack;
                    int index = payload.getInt();
                    if (index >= 0 && index < this.recipes.size() && (stack = player.field_71071_by.func_70445_o()).func_77973_b() == ThermalLogistics.Items.manager) {
                        ThermalLogistics.Items.manager.link(player, stack, (ICrafter)this.recipes.get(index));
                        ((EntityPlayerMP)player).func_71113_k();
                        this.markDirty();
                    }
                } else if (message == 6) {
                    int index = payload.getInt();
                    if (index >= 0 && index < this.recipes.size()) {
                        Recipe<FluidStack> recipe = this.recipes.get(index);
                        recipe.toggleEnabled();
                        this.markDirty();
                    }
                } else if (message == 7) {
                    this.processParallel = !this.processParallel;
                    this.markDirty();
                }
                PacketHandler.sendToAllAround((PacketBase)this.getGuiPacket(), (TileEntity)this.baseTile);
            } else {
                int j;
                Recipe<FluidStack> recipe;
                int i;
                int size;
                byte message = payload.getByte();
                if (message == 0) {
                    this.recipes.clear();
                    size = payload.getInt();
                    for (i = 0; i < size; ++i) {
                        recipe = this.newRecipe(i);
                        int inputs = payload.getInt();
                        for (j = 0; j < inputs; ++j) {
                            recipe.inputs.add(payload.getFluidStack());
                        }
                        int outputs = payload.getInt();
                        for (int j2 = 0; j2 < outputs; ++j2) {
                            recipe.outputs.add(payload.getFluidStack());
                        }
                        recipe.enabled = payload.getBool();
                        this.recipes.add(recipe);
                    }
                    this.processParallel = payload.getBool();
                    this.currentRecipe = payload.getInt();
                }
                if (message == 0 || message == 1) {
                    size = payload.getInt();
                    for (i = 0; i < size && i < this.recipes.size(); ++i) {
                        recipe = this.recipes.get(i);
                        int linked = payload.getInt();
                        recipe.linked.clear();
                        for (j = 0; j < linked; ++j) {
                            recipe.linked.add(RequesterReference.readPacket(payload));
                        }
                        recipe.requestInput = StackHandler.readRequestMap(payload, FluidList::new);
                        recipe.missing.readPacket(payload);
                        recipe.requestOutput = StackHandler.readRequestMap(payload, FluidList::new);
                        recipe.leftovers.readPacket(payload);
                    }
                }
            }
        } else {
            super.handleInfoPacketType(a, payload, isServer, player);
        }
    }

    public boolean openGui(EntityPlayer player) {
        if (ServerHelper.isServerWorld((World)this.baseTile.world())) {
            PacketHandler.sendTo((PacketBase)this.getGuiPacket(), (EntityPlayer)player);
            player.openGui((Object)ThermalDynamics.instance, 10 + this.side, this.baseTile.func_145831_w(), this.baseTile.x(), this.baseTile.y(), this.baseTile.z());
        }
        return true;
    }

    private PacketTileInfo getGuiPacket() {
        PacketTileInfo packet = this.getNewPacket((byte)0);
        packet.addByte(0);
        packet.addInt(this.recipes.size());
        for (Recipe<FluidStack> recipe : this.recipes) {
            packet.addInt(recipe.inputs.size());
            for (FluidStack input : recipe.inputs) {
                packet.addFluidStack(input);
            }
            packet.addInt(recipe.outputs.size());
            for (FluidStack output : recipe.outputs) {
                packet.addFluidStack(output);
            }
            packet.addBool(recipe.enabled);
        }
        packet.addBool(this.processParallel);
        packet.addInt(this.currentRecipe);
        this.writeSyncPacket(packet);
        return packet;
    }

    private void writeSyncPacket(PacketTileInfo packet) {
        this.checkLinked();
        packet.addInt(this.recipes.size());
        for (Recipe<FluidStack> recipe : this.recipes) {
            packet.addInt(recipe.linked.size());
            for (RequesterReference<?> reference : recipe.linked) {
                RequesterReference.writePacket((PacketBase)packet, reference);
            }
            StackHandler.writeRequestMap(recipe.requestInput, (PacketBase)packet);
            recipe.missing.writePacket((PacketBase)packet);
            StackHandler.writeRequestMap(recipe.requestOutput, (PacketBase)packet);
            recipe.leftovers.writePacket((PacketBase)packet);
        }
    }

    private void checkLinked() {
        for (Recipe<FluidStack> recipe : this.recipes) {
            recipe.checkLinked();
        }
    }

    @Override
    public void split(int split) {
        FluidStack[] inputs = new FluidStack[CrafterItem.SIZE[this.type] * 2];
        FluidStack[] outputs = new FluidStack[CrafterItem.SIZE[this.type]];
        int recipeSize = CrafterItem.SIZE[this.type] / this.recipes.size();
        for (int i = 0; i < this.recipes.size(); ++i) {
            Recipe<FluidStack> recipe = this.recipes.get(i);
            for (int j = 0; j < recipeSize; ++j) {
                inputs[(i * recipeSize + j) * 2] = (FluidStack)recipe.inputs.get(j * 2);
                inputs[(i * recipeSize + j) * 2 + 1] = (FluidStack)recipe.inputs.get(j * 2 + 1);
                outputs[i * recipeSize + j] = (FluidStack)recipe.outputs.get(j);
            }
        }
        List lists = this.recipes.stream().map(r -> r.linked).collect(Collectors.toList());
        this.recipes.clear();
        int recipes = CrafterItem.SIZE[this.type] / split;
        for (int i = 0; i < recipes; ++i) {
            Recipe<FluidStack> recipe = this.newRecipe(i);
            for (int j = 0; j < split; ++j) {
                recipe.inputs.add(inputs[(i * split + j) * 2]);
                recipe.inputs.add(inputs[(i * split + j) * 2 + 1]);
                recipe.outputs.add(outputs[i * split + j]);
            }
            if (i < lists.size()) {
                recipe.linked.addAll((Collection)lists.get(i));
            }
            this.recipes.add(recipe);
        }
    }

    @Override
    public void sync(EntityPlayer player) {
        PacketTileInfo packet = this.getNewPacket((byte)0);
        packet.addByte(1);
        this.writeSyncPacket(packet);
        PacketHandler.sendTo((PacketBase)packet, (EntityPlayer)player);
    }

    @Override
    public void markDirty() {
        this.baseTile.markChunkDirty();
    }

    @Override
    public List<? extends ICrafter<FluidStack>> getCrafters() {
        return this.recipes;
    }

    private void handleInsertedStack(Type<FluidStack> type, long amount) {
        for (Recipe<FluidStack> recipe : this.recipes) {
            amount = ((StackList)recipe.requestInput.getOrDefault(null, EmptyList.getInstance())).remove(type, amount);
            if (amount != 0L) continue;
            return;
        }
    }

    private static class Tank
    implements IFluidHandler {
        private final CrafterFluid crafter;
        private final IFluidHandler inv;

        private Tank(CrafterFluid crafter, IFluidHandler inv) {
            this.crafter = crafter;
            this.inv = inv;
        }

        public IFluidTankProperties[] getTankProperties() {
            return this.inv.getTankProperties();
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (!doFill && StackHandler.SIM) {
                return this.inv.fill(resource, false);
            }
            long required = 0L;
            FluidType type = new FluidType(resource);
            for (Recipe recipe : this.crafter.recipes) {
                required += ((StackList)recipe.requestInput.getOrDefault(null, EmptyList.getInstance())).amount(type);
            }
            if (required == 0L) {
                return 0;
            }
            long insert = Math.min((long)resource.amount, required);
            int filled = this.inv.fill((FluidStack)type.withAmount((int)insert), doFill);
            if (doFill && filled > 0) {
                this.crafter.handleInsertedStack(type, filled);
            }
            return filled;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return this.inv.drain(resource, doDrain);
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return this.inv.drain(maxDrain, doDrain);
        }
    }

    private static class CacheWrapper
    extends DuctUnitFluid.Cache {
        private final CrafterFluid crafter;

        private CacheWrapper(TileEntity tile, CrafterFluid attachment) {
            super(tile, attachment.getFluidFilter());
            this.crafter = attachment;
        }

        public IFluidHandler getHandler(int side) {
            return new Tank(this.crafter, super.getHandler(side));
        }
    }
}

