/*
 * Decompiled with CFR 0.152.
 */
package eutros.dynamistics.jei.categories.pauto;

import eutros.dynamistics.helper.ItemHelper;
import eutros.dynamistics.helper.JeiHelper;
import eutros.dynamistics.jei.categories.pauto.IWrapperSupplier;
import eutros.dynamistics.jei.categories.pauto.processing.PackageRecipeProvider;
import eutros.dynamistics.jei.categories.pauto.processing.RecipeHolderProcessingRecipe;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import thelm.packagedauto.api.IRecipeInfo;
import thelm.packagedauto.api.IRecipeType;
import thelm.packagedauto.api.RecipeTypeRegistry;

public class HolderCategory
implements IWrapperSupplier<PackageRecipeProvider> {
    public static final String UID = "dynamistics:encoder_processing";
    private static final int WIDTH = 172;
    private static final int HEIGHT = 195;
    private final IDrawable background;
    private final IDrawable slot;
    public static final int GRID_START_Y = 0;
    public static final int GRID_SIZE = 18;
    public static final int GRID_START_X = 0;
    public static final int OUT_GRID_START_Y = 177;
    private final IDrawableStatic arrow;
    private final IDrawable icon;

    public HolderCategory(IJeiHelpers helpers) {
        IGuiHelper guiHelper = helpers.getGuiHelper();
        this.background = guiHelper.createBlankDrawable(172, 195);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((Item)Objects.requireNonNull(ForgeRegistries.ITEMS.getValue(new ResourceLocation("packagedauto", "recipe_holder")))));
        this.slot = JeiHelper.getSlotDrawable();
        this.arrow = guiHelper.createDrawable(new ResourceLocation("dynamistics", "textures/gui/arrows.png"), 64, 0, 162, 16);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return I18n.func_135052_a((String)"dynamistics.category.title.pauto.holder", (Object[])new Object[0]);
    }

    @Nonnull
    public String getModName() {
        return "PackagedAuto";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.arrow.draw(minecraft, 0, 162);
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull PackageRecipeProvider recipeWrapper, @Nonnull IIngredients ingredients) {
        int i;
        IGuiItemStackGroup stacks = recipeLayout.getItemStacks();
        NonNullList input = NonNullList.func_191197_a((int)81, (Object)ItemStack.field_190927_a);
        NonNullList output = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
        ArrayList<IDrawable> bgList = new ArrayList<IDrawable>();
        for (int i2 = 0; i2 < 90; ++i2) {
            bgList.add(this.slot);
        }
        NBTTagCompound tag = recipeWrapper.getPackageNBT();
        IRecipeType type = RecipeTypeRegistry.getRecipeType((ResourceLocation)new ResourceLocation(tag.func_74779_i("RecipeType")));
        if (type != null) {
            int i3;
            IRecipeInfo info = type.getNewRecipeInfo();
            info.readFromNBT(tag);
            recipeWrapper.setInfo(info);
            for (Int2ObjectMap.Entry entry : info.getEncoderStacks().int2ObjectEntrySet()) {
                int intKey = entry.getIntKey();
                if (intKey >= input.size()) continue;
                input.set(intKey, entry.getValue());
            }
            List outputs = info.getOutputs();
            for (i3 = 0; i3 < outputs.size(); ++i3) {
                output.set(i3, outputs.get(i3));
            }
            for (i3 = 0; i3 < 81; ++i3) {
                bgList.set(i3, new ColouredSlot(this.slot, type.getSlotColor(i3)));
            }
        }
        for (i = 0; i < input.size(); ++i) {
            stacks.init(i, true, 0 + 18 * (i % 9), 0 + 18 * (i / 9));
            stacks.set(i, (ItemStack)input.get(i));
            stacks.setBackground(i, (IDrawable)bgList.get(i));
        }
        for (i = 0; i < output.size(); ++i) {
            stacks.init(i + 81, false, 0 + 18 * i, 177);
            stacks.set(i + 81, (ItemStack)output.get(i));
            stacks.setBackground(i + 81, (IDrawable)bgList.get(i + 81));
        }
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    @Nonnull
    public List<PackageRecipeProvider> makeWrappers(ItemStack stack) {
        return stack.func_77973_b() == ItemHelper.PAuto.HOLDER ? IntStream.range(0, 20).mapToObj(i -> new HolderRecipe(stack, i)).collect(Collectors.toList()) : Collections.singletonList(new PackageRecipe(stack));
    }

    @Override
    @Nonnull
    public ItemStack getFallbackStack() {
        return ItemHelper.PAuto.EXAMPLE_PACKAGE;
    }

    public static class HolderRecipe
    extends PackageRecipe {
        private final int index;

        public HolderRecipe(ItemStack stack, int index) {
            super(stack);
            this.index = index;
        }

        @Override
        @Nonnull
        public NBTTagCompound getPackageNBT() {
            return RecipeHolderProcessingRecipe.getNBT(this.stack, this.index);
        }
    }

    public static class PackageRecipe
    extends PackageRecipeProvider {
        public PackageRecipe(ItemStack stack) {
            super(stack);
            this.REP_SIZE = 8;
            this.REP_Y = 195 - this.REP_SIZE;
            this.REP_X = 172 - this.REP_SIZE;
        }

        @Override
        @Nonnull
        public NBTTagCompound getPackageNBT() {
            return this.stack.func_77978_p() == null ? new NBTTagCompound() : this.stack.func_77978_p();
        }

        @Override
        public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            if (this.recipeInfo == null) {
                return;
            }
            IRecipeType recipeType = this.recipeInfo.getRecipeType();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.REP_X, (float)this.REP_Y, (float)0.0f);
            GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
            this.drawRep(minecraft, recipeType);
            GlStateManager.func_179121_F();
        }
    }

    public static class ColouredSlot
    implements IDrawable {
        private IDrawable delegate;
        private Color color;

        public ColouredSlot(IDrawable delegate, Color color) {
            this.delegate = delegate;
            this.color = color;
        }

        public int getWidth() {
            return this.delegate.getWidth();
        }

        public int getHeight() {
            return this.delegate.getHeight();
        }

        public void draw(@Nonnull Minecraft minecraft, int xOffset, int yOffset) {
            this.delegate.draw(minecraft, xOffset, yOffset);
            this.drawColor(xOffset + 1, yOffset + 1);
        }

        public void drawColor(int x, int y) {
            GuiUtils.drawGradientRect((int)1, (int)x, (int)y, (int)(x + 16), (int)(y + 16), (int)this.color.getRGB(), (int)this.color.getRGB());
        }
    }
}

