/*
 * Decompiled with CFR 0.152.
 */
package eutros.dynamistics.jei.categories.ae2;

import eutros.dynamistics.helper.JeiHelper;
import eutros.dynamistics.helper.NBTHelper;
import eutros.dynamistics.jei.SingletonRecipe;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class PatternCategory
implements IRecipeCategory<SingletonRecipe> {
    public static final String UID = "dynamistics:process_pattern_";
    private static final int HEIGHT = 126;
    private static final int WIDTH = 146;
    private final IDrawableStatic background;
    private final IDrawableStatic slot;
    private final ItemStack interfaceStack;
    private final IDrawableStatic craftingBackground;
    private final IDrawable icon;
    private final boolean crafting;
    private final boolean substitute;
    private final IDrawableStatic subs;
    private final IDrawableStatic arrow;
    private int guiStartX;
    private int guiStartY;

    public PatternCategory(IJeiHelpers helpers, boolean crafting, boolean substitute) {
        this.crafting = crafting;
        this.substitute = substitute;
        IGuiHelper guiHelper = helpers.getGuiHelper();
        this.slot = JeiHelper.getSlotDrawable();
        this.craftingBackground = guiHelper.createDrawable(new ResourceLocation("appliedenergistics2", "textures/guis/pattern" + (crafting ? "" : "2") + ".png"), 9, 85, 126, 68);
        this.background = guiHelper.createBlankDrawable(146, 126);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((Item)Objects.requireNonNull(ForgeRegistries.ITEMS.getValue(new ResourceLocation("appliedenergistics2", "encoded_pattern")))));
        this.subs = guiHelper.createDrawable(new ResourceLocation("appliedenergistics2", "textures/guis/states.png"), substitute ? 64 : 112, 48, 16, 16);
        this.interfaceStack = new ItemStack((Item)Objects.requireNonNull(ForgeRegistries.ITEMS.getValue(new ResourceLocation("appliedenergistics2", "interface"))));
        this.arrow = guiHelper.createDrawable(new ResourceLocation("dynamistics", "textures/gui/arrows.png"), 64, 16, 32, 32);
        this.guiStartY = 126 - this.craftingBackground.getHeight();
        this.guiStartX = (146 - this.craftingBackground.getWidth()) / 2;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    @Nonnull
    public String getUid() {
        return PatternCategory.getUid(this.crafting, this.substitute);
    }

    public static String getUid(boolean crafting, boolean substitute) {
        return UID + PatternCategory.getTypeId(crafting, substitute);
    }

    public static String getTypeId(boolean crafting, boolean substitute) {
        return crafting ? "crafting_" + (substitute ? "substitute" : "nonsubstitute") : "processing";
    }

    @Nonnull
    public String getTitle() {
        return I18n.func_135052_a((String)("dynamistics.category.title.ae2.pattern." + PatternCategory.getTypeId(this.crafting, this.substitute)), (Object[])new Object[0]);
    }

    @Nonnull
    public String getModName() {
        return "Applied Energistics 2";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, @Nonnull SingletonRecipe recipe, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup stacks = recipeLayout.getItemStacks();
        ItemStack patternStack = recipe.stack;
        if (patternStack == null) {
            patternStack = (ItemStack)((List)ingredients.getInputs(VanillaTypes.ITEM).get(0)).get(0);
        }
        stacks.init(13, true, 65, 8);
        stacks.set(13, patternStack);
        stacks.setBackground(13, (IDrawable)this.slot);
        stacks.init(14, true, 65, 29);
        stacks.set(14, this.interfaceStack);
        if (patternStack.func_77942_o()) {
            NBTTagCompound tag = patternStack.func_77978_p();
            assert (tag != null);
            NonNullList<ItemStack> inputs = NBTHelper.getItemStackList(tag, "in");
            NonNullList<ItemStack> outputs = NBTHelper.getItemStackList(tag, "out");
            int gridStartY = 7;
            int gridStartX = 8;
            int gridSize = 18;
            for (int i = 0; i < inputs.size(); ++i) {
                stacks.init(i, true, this.guiStartX + gridStartX + gridSize * (i % 3), this.guiStartY + gridStartY + gridSize * (i / 3));
                stacks.set(i, (ItemStack)inputs.get(i));
            }
            int outStartX = 100;
            if (this.crafting && !outputs.isEmpty()) {
                stacks.init(9, false, this.guiStartX + outStartX, this.guiStartY + gridStartY + gridSize);
                stacks.set(9, (ItemStack)outputs.get(0));
            } else {
                for (int i = 0; i < outputs.size(); ++i) {
                    stacks.init(9 + i, false, this.guiStartX + outStartX, this.guiStartY + gridStartY + gridSize * i);
                    stacks.set(9 + i, (ItemStack)outputs.get(i));
                }
            }
        }
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.arrow.draw(minecraft, (146 - this.arrow.getWidth()) / 2, 27);
        this.craftingBackground.draw(minecraft, this.guiStartX, this.guiStartY);
        if (this.crafting) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.guiStartX, (float)this.guiStartY, (float)0.0f);
            double sf = 0.5;
            GlStateManager.func_179139_a((double)sf, (double)sf, (double)sf);
            this.subs.draw(minecraft);
            GlStateManager.func_179121_F();
        }
    }
}

