/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.zoo.spawn.impl;

import crazypants.enderio.base.Log;
import crazypants.enderio.zoo.spawn.IBiomeDescriptor;
import crazypants.enderio.zoo.spawn.IBiomeFilter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public abstract class AbstractBiomeFilter
implements IBiomeFilter {
    protected final List<BiomeDictionary.Type> types = new ArrayList<BiomeDictionary.Type>();
    protected final List<BiomeDictionary.Type> typeExcludes = new ArrayList<BiomeDictionary.Type>();
    protected final List<ResourceLocation> names = new ArrayList<ResourceLocation>();
    protected final List<ResourceLocation> nameExcludes = new ArrayList<ResourceLocation>();

    @Override
    public void addBiomeDescriptor(IBiomeDescriptor biome) {
        if (biome.getType() != null) {
            if (biome.isExclude()) {
                this.typeExcludes.add(biome.getType());
            } else {
                this.types.add(biome.getType());
            }
        } else if (biome.getRegistryName() != null) {
            if (biome.isExclude()) {
                this.nameExcludes.add(biome.getRegistryName());
            } else {
                this.names.add(biome.getRegistryName());
            }
        }
    }

    protected boolean isExcluded(Biome candidate) {
        for (BiomeDictionary.Type exType : this.typeExcludes) {
            if (!BiomeDictionary.hasType((Biome)candidate, (BiomeDictionary.Type)exType)) continue;
            Log.debug((Object[])new Object[]{"Excluded ", candidate.getRegistryName(), ", "});
            return true;
        }
        for (ResourceLocation exName : this.nameExcludes) {
            if (exName == null || !exName.equals((Object)candidate.getRegistryName())) continue;
            Log.debug((Object[])new Object[]{"Excluded ", candidate.getRegistryName(), ", "});
            return false;
        }
        return false;
    }
}

