/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.zoo.entity;

import com.enderio.core.common.util.blockiterators.PlanarBlockIterator;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class SpawnUtil {
    public static BlockPos findClearGround(@Nonnull World world, @Nonnull BlockPos startingLocation) {
        return SpawnUtil.findClearGround(world, startingLocation, 2, 10, false);
    }

    public static BlockPos findClearGround(@Nonnull World world, @Nonnull BlockPos startingLocation, int horizRange, int vertRange, boolean checkForLivingEntities) {
        PlanarBlockIterator itr = new PlanarBlockIterator(startingLocation, PlanarBlockIterator.Orientation.EAST_WEST, horizRange);
        while (itr.hasNext()) {
            BlockPos location = SpawnUtil.seachYForClearGround(itr.next(), world, vertRange, checkForLivingEntities);
            if (location == null) continue;
            return location;
        }
        return null;
    }

    public static BlockPos seachYForClearGround(@Nonnull BlockPos target, @Nonnull World world) {
        return SpawnUtil.seachYForClearGround(target, world, 10, false);
    }

    public static BlockPos seachYForClearGround(@Nonnull BlockPos startingLocation, @Nonnull World world, int searchRange, boolean checkForLivingEntities) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(startingLocation);
        while (!world.func_175623_d((BlockPos)pos)) {
            pos.func_189536_c(EnumFacing.UP);
            if (pos.func_177956_o() <= 255 && !(pos.func_177951_i((Vec3i)startingLocation) > (double)(searchRange * searchRange))) continue;
            return null;
        }
        while (world.func_175623_d(pos.func_177977_b()) || SpawnUtil.isLiquid(world, pos.func_177977_b())) {
            pos.func_189536_c(EnumFacing.DOWN);
            if (pos.func_177956_o() >= 0 && !(pos.func_177951_i((Vec3i)startingLocation) > (double)(searchRange * searchRange))) continue;
            return null;
        }
        if (checkForLivingEntities && SpawnUtil.containsLiving(world, (BlockPos)pos)) {
            return null;
        }
        return pos.func_185334_h();
    }

    public static boolean containsLiving(@Nonnull World world, @Nonnull BlockPos pos) {
        return !world.func_72855_b(new AxisAlignedBB(pos));
    }

    public static boolean isLiquid(@Nonnull World world, @Nonnull BlockPos pos) {
        return world.func_180495_p(pos).func_185904_a().func_76224_d();
    }

    public static boolean isSpaceAvailableForSpawn(World worldObj, EntityLiving entity, EntityCreature asCreature, boolean checkEntityCollisions, boolean canSpawnInLiquid) {
        if (asCreature != null && asCreature.func_180484_a(entity.func_180425_c()) < 0.0f) {
            return false;
        }
        if (checkEntityCollisions && !worldObj.func_72855_b(entity.func_174813_aQ())) {
            return false;
        }
        if (!worldObj.func_184144_a((Entity)entity, entity.func_174813_aQ()).isEmpty()) {
            return false;
        }
        return canSpawnInLiquid || !worldObj.func_72953_d(entity.func_174813_aQ());
    }

    public static boolean isSpaceAvailableForSpawn(World worldObj, EntityCreature entityCreature, boolean checkEntityCollisions, boolean canSpawnInLiquid) {
        return SpawnUtil.isSpaceAvailableForSpawn(worldObj, (EntityLiving)entityCreature, entityCreature, checkEntityCollisions, false);
    }

    public static boolean isSpaceAvailableForSpawn(World worldObj, EntityLiving entity, boolean checkEntityCollisions, boolean canSpawnInLiquid) {
        return SpawnUtil.isSpaceAvailableForSpawn(worldObj, entity, entity instanceof EntityCreature ? (EntityCreature)entity : null, checkEntityCollisions, canSpawnInLiquid);
    }

    public static boolean isSpaceAvailableForSpawn(World worldObj, EntityLiving spawn, boolean checkEntityCollisions) {
        return SpawnUtil.isSpaceAvailableForSpawn(worldObj, spawn, checkEntityCollisions, false);
    }
}

