/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.zoo.entity;

import crazypants.enderio.base.config.config.DarkSteelConfig;
import crazypants.enderio.base.events.EnderIOLifecycleEvent;
import crazypants.enderio.base.handler.darksteel.SwordHandler;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.loot.EntityLootHelper;
import crazypants.enderio.base.teleport.RandomTeleportUtil;
import crazypants.enderio.zoo.config.ZooConfig;
import crazypants.enderio.zoo.entity.IEnderZooEntity;
import crazypants.enderio.zoo.entity.render.RenderLoveChild;
import info.loenwind.autoconfig.factory.IValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.ZombieEvent;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="enderiozoo")
public class EntityLoveChild
extends EntityZombie
implements IEnderZooEntity.Aggressive {
    @Nonnull
    public static final String NAME = "lovechild";
    public static final int EGG_BG_COL = 1257301;
    public static final int EGG_FG_COL = 2829596;
    @Nonnull
    private static final ItemStack OFFHAND_STACK = new ItemStack(Items.field_151079_bi);

    @SubscribeEvent
    public static void onEntityRegister(@Nonnull RegistryEvent.Register<EntityEntry> event) {
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("enderio", NAME));
        IEnderZooEntity.register(event, NAME, EntityLoveChild.class, 1257301, 2829596, IEnderZooEntity.MobID.LCHILD);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onPreInit(EnderIOLifecycleEvent.PreInit event) {
        RenderingRegistry.registerEntityRenderingHandler(EntityLoveChild.class, (IRenderFactory)RenderLoveChild.FACTORY);
    }

    public EntityLoveChild(World worldIn) {
        super(worldIn);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(((Double)ZooConfig.loveChildSpeed.get()).doubleValue());
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(((Double)ZooConfig.loveChildArmor.get()).doubleValue());
        this.applyAttributes((EntityLivingBase)this, ZooConfig.loveChildHealth, ZooConfig.loveChildAttackDamage);
    }

    public boolean func_70601_bi() {
        return super.func_70601_bi() && this.field_70170_p.func_175678_i(new BlockPos((Entity)this));
    }

    protected boolean func_190730_o() {
        return false;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return null;
    }

    @Nonnull
    protected SoundEvent func_184601_bQ(@Nonnull DamageSource damageSourceIn) {
        return SoundEvents.field_187531_aU;
    }

    @Nonnull
    protected SoundEvent func_184615_bR() {
        return super.func_184615_bR();
    }

    @Nonnull
    protected SoundEvent func_190731_di() {
        return super.func_190731_di();
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return new ResourceLocation("enderio", NAME);
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, @Nonnull DamageSource source) {
        EntityLootHelper.dropLoot((EntityLiving)this, (ResourceLocation)this.func_184647_J(), (DamageSource)source);
        this.func_82160_b(wasRecentlyHit, lootingModifier);
    }

    public boolean func_70652_k(@Nonnull Entity entityIn) {
        boolean flag = super.func_70652_k(entityIn);
        if (flag && entityIn instanceof EntityLivingBase && this.field_70146_Z.nextFloat() < ((Float)ZooConfig.attackTeleportChance.get()).floatValue()) {
            RandomTeleportUtil.teleportEntity((World)entityIn.field_70170_p, (Entity)entityIn, (boolean)false, (boolean)true, (float)((Float)ZooConfig.attackTeleportDistance.get()).floatValue());
        }
        return flag;
    }

    public boolean func_70097_a(@Nonnull DamageSource source, float amount) {
        if (!this.func_180431_b(source) && super.func_70097_a(source, amount)) {
            if (source instanceof EntityDamageSource && source.func_76346_g() instanceof EntityPlayer && SwordHandler.isEquippedAndPowered((EntityPlayer)((EntityPlayer)source.func_76346_g()), (IValue)DarkSteelConfig.darkSteelSwordPowerUsePerHit)) {
                return true;
            }
            if (this.field_70146_Z.nextFloat() < ((Float)ZooConfig.defendTeleportChance.get()).floatValue()) {
                RandomTeleportUtil.teleportEntity((World)this.field_70170_p, (Entity)this, (boolean)false, (boolean)true, (float)((Float)ZooConfig.defendTeleportDistance.get()).floatValue());
                this.func_70661_as().func_75499_g();
            }
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onSummonAid(ZombieEvent.SummonAidEvent event) {
        if (event.getSummoner() instanceof EntityLoveChild) {
            if (((Boolean)ZooConfig.loveSummonAid.get()).booleanValue() && event.getResult() != Event.Result.DENY && event.getAttacker() != null && event.getWorld().func_175659_aa() == EnumDifficulty.HARD && (double)event.getWorld().field_73012_v.nextFloat() < event.getSummoner().func_110148_a(field_110186_bp).func_111126_e() && event.getWorld().func_82736_K().func_82766_b("doMobSpawning")) {
                event.setResult(Event.Result.ALLOW);
                event.setCustomSummonedAid((EntityZombie)new EntityLoveChild(event.getWorld()));
            } else {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @Nonnull
    protected ItemStack func_190732_dj() {
        switch ((ZooConfig.SkullDrop)((Object)ZooConfig.loveSkullDrop.get())) {
            case ENDERMAN: {
                return new ItemStack(ModObject.blockEndermanSkull.getBlockNN());
            }
            case ZOMBIE: {
                return super.func_190732_dj();
            }
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack func_184592_cb() {
        ItemStack item = super.func_184592_cb();
        return item.func_190926_b() ? OFFHAND_STACK : item;
    }
}

