/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.wrenchest;

import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.state.properties.ChestType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod(value="wrenchest")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class Wrenchest {
    public static final String MODID = "wrenchest";

    @SubscribeEvent
    public static void onRegisterItem(RegistryEvent.Register<Item> event) {
        event.getRegistry().register(new Item(new Item.Properties().func_200916_a(ItemGroup.field_78040_i).func_200917_a(1).func_200915_b(256)){

            public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
                return toRepair.func_77973_b() == this && (repair.func_77973_b() == this || repair.func_77973_b() == Items.field_151042_j);
            }

            public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext ctx) {
                ActionResultType result = this.checkConnections(ctx);
                if (result == ActionResultType.SUCCESS && !ctx.func_195999_j().func_184812_l_()) {
                    stack.func_222118_a(1, (LivingEntity)ctx.func_195999_j(), p -> {});
                }
                return result;
            }

            private ActionResultType checkConnections(ItemUseContext ctx) {
                BlockPos otherPos;
                BlockState otherState;
                BlockPos pos;
                if (!(ctx.func_195991_k().func_180495_p(ctx.func_195995_a()).func_177230_c() instanceof ChestBlock)) {
                    return ActionResultType.PASS;
                }
                World world = ctx.func_195991_k();
                BlockState chestState = world.func_180495_p(pos = ctx.func_195995_a());
                if (chestState.func_177229_b((Property)ChestBlock.field_196314_b) != ChestType.SINGLE) {
                    Direction facingTowardsOther = ChestBlock.func_196311_i((BlockState)chestState);
                    world.func_175656_a(pos, (BlockState)chestState.func_206870_a((Property)ChestBlock.field_196314_b, (Comparable)ChestType.SINGLE));
                    world.func_175656_a(pos.func_177972_a(facingTowardsOther), (BlockState)world.func_180495_p(pos.func_177972_a(facingTowardsOther)).func_206870_a((Property)ChestBlock.field_196314_b, (Comparable)ChestType.SINGLE));
                    return ActionResultType.SUCCESS;
                }
                if (ctx.func_196000_l() != Direction.UP && ctx.func_196000_l() != Direction.DOWN && (otherState = world.func_180495_p(otherPos = pos.func_177972_a(ctx.func_196000_l()))).func_177230_c() instanceof ChestBlock && otherState.func_177229_b((Property)ChestBlock.field_196314_b) == ChestType.SINGLE) {
                    Direction facing = (Direction)chestState.func_177229_b((Property)ChestBlock.field_176459_a);
                    Direction otherFacing = (Direction)otherState.func_177229_b((Property)ChestBlock.field_176459_a);
                    if ((ctx.func_196000_l() == facing || ctx.func_196000_l() == otherFacing) && facing.func_176734_d() == otherFacing) {
                        if (this.connectChests(world, pos, otherPos, chestState, otherState, ctx.func_196000_l(), facing, this.frac(ctx.func_221532_j().field_72450_a), this.frac(ctx.func_221532_j().field_72449_c), true)) {
                            return ActionResultType.SUCCESS;
                        }
                        return ActionResultType.PASS;
                    }
                    if (ctx.func_196000_l().func_176746_e() == facing || ctx.func_196000_l().func_176735_f() == facing) {
                        if (this.connectChests(world, pos, otherPos, chestState, otherState, ctx.func_196000_l(), facing, this.frac(ctx.func_221532_j().field_72450_a), this.frac(ctx.func_221532_j().field_72449_c), false)) {
                            return ActionResultType.SUCCESS;
                        }
                        return ActionResultType.PASS;
                    }
                    if (ctx.func_196000_l().func_176746_e() == otherFacing || ctx.func_196000_l().func_176735_f() == otherFacing) {
                        if (this.connectChests(world, pos, otherPos, chestState, otherState, ctx.func_196000_l(), otherFacing, this.frac(ctx.func_221532_j().field_72450_a), this.frac(ctx.func_221532_j().field_72449_c), false)) {
                            return ActionResultType.SUCCESS;
                        }
                        return ActionResultType.PASS;
                    }
                    if (facing == otherFacing) {
                        if (this.connectChests(world, pos, otherPos, chestState, otherState, ctx.func_196000_l(), facing.func_176746_e(), this.frac(ctx.func_221532_j().field_72450_a), this.frac(ctx.func_221532_j().field_72449_c), false)) {
                            return ActionResultType.SUCCESS;
                        }
                        return ActionResultType.PASS;
                    }
                }
                return ActionResultType.PASS;
            }

            private boolean connectChests(World world, BlockPos clickedPos, BlockPos otherPos, BlockState clickedState, BlockState otherState, Direction clickedFace, Direction chestFacing, double hitX, double hitZ, boolean swapDirections) {
                Direction newFacing = Direction.UP;
                if (!swapDirections) {
                    if (chestFacing == Direction.NORTH || chestFacing == Direction.SOUTH) {
                        newFacing = hitZ < 0.5 ? Direction.NORTH : Direction.SOUTH;
                    } else if (chestFacing == Direction.WEST || chestFacing == Direction.EAST) {
                        newFacing = hitX < 0.5 ? Direction.WEST : Direction.EAST;
                    }
                } else if (chestFacing == Direction.WEST || chestFacing == Direction.EAST) {
                    newFacing = hitZ < 0.5 ? Direction.NORTH : Direction.SOUTH;
                } else if (chestFacing == Direction.NORTH || chestFacing == Direction.SOUTH) {
                    Direction direction = newFacing = hitX < 0.5 ? Direction.WEST : Direction.EAST;
                }
                if (newFacing != Direction.UP) {
                    ChestType newType = this.getNewChestType(clickedFace, newFacing);
                    world.func_175656_a(clickedPos, (BlockState)((BlockState)clickedState.func_206870_a((Property)ChestBlock.field_176459_a, (Comparable)newFacing)).func_206870_a((Property)ChestBlock.field_196314_b, (Comparable)newType));
                    world.func_175656_a(otherPos, (BlockState)((BlockState)otherState.func_206870_a((Property)ChestBlock.field_176459_a, (Comparable)newFacing)).func_206870_a((Property)ChestBlock.field_196314_b, (Comparable)newType.func_208081_a()));
                    return true;
                }
                return false;
            }

            private ChestType getNewChestType(Direction clickedFace, Direction chestFacing) {
                switch (chestFacing) {
                    case NORTH: {
                        return clickedFace == Direction.WEST ? ChestType.RIGHT : ChestType.LEFT;
                    }
                    case SOUTH: {
                        return clickedFace == Direction.WEST ? ChestType.LEFT : ChestType.RIGHT;
                    }
                    case EAST: {
                        return clickedFace == Direction.NORTH ? ChestType.RIGHT : ChestType.LEFT;
                    }
                    case WEST: {
                        return clickedFace == Direction.NORTH ? ChestType.LEFT : ChestType.RIGHT;
                    }
                }
                return ChestType.SINGLE;
            }

            private double frac(double d) {
                return MathHelper.func_181162_h((double)d);
            }
        }.setRegistryName(new ResourceLocation(MODID, "chest_wrench")));
    }
}

