/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.wrenchest;

import net.minecraft.block.BlockChest;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.ChestType;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod(value="wrenchest")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class Wrenchest {
    public static final String MODID = "wrenchest";

    @SubscribeEvent
    public static void onRegisterItem(RegistryEvent.Register<Item> event) {
        event.getRegistry().register(new Item(new Item.Properties().func_200916_a(ItemGroup.field_78040_i).func_200917_a(1).func_200915_b(256)){

            public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
                return toRepair.func_77973_b() == this && (repair.func_77973_b() == this || repair.func_77973_b() == Items.field_151042_j);
            }

            public EnumActionResult onItemUseFirst(ItemStack stack, ItemUseContext ctx) {
                EnumActionResult result = this.checkConnections(stack, ctx);
                if (result == EnumActionResult.SUCCESS && !ctx.func_195999_j().func_184812_l_()) {
                    stack.func_77972_a(1, (EntityLivingBase)ctx.func_195999_j());
                }
                return result;
            }

            private EnumActionResult checkConnections(ItemStack stack, ItemUseContext ctx) {
                BlockPos otherPos;
                IBlockState otherState;
                BlockPos pos;
                if (!(ctx.func_195991_k().func_180495_p(ctx.func_195995_a()).func_177230_c() instanceof BlockChest)) {
                    return EnumActionResult.PASS;
                }
                World world = ctx.func_195991_k();
                IBlockState chestState = world.func_180495_p(pos = ctx.func_195995_a());
                if (chestState.func_177229_b((IProperty)BlockChest.field_196314_b) != ChestType.SINGLE) {
                    EnumFacing facingTowardsOther = BlockChest.func_196311_i((IBlockState)chestState);
                    world.func_175656_a(pos, (IBlockState)chestState.func_206870_a((IProperty)BlockChest.field_196314_b, (Comparable)ChestType.SINGLE));
                    world.func_175656_a(pos.func_177972_a(facingTowardsOther), (IBlockState)world.func_180495_p(pos.func_177972_a(facingTowardsOther)).func_206870_a((IProperty)BlockChest.field_196314_b, (Comparable)ChestType.SINGLE));
                    return EnumActionResult.SUCCESS;
                }
                if (ctx.func_196000_l() != EnumFacing.UP && ctx.func_196000_l() != EnumFacing.DOWN && (otherState = world.func_180495_p(otherPos = pos.func_177972_a(ctx.func_196000_l()))).func_177230_c() instanceof BlockChest && otherState.func_177229_b((IProperty)BlockChest.field_196314_b) == ChestType.SINGLE) {
                    EnumFacing facing = (EnumFacing)chestState.func_177229_b((IProperty)BlockChest.field_176459_a);
                    EnumFacing otherFacing = (EnumFacing)otherState.func_177229_b((IProperty)BlockChest.field_176459_a);
                    if ((ctx.func_196000_l() == facing || ctx.func_196000_l() == otherFacing) && facing.func_176734_d() == otherFacing) {
                        if (this.connectChests(world, pos, otherPos, chestState, otherState, ctx.func_196000_l(), facing, ctx.func_195997_m(), ctx.func_195994_o(), true)) {
                            return EnumActionResult.SUCCESS;
                        }
                        return EnumActionResult.PASS;
                    }
                    if (ctx.func_196000_l().func_176746_e() == facing || ctx.func_196000_l().func_176735_f() == facing) {
                        if (this.connectChests(world, pos, otherPos, chestState, otherState, ctx.func_196000_l(), facing, ctx.func_195997_m(), ctx.func_195994_o(), false)) {
                            return EnumActionResult.SUCCESS;
                        }
                        return EnumActionResult.PASS;
                    }
                    if (ctx.func_196000_l().func_176746_e() == otherFacing || ctx.func_196000_l().func_176735_f() == otherFacing) {
                        if (this.connectChests(world, pos, otherPos, chestState, otherState, ctx.func_196000_l(), otherFacing, ctx.func_195997_m(), ctx.func_195994_o(), false)) {
                            return EnumActionResult.SUCCESS;
                        }
                        return EnumActionResult.PASS;
                    }
                    if (facing == otherFacing) {
                        if (this.connectChests(world, pos, otherPos, chestState, otherState, ctx.func_196000_l(), facing.func_176746_e(), ctx.func_195997_m(), ctx.func_195994_o(), false)) {
                            return EnumActionResult.SUCCESS;
                        }
                        return EnumActionResult.PASS;
                    }
                }
                return EnumActionResult.PASS;
            }

            private boolean connectChests(World world, BlockPos clickedPos, BlockPos otherPos, IBlockState clickedState, IBlockState otherState, EnumFacing clickedFace, EnumFacing chestFacing, float hitX, float hitZ, boolean swapDirections) {
                EnumFacing newFacing = EnumFacing.UP;
                if (!swapDirections) {
                    if (chestFacing == EnumFacing.NORTH || chestFacing == EnumFacing.SOUTH) {
                        newFacing = (double)hitZ < 0.5 ? EnumFacing.NORTH : EnumFacing.SOUTH;
                    } else if (chestFacing == EnumFacing.WEST || chestFacing == EnumFacing.EAST) {
                        newFacing = (double)hitX < 0.5 ? EnumFacing.WEST : EnumFacing.EAST;
                    }
                } else if (chestFacing == EnumFacing.WEST || chestFacing == EnumFacing.EAST) {
                    newFacing = (double)hitZ < 0.5 ? EnumFacing.NORTH : EnumFacing.SOUTH;
                } else if (chestFacing == EnumFacing.NORTH || chestFacing == EnumFacing.SOUTH) {
                    EnumFacing enumFacing = newFacing = (double)hitX < 0.5 ? EnumFacing.WEST : EnumFacing.EAST;
                }
                if (newFacing != EnumFacing.UP) {
                    ChestType newType = this.getNewChestType(clickedFace, newFacing);
                    world.func_175656_a(clickedPos, (IBlockState)((IBlockState)clickedState.func_206870_a((IProperty)BlockChest.field_176459_a, (Comparable)newFacing)).func_206870_a((IProperty)BlockChest.field_196314_b, (Comparable)newType));
                    world.func_175656_a(otherPos, (IBlockState)((IBlockState)otherState.func_206870_a((IProperty)BlockChest.field_176459_a, (Comparable)newFacing)).func_206870_a((IProperty)BlockChest.field_196314_b, (Comparable)newType.func_208081_a()));
                    return true;
                }
                return false;
            }

            private ChestType getNewChestType(EnumFacing clickedFace, EnumFacing chestFacing) {
                switch (chestFacing) {
                    case NORTH: {
                        return clickedFace == EnumFacing.WEST ? ChestType.RIGHT : ChestType.LEFT;
                    }
                    case SOUTH: {
                        return clickedFace == EnumFacing.WEST ? ChestType.LEFT : ChestType.RIGHT;
                    }
                    case EAST: {
                        return clickedFace == EnumFacing.NORTH ? ChestType.RIGHT : ChestType.LEFT;
                    }
                    case WEST: {
                        return clickedFace == EnumFacing.NORTH ? ChestType.LEFT : ChestType.RIGHT;
                    }
                }
                return ChestType.SINGLE;
            }
        }.setRegistryName(new ResourceLocation(MODID, "chest_wrench")));
    }
}

