/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.wrenchest;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="wrenchest")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class Wrenchest {
    public static final String MODID = "wrenchest";
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"wrenchest");
    public static final RegistryObject<Item> CHEST_WRENCH = ITEMS.register("chest_wrench", () -> new Item(new Item.Properties().m_41487_(1).m_41499_(256)){

        public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
            return toRepair.m_41720_() == this && (repair.m_41720_() == this || repair.m_41720_() == Items.f_42416_);
        }

        public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext ctx) {
            InteractionResult result = this.checkConnections(ctx);
            if (result == InteractionResult.SUCCESS && !ctx.m_43723_().m_7500_()) {
                stack.m_41622_(1, (LivingEntity)ctx.m_43723_(), p -> {});
            }
            return result;
        }

        private InteractionResult checkConnections(UseOnContext ctx) {
            BlockPos otherPos;
            BlockState otherState;
            BlockPos pos;
            if (!(ctx.m_43725_().m_8055_(ctx.m_8083_()).m_60734_() instanceof ChestBlock)) {
                return InteractionResult.PASS;
            }
            Level level = ctx.m_43725_();
            BlockState chestState = level.m_8055_(pos = ctx.m_8083_());
            if (chestState.m_61143_((Property)ChestBlock.f_51479_) != ChestType.SINGLE) {
                Direction facingTowardsOther = ChestBlock.m_51584_((BlockState)chestState);
                level.m_46597_(pos, (BlockState)chestState.m_61124_((Property)ChestBlock.f_51479_, (Comparable)ChestType.SINGLE));
                level.m_46597_(pos.m_121945_(facingTowardsOther), (BlockState)level.m_8055_(pos.m_121945_(facingTowardsOther)).m_61124_((Property)ChestBlock.f_51479_, (Comparable)ChestType.SINGLE));
                return InteractionResult.SUCCESS;
            }
            if (ctx.m_43719_() != Direction.UP && ctx.m_43719_() != Direction.DOWN && (otherState = level.m_8055_(otherPos = pos.m_121945_(ctx.m_43719_()))).m_60734_() instanceof ChestBlock && otherState.m_61143_((Property)ChestBlock.f_51479_) == ChestType.SINGLE) {
                Direction facing = (Direction)chestState.m_61143_((Property)ChestBlock.f_51478_);
                Direction otherFacing = (Direction)otherState.m_61143_((Property)ChestBlock.f_51478_);
                if ((ctx.m_43719_() == facing || ctx.m_43719_() == otherFacing) && facing.m_122424_() == otherFacing) {
                    if (this.connectChests(level, pos, otherPos, chestState, otherState, ctx.m_43719_(), facing, this.frac(ctx.m_43720_().f_82479_), this.frac(ctx.m_43720_().f_82481_), true)) {
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.PASS;
                }
                if (ctx.m_43719_().m_122427_() == facing || ctx.m_43719_().m_122428_() == facing) {
                    if (this.connectChests(level, pos, otherPos, chestState, otherState, ctx.m_43719_(), facing, this.frac(ctx.m_43720_().f_82479_), this.frac(ctx.m_43720_().f_82481_), false)) {
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.PASS;
                }
                if (ctx.m_43719_().m_122427_() == otherFacing || ctx.m_43719_().m_122428_() == otherFacing) {
                    if (this.connectChests(level, pos, otherPos, chestState, otherState, ctx.m_43719_(), otherFacing, this.frac(ctx.m_43720_().f_82479_), this.frac(ctx.m_43720_().f_82481_), false)) {
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.PASS;
                }
                if (facing == otherFacing) {
                    if (this.connectChests(level, pos, otherPos, chestState, otherState, ctx.m_43719_(), facing.m_122427_(), this.frac(ctx.m_43720_().f_82479_), this.frac(ctx.m_43720_().f_82481_), false)) {
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.PASS;
                }
            }
            return InteractionResult.PASS;
        }

        private boolean connectChests(Level level, BlockPos clickedPos, BlockPos otherPos, BlockState clickedState, BlockState otherState, Direction clickedFace, Direction chestFacing, double hitX, double hitZ, boolean swapDirections) {
            Direction newFacing = Direction.UP;
            if (!swapDirections) {
                if (chestFacing == Direction.NORTH || chestFacing == Direction.SOUTH) {
                    newFacing = hitZ < 0.5 ? Direction.NORTH : Direction.SOUTH;
                } else if (chestFacing == Direction.WEST || chestFacing == Direction.EAST) {
                    newFacing = hitX < 0.5 ? Direction.WEST : Direction.EAST;
                }
            } else if (chestFacing == Direction.WEST || chestFacing == Direction.EAST) {
                newFacing = hitZ < 0.5 ? Direction.NORTH : Direction.SOUTH;
            } else if (chestFacing == Direction.NORTH || chestFacing == Direction.SOUTH) {
                Direction direction = newFacing = hitX < 0.5 ? Direction.WEST : Direction.EAST;
            }
            if (newFacing != Direction.UP) {
                ChestType newType = this.getNewChestType(clickedFace, newFacing);
                level.m_46597_(clickedPos, (BlockState)((BlockState)clickedState.m_61124_((Property)ChestBlock.f_51478_, (Comparable)newFacing)).m_61124_((Property)ChestBlock.f_51479_, (Comparable)newType));
                level.m_46597_(otherPos, (BlockState)((BlockState)otherState.m_61124_((Property)ChestBlock.f_51478_, (Comparable)newFacing)).m_61124_((Property)ChestBlock.f_51479_, (Comparable)newType.m_61486_()));
                return true;
            }
            return false;
        }

        private ChestType getNewChestType(Direction clickedFace, Direction chestFacing) {
            return switch (chestFacing) {
                case Direction.NORTH -> {
                    if (clickedFace == Direction.WEST) {
                        yield ChestType.RIGHT;
                    }
                    yield ChestType.LEFT;
                }
                case Direction.SOUTH -> {
                    if (clickedFace == Direction.WEST) {
                        yield ChestType.LEFT;
                    }
                    yield ChestType.RIGHT;
                }
                case Direction.EAST -> {
                    if (clickedFace == Direction.NORTH) {
                        yield ChestType.RIGHT;
                    }
                    yield ChestType.LEFT;
                }
                case Direction.WEST -> {
                    if (clickedFace == Direction.NORTH) {
                        yield ChestType.LEFT;
                    }
                    yield ChestType.RIGHT;
                }
                default -> ChestType.SINGLE;
            };
        }

        private double frac(double d) {
            return Mth.m_14185_((double)d);
        }
    });

    public Wrenchest() {
        ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    @SubscribeEvent
    public static void onCreativeModeTabBuildContents(CreativeModeTabEvent.BuildContents event) {
        if (event.getTab() == CreativeModeTabs.f_256869_) {
            event.getEntries().putBefore((Object)new ItemStack((ItemLike)Items.f_42523_), (Object)new ItemStack((ItemLike)CHEST_WRENCH.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }
}

