/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.wrenchest;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="wrenchest")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class Wrenchest {
    public static final String MODID = "wrenchest";

    @SubscribeEvent
    public static void onRegisterItem(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)((Item)new Item(new Item.Properties().m_41491_(CreativeModeTab.f_40756_).m_41487_(1).m_41499_(256)){

            public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
                return toRepair.m_41720_() == this && (repair.m_41720_() == this || repair.m_41720_() == Items.f_42416_);
            }

            public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext ctx) {
                InteractionResult result = this.checkConnections(ctx);
                if (result == InteractionResult.SUCCESS && !ctx.m_43723_().m_7500_()) {
                    stack.m_41622_(1, (LivingEntity)ctx.m_43723_(), p -> {});
                }
                return result;
            }

            private InteractionResult checkConnections(UseOnContext ctx) {
                BlockPos otherPos;
                BlockState otherState;
                BlockPos pos;
                if (!(ctx.m_43725_().m_8055_(ctx.m_8083_()).m_60734_() instanceof ChestBlock)) {
                    return InteractionResult.PASS;
                }
                Level world = ctx.m_43725_();
                BlockState chestState = world.m_8055_(pos = ctx.m_8083_());
                if (chestState.m_61143_((Property)ChestBlock.f_51479_) != ChestType.SINGLE) {
                    Direction facingTowardsOther = ChestBlock.m_51584_((BlockState)chestState);
                    world.m_46597_(pos, (BlockState)chestState.m_61124_((Property)ChestBlock.f_51479_, (Comparable)ChestType.SINGLE));
                    world.m_46597_(pos.m_142300_(facingTowardsOther), (BlockState)world.m_8055_(pos.m_142300_(facingTowardsOther)).m_61124_((Property)ChestBlock.f_51479_, (Comparable)ChestType.SINGLE));
                    return InteractionResult.SUCCESS;
                }
                if (ctx.m_43719_() != Direction.UP && ctx.m_43719_() != Direction.DOWN && (otherState = world.m_8055_(otherPos = pos.m_142300_(ctx.m_43719_()))).m_60734_() instanceof ChestBlock && otherState.m_61143_((Property)ChestBlock.f_51479_) == ChestType.SINGLE) {
                    Direction facing = (Direction)chestState.m_61143_((Property)ChestBlock.f_51478_);
                    Direction otherFacing = (Direction)otherState.m_61143_((Property)ChestBlock.f_51478_);
                    if ((ctx.m_43719_() == facing || ctx.m_43719_() == otherFacing) && facing.m_122424_() == otherFacing) {
                        if (this.connectChests(world, pos, otherPos, chestState, otherState, ctx.m_43719_(), facing, this.frac(ctx.m_43720_().f_82479_), this.frac(ctx.m_43720_().f_82481_), true)) {
                            return InteractionResult.SUCCESS;
                        }
                        return InteractionResult.PASS;
                    }
                    if (ctx.m_43719_().m_122427_() == facing || ctx.m_43719_().m_122428_() == facing) {
                        if (this.connectChests(world, pos, otherPos, chestState, otherState, ctx.m_43719_(), facing, this.frac(ctx.m_43720_().f_82479_), this.frac(ctx.m_43720_().f_82481_), false)) {
                            return InteractionResult.SUCCESS;
                        }
                        return InteractionResult.PASS;
                    }
                    if (ctx.m_43719_().m_122427_() == otherFacing || ctx.m_43719_().m_122428_() == otherFacing) {
                        if (this.connectChests(world, pos, otherPos, chestState, otherState, ctx.m_43719_(), otherFacing, this.frac(ctx.m_43720_().f_82479_), this.frac(ctx.m_43720_().f_82481_), false)) {
                            return InteractionResult.SUCCESS;
                        }
                        return InteractionResult.PASS;
                    }
                    if (facing == otherFacing) {
                        if (this.connectChests(world, pos, otherPos, chestState, otherState, ctx.m_43719_(), facing.m_122427_(), this.frac(ctx.m_43720_().f_82479_), this.frac(ctx.m_43720_().f_82481_), false)) {
                            return InteractionResult.SUCCESS;
                        }
                        return InteractionResult.PASS;
                    }
                }
                return InteractionResult.PASS;
            }

            private boolean connectChests(Level world, BlockPos clickedPos, BlockPos otherPos, BlockState clickedState, BlockState otherState, Direction clickedFace, Direction chestFacing, double hitX, double hitZ, boolean swapDirections) {
                Direction newFacing = Direction.UP;
                if (!swapDirections) {
                    if (chestFacing == Direction.NORTH || chestFacing == Direction.SOUTH) {
                        newFacing = hitZ < 0.5 ? Direction.NORTH : Direction.SOUTH;
                    } else if (chestFacing == Direction.WEST || chestFacing == Direction.EAST) {
                        newFacing = hitX < 0.5 ? Direction.WEST : Direction.EAST;
                    }
                } else if (chestFacing == Direction.WEST || chestFacing == Direction.EAST) {
                    newFacing = hitZ < 0.5 ? Direction.NORTH : Direction.SOUTH;
                } else if (chestFacing == Direction.NORTH || chestFacing == Direction.SOUTH) {
                    Direction direction = newFacing = hitX < 0.5 ? Direction.WEST : Direction.EAST;
                }
                if (newFacing != Direction.UP) {
                    ChestType newType = this.getNewChestType(clickedFace, newFacing);
                    world.m_46597_(clickedPos, (BlockState)((BlockState)clickedState.m_61124_((Property)ChestBlock.f_51478_, (Comparable)newFacing)).m_61124_((Property)ChestBlock.f_51479_, (Comparable)newType));
                    world.m_46597_(otherPos, (BlockState)((BlockState)otherState.m_61124_((Property)ChestBlock.f_51478_, (Comparable)newFacing)).m_61124_((Property)ChestBlock.f_51479_, (Comparable)newType.m_61486_()));
                    return true;
                }
                return false;
            }

            private ChestType getNewChestType(Direction clickedFace, Direction chestFacing) {
                switch (chestFacing) {
                    case NORTH: {
                        return clickedFace == Direction.WEST ? ChestType.RIGHT : ChestType.LEFT;
                    }
                    case SOUTH: {
                        return clickedFace == Direction.WEST ? ChestType.LEFT : ChestType.RIGHT;
                    }
                    case EAST: {
                        return clickedFace == Direction.NORTH ? ChestType.RIGHT : ChestType.LEFT;
                    }
                    case WEST: {
                        return clickedFace == Direction.NORTH ? ChestType.LEFT : ChestType.RIGHT;
                    }
                }
                return ChestType.SINGLE;
            }

            private double frac(double d) {
                return Mth.m_14185_((double)d);
            }
        }.setRegistryName(new ResourceLocation(MODID, "chest_wrench"))));
    }
}

