/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.Expandable;
import me.shedaniel.clothconfig2.api.TabbedConfigScreen;
import me.shedaniel.clothconfig2.gui.AbstractConfigScreen;
import me.shedaniel.clothconfig2.gui.ClothConfigScreen;
import me.shedaniel.clothconfig2.gui.GlobalizedClothConfigScreen;
import me.shedaniel.clothconfig2.impl.ConfigCategoryImpl;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.jetbrains.annotations.ApiStatus;

@Environment(value=EnvType.CLIENT)
@ApiStatus.Internal
public class ConfigBuilderImpl
implements ConfigBuilder {
    private Runnable savingRunnable;
    private class_437 parent;
    private class_2561 title = new class_2588("text.cloth-config.config");
    private boolean globalized = false;
    private boolean globalizedExpanded = true;
    private boolean editable = true;
    private boolean tabsSmoothScroll = true;
    private boolean listSmoothScroll = true;
    private boolean doesConfirmSave = true;
    private boolean transparentBackground = false;
    private class_2960 defaultBackground = class_332.field_22735;
    private Consumer<class_437> afterInitConsumer = screen -> {};
    private final Map<class_2561, class_2960> categoryBackground = Maps.newHashMap();
    private final Map<class_2561, List<Object>> dataMap = Maps.newLinkedHashMap();
    private class_2561 fallbackCategory = null;
    private boolean alwaysShowTabs = false;

    @ApiStatus.Internal
    public ConfigBuilderImpl() {
    }

    @Override
    public void setGlobalized(boolean globalized) {
        this.globalized = globalized;
    }

    @Override
    public void setGlobalizedExpanded(boolean globalizedExpanded) {
        this.globalizedExpanded = globalizedExpanded;
    }

    @Override
    public boolean isAlwaysShowTabs() {
        return this.alwaysShowTabs;
    }

    @Override
    public ConfigBuilder setAlwaysShowTabs(boolean alwaysShowTabs) {
        this.alwaysShowTabs = alwaysShowTabs;
        return this;
    }

    @Override
    public ConfigBuilder setTransparentBackground(boolean transparentBackground) {
        this.transparentBackground = transparentBackground;
        return this;
    }

    @Override
    public ConfigBuilder setAfterInitConsumer(Consumer<class_437> afterInitConsumer) {
        this.afterInitConsumer = afterInitConsumer;
        return this;
    }

    @Override
    public ConfigBuilder setFallbackCategory(ConfigCategory fallbackCategory) {
        this.fallbackCategory = Objects.requireNonNull(fallbackCategory).getCategoryKey();
        return this;
    }

    @Override
    public class_437 getParentScreen() {
        return this.parent;
    }

    @Override
    public ConfigBuilder setParentScreen(class_437 parent) {
        this.parent = parent;
        return this;
    }

    @Override
    public class_2561 getTitle() {
        return this.title;
    }

    @Override
    public ConfigBuilder setTitle(class_2561 title) {
        this.title = title;
        return this;
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public ConfigBuilder setEditable(boolean editable) {
        this.editable = editable;
        return this;
    }

    @Override
    public ConfigCategory getOrCreateCategory(class_2561 categoryKey) {
        if (this.dataMap.containsKey(categoryKey)) {
            return new ConfigCategoryImpl(categoryKey, identifier -> {
                if (this.transparentBackground) {
                    throw new IllegalStateException("Cannot set category background if screen is using transparent background.");
                }
                this.categoryBackground.put(categoryKey, (class_2960)identifier);
            }, () -> this.dataMap.get(categoryKey), () -> this.removeCategory(categoryKey));
        }
        this.dataMap.put(categoryKey, Lists.newArrayList());
        if (this.fallbackCategory == null) {
            this.fallbackCategory = categoryKey;
        }
        return new ConfigCategoryImpl(categoryKey, identifier -> {
            if (this.transparentBackground) {
                throw new IllegalStateException("Cannot set category background if screen is using transparent background.");
            }
            this.categoryBackground.put(categoryKey, (class_2960)identifier);
        }, () -> this.dataMap.get(categoryKey), () -> this.removeCategory(categoryKey));
    }

    @Override
    public ConfigBuilder removeCategory(class_2561 category) {
        if (this.dataMap.containsKey(category) && this.fallbackCategory.equals(category)) {
            this.fallbackCategory = null;
        }
        if (!this.dataMap.containsKey(category)) {
            throw new NullPointerException("Category doesn't exist!");
        }
        this.dataMap.remove(category);
        return this;
    }

    @Override
    public ConfigBuilder removeCategoryIfExists(class_2561 category) {
        if (this.dataMap.containsKey(category) && this.fallbackCategory.equals(category)) {
            this.fallbackCategory = null;
        }
        this.dataMap.remove(category);
        return this;
    }

    @Override
    public boolean hasCategory(class_2561 category) {
        return this.dataMap.containsKey(category);
    }

    @Override
    public ConfigBuilder setShouldTabsSmoothScroll(boolean shouldTabsSmoothScroll) {
        this.tabsSmoothScroll = shouldTabsSmoothScroll;
        return this;
    }

    @Override
    public boolean isTabsSmoothScrolling() {
        return this.tabsSmoothScroll;
    }

    @Override
    public ConfigBuilder setShouldListSmoothScroll(boolean shouldListSmoothScroll) {
        this.listSmoothScroll = shouldListSmoothScroll;
        return this;
    }

    @Override
    public boolean isListSmoothScrolling() {
        return this.listSmoothScroll;
    }

    @Override
    public ConfigBuilder setDoesConfirmSave(boolean confirmSave) {
        this.doesConfirmSave = confirmSave;
        return this;
    }

    @Override
    public boolean doesConfirmSave() {
        return this.doesConfirmSave;
    }

    @Override
    public class_2960 getDefaultBackgroundTexture() {
        return this.defaultBackground;
    }

    @Override
    public ConfigBuilder setDefaultBackgroundTexture(class_2960 texture) {
        this.defaultBackground = texture;
        return this;
    }

    @Override
    public ConfigBuilder setSavingRunnable(Runnable runnable) {
        this.savingRunnable = runnable;
        return this;
    }

    @Override
    public Consumer<class_437> getAfterInitConsumer() {
        return this.afterInitConsumer;
    }

    @Override
    public class_437 build() {
        if (this.dataMap.isEmpty() || this.fallbackCategory == null) {
            throw new NullPointerException("There cannot be no categories or fallback category!");
        }
        AbstractConfigScreen screen = this.globalized ? new GlobalizedClothConfigScreen(this.parent, this.title, this.dataMap, this.defaultBackground) : new ClothConfigScreen(this.parent, this.title, this.dataMap, this.defaultBackground);
        screen.setSavingRunnable(this.savingRunnable);
        screen.setEditable(this.editable);
        screen.setFallbackCategory(this.fallbackCategory);
        screen.setTransparentBackground(this.transparentBackground);
        screen.setAlwaysShowTabs(this.alwaysShowTabs);
        screen.setConfirmSave(this.doesConfirmSave);
        screen.setAfterInitConsumer(this.afterInitConsumer);
        if (screen instanceof Expandable) {
            ((Expandable)((Object)screen)).setExpanded(this.globalizedExpanded);
        }
        if (screen instanceof TabbedConfigScreen) {
            this.categoryBackground.forEach(((TabbedConfigScreen)((Object)screen))::registerCategoryBackground);
        }
        return screen;
    }

    @Override
    public Runnable getSavingRunnable() {
        return this.savingRunnable;
    }
}

