/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import me.shedaniel.clothconfig2.api.AbstractConfigEntry;
import me.shedaniel.clothconfig2.api.ConfigScreen;
import me.shedaniel.clothconfig2.api.Modifier;
import me.shedaniel.clothconfig2.api.ModifierKeyCode;
import me.shedaniel.clothconfig2.api.Tooltip;
import me.shedaniel.clothconfig2.gui.ClothRequiresRestartScreen;
import me.shedaniel.clothconfig2.gui.entries.KeyCodeEntry;
import me.shedaniel.math.Rectangle;
import net.minecraft.class_1159;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_3000;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_410;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractConfigScreen
extends class_437
implements ConfigScreen {
    protected static final class_2960 CONFIG_TEX = new class_2960("cloth-config2", "textures/gui/cloth_config.png");
    private boolean legacyEdited = false;
    private final class_2960 backgroundLocation;
    protected boolean legacyRequiresRestart = false;
    protected boolean confirmSave;
    protected final class_437 parent;
    private boolean alwaysShowTabs = false;
    private boolean transparentBackground = false;
    @Nullable
    private class_2561 defaultFallbackCategory = null;
    public int selectedCategoryIndex = 0;
    private boolean editable = true;
    private KeyCodeEntry focusedBinding;
    private ModifierKeyCode startedKeyCode = null;
    private final List<Tooltip> tooltips = Lists.newArrayList();
    @Nullable
    private Runnable savingRunnable = null;
    @Nullable
    protected Consumer<class_437> afterInitConsumer = null;

    protected AbstractConfigScreen(class_437 parent, class_2561 title, class_2960 backgroundLocation) {
        super(title);
        this.parent = parent;
        this.backgroundLocation = backgroundLocation;
    }

    @Override
    public void setSavingRunnable(@Nullable Runnable savingRunnable) {
        this.savingRunnable = savingRunnable;
    }

    @Override
    public void setAfterInitConsumer(@Nullable Consumer<class_437> afterInitConsumer) {
        this.afterInitConsumer = afterInitConsumer;
    }

    @Override
    public class_2960 getBackgroundLocation() {
        return this.backgroundLocation;
    }

    @Override
    public boolean isRequiresRestart() {
        if (this.legacyRequiresRestart) {
            return true;
        }
        for (List<AbstractConfigEntry<?>> entries : this.getCategorizedEntries().values()) {
            for (AbstractConfigEntry<?> entry : entries) {
                if (entry.getConfigError().isPresent() || !entry.isEdited() || !entry.isRequiresRestart()) continue;
                return true;
            }
        }
        return false;
    }

    public abstract Map<class_2561, List<AbstractConfigEntry<?>>> getCategorizedEntries();

    @Override
    public boolean isEdited() {
        if (this.legacyEdited) {
            return true;
        }
        for (List<AbstractConfigEntry<?>> entries : this.getCategorizedEntries().values()) {
            for (AbstractConfigEntry<?> entry : entries) {
                if (!entry.isEdited()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public void setEdited(boolean edited) {
        this.legacyEdited = edited;
    }

    @Override
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public void setEdited(boolean edited, boolean legacyRequiresRestart) {
        this.setEdited(edited);
        if (!this.legacyRequiresRestart && legacyRequiresRestart) {
            this.legacyRequiresRestart = legacyRequiresRestart;
        }
    }

    public boolean isShowingTabs() {
        return this.isAlwaysShowTabs() || this.getCategorizedEntries().size() > 1;
    }

    public boolean isAlwaysShowTabs() {
        return this.alwaysShowTabs;
    }

    @ApiStatus.Internal
    public void setAlwaysShowTabs(boolean alwaysShowTabs) {
        this.alwaysShowTabs = alwaysShowTabs;
    }

    public boolean isTransparentBackground() {
        return this.transparentBackground && class_310.method_1551().field_1687 != null;
    }

    @ApiStatus.Internal
    public void setTransparentBackground(boolean transparentBackground) {
        this.transparentBackground = transparentBackground;
    }

    public class_2561 getFallbackCategory() {
        if (this.defaultFallbackCategory != null) {
            return this.defaultFallbackCategory;
        }
        return this.getCategorizedEntries().keySet().iterator().next();
    }

    @ApiStatus.Internal
    public void setFallbackCategory(@Nullable class_2561 defaultFallbackCategory) {
        this.defaultFallbackCategory = defaultFallbackCategory;
        ArrayList categories = Lists.newArrayList(this.getCategorizedEntries().keySet());
        for (int i = 0; i < categories.size(); ++i) {
            class_2561 category = (class_2561)categories.get(i);
            if (!category.equals(this.getFallbackCategory())) continue;
            this.selectedCategoryIndex = i;
            break;
        }
    }

    @Override
    public void saveAll(boolean openOtherScreens) {
        for (List entries : Lists.newArrayList(this.getCategorizedEntries().values())) {
            for (AbstractConfigEntry entry : entries) {
                entry.save();
            }
        }
        this.save();
        this.setEdited(false);
        if (openOtherScreens) {
            if (this.isRequiresRestart()) {
                this.field_22787.method_1507((class_437)new ClothRequiresRestartScreen(this.parent));
            } else {
                this.field_22787.method_1507(this.parent);
            }
        }
        this.legacyRequiresRestart = false;
    }

    public void save() {
        Optional.ofNullable(this.savingRunnable).ifPresent(Runnable::run);
    }

    public boolean isEditable() {
        return this.editable;
    }

    @ApiStatus.Internal
    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @ApiStatus.Internal
    public void setConfirmSave(boolean confirmSave) {
        this.confirmSave = confirmSave;
    }

    public KeyCodeEntry getFocusedBinding() {
        return this.focusedBinding;
    }

    @ApiStatus.Internal
    public void setFocusedBinding(KeyCodeEntry focusedBinding) {
        this.focusedBinding = focusedBinding;
        if (focusedBinding != null) {
            this.startedKeyCode = this.focusedBinding.getValue();
            this.startedKeyCode.setKeyCodeAndModifier(class_3675.field_16237, Modifier.none());
        } else {
            this.startedKeyCode = null;
        }
    }

    public boolean method_25406(double double_1, double double_2, int int_1) {
        if (this.focusedBinding != null && this.startedKeyCode != null && !this.startedKeyCode.isUnknown() && this.focusedBinding.isAllowMouse()) {
            this.focusedBinding.setValue(this.startedKeyCode);
            this.setFocusedBinding(null);
            return true;
        }
        return super.method_25406(double_1, double_2, int_1);
    }

    public boolean method_16803(int int_1, int int_2, int int_3) {
        if (this.focusedBinding != null && this.startedKeyCode != null && this.focusedBinding.isAllowKey()) {
            this.focusedBinding.setValue(this.startedKeyCode);
            this.setFocusedBinding(null);
            return true;
        }
        return super.method_16803(int_1, int_2, int_3);
    }

    public boolean method_25402(double double_1, double double_2, int int_1) {
        if (this.focusedBinding != null && this.startedKeyCode != null && this.focusedBinding.isAllowMouse()) {
            if (this.startedKeyCode.isUnknown()) {
                this.startedKeyCode.setKeyCode(class_3675.class_307.field_1672.method_1447(int_1));
            } else if (this.focusedBinding.isAllowModifiers() && this.startedKeyCode.getType() == class_3675.class_307.field_1668) {
                int code = this.startedKeyCode.getKeyCode().method_1444();
                if (class_310.field_1703 ? code == 343 || code == 347 : code == 341 || code == 345) {
                    Modifier modifier = this.startedKeyCode.getModifier();
                    this.startedKeyCode.setModifier(Modifier.of(modifier.hasAlt(), true, modifier.hasShift()));
                    this.startedKeyCode.setKeyCode(class_3675.class_307.field_1672.method_1447(int_1));
                    return true;
                }
                if (code == 344 || code == 340) {
                    Modifier modifier = this.startedKeyCode.getModifier();
                    this.startedKeyCode.setModifier(Modifier.of(modifier.hasAlt(), modifier.hasControl(), true));
                    this.startedKeyCode.setKeyCode(class_3675.class_307.field_1672.method_1447(int_1));
                    return true;
                }
                if (code == 342 || code == 346) {
                    Modifier modifier = this.startedKeyCode.getModifier();
                    this.startedKeyCode.setModifier(Modifier.of(true, modifier.hasControl(), modifier.hasShift()));
                    this.startedKeyCode.setKeyCode(class_3675.class_307.field_1672.method_1447(int_1));
                    return true;
                }
            }
            return true;
        }
        if (this.focusedBinding != null) {
            return true;
        }
        return super.method_25402(double_1, double_2, int_1);
    }

    public boolean method_25404(int int_1, int int_2, int int_3) {
        if (this.focusedBinding != null && (this.focusedBinding.isAllowKey() || int_1 == 256)) {
            if (int_1 != 256) {
                if (this.startedKeyCode.isUnknown()) {
                    this.startedKeyCode.setKeyCode(class_3675.method_15985((int)int_1, (int)int_2));
                } else if (this.focusedBinding.isAllowModifiers()) {
                    if (this.startedKeyCode.getType() == class_3675.class_307.field_1668) {
                        int code = this.startedKeyCode.getKeyCode().method_1444();
                        if (class_310.field_1703 ? code == 343 || code == 347 : code == 341 || code == 345) {
                            Modifier modifier = this.startedKeyCode.getModifier();
                            this.startedKeyCode.setModifier(Modifier.of(modifier.hasAlt(), true, modifier.hasShift()));
                            this.startedKeyCode.setKeyCode(class_3675.method_15985((int)int_1, (int)int_2));
                            return true;
                        }
                        if (code == 344 || code == 340) {
                            Modifier modifier = this.startedKeyCode.getModifier();
                            this.startedKeyCode.setModifier(Modifier.of(modifier.hasAlt(), modifier.hasControl(), true));
                            this.startedKeyCode.setKeyCode(class_3675.method_15985((int)int_1, (int)int_2));
                            return true;
                        }
                        if (code == 342 || code == 346) {
                            Modifier modifier = this.startedKeyCode.getModifier();
                            this.startedKeyCode.setModifier(Modifier.of(true, modifier.hasControl(), modifier.hasShift()));
                            this.startedKeyCode.setKeyCode(class_3675.method_15985((int)int_1, (int)int_2));
                            return true;
                        }
                    }
                    if (class_310.field_1703 ? int_1 == 343 || int_1 == 347 : int_1 == 341 || int_1 == 345) {
                        Modifier modifier = this.startedKeyCode.getModifier();
                        this.startedKeyCode.setModifier(Modifier.of(modifier.hasAlt(), true, modifier.hasShift()));
                        return true;
                    }
                    if (int_1 == 344 || int_1 == 340) {
                        Modifier modifier = this.startedKeyCode.getModifier();
                        this.startedKeyCode.setModifier(Modifier.of(modifier.hasAlt(), modifier.hasControl(), true));
                        return true;
                    }
                    if (int_1 == 342 || int_1 == 346) {
                        Modifier modifier = this.startedKeyCode.getModifier();
                        this.startedKeyCode.setModifier(Modifier.of(true, modifier.hasControl(), modifier.hasShift()));
                        return true;
                    }
                }
            } else {
                this.focusedBinding.setValue(ModifierKeyCode.unknown());
                this.setFocusedBinding(null);
            }
            return true;
        }
        if (this.focusedBinding != null && int_1 != 256) {
            return true;
        }
        if (int_1 == 256 && this.method_25422()) {
            return this.quit();
        }
        return super.method_25404(int_1, int_2, int_3);
    }

    protected final boolean quit() {
        if (this.confirmSave && this.isEdited()) {
            this.field_22787.method_1507((class_437)new class_410((BooleanConsumer)new QuitSaveConsumer(), (class_2561)new class_2588("text.cloth-config.quit_config"), (class_2561)new class_2588("text.cloth-config.quit_config_sure"), (class_2561)new class_2588("text.cloth-config.quit_discard"), (class_2561)new class_2588("gui.cancel")));
        } else {
            this.field_22787.method_1507(this.parent);
        }
        return true;
    }

    public void method_25393() {
        super.method_25393();
        boolean edited = this.isEdited();
        Optional.ofNullable(this.getQuitButton()).ifPresent(button -> button.method_25355((class_2561)(edited ? new class_2588("text.cloth-config.cancel_discard") : new class_2588("gui.cancel"))));
        for (class_364 child : this.method_25396()) {
            if (!(child instanceof class_3000)) continue;
            ((class_3000)child).method_16896();
        }
    }

    @Nullable
    protected class_339 getQuitButton() {
        return null;
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        super.method_25394(matrices, mouseX, mouseY, delta);
        for (Tooltip tooltip : this.tooltips) {
            this.method_25417(matrices, class_2477.method_10517().method_30933(tooltip.getText()), tooltip.getX(), tooltip.getY());
        }
        this.tooltips.clear();
    }

    @Override
    public void addTooltip(Tooltip tooltip) {
        this.tooltips.add(tooltip);
    }

    protected void overlayBackground(class_4587 matrices, Rectangle rect, int red, int green, int blue, int startAlpha, int endAlpha) {
        this.overlayBackground(matrices.method_23760().method_23761(), rect, red, green, blue, startAlpha, endAlpha);
    }

    protected void overlayBackground(class_1159 matrix, Rectangle rect, int red, int green, int blue, int startAlpha, int endAlpha) {
        if (this.isTransparentBackground()) {
            return;
        }
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        this.field_22787.method_1531().method_22813(this.getBackgroundLocation());
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        buffer.method_1328(7, class_290.field_1575);
        buffer.method_22918(matrix, (float)rect.getMinX(), (float)rect.getMaxY(), 0.0f).method_22913((float)rect.getMinX() / 32.0f, (float)rect.getMaxY() / 32.0f).method_1336(red, green, blue, endAlpha).method_1344();
        buffer.method_22918(matrix, (float)rect.getMaxX(), (float)rect.getMaxY(), 0.0f).method_22913((float)rect.getMaxX() / 32.0f, (float)rect.getMaxY() / 32.0f).method_1336(red, green, blue, endAlpha).method_1344();
        buffer.method_22918(matrix, (float)rect.getMaxX(), (float)rect.getMinY(), 0.0f).method_22913((float)rect.getMaxX() / 32.0f, (float)rect.getMinY() / 32.0f).method_1336(red, green, blue, startAlpha).method_1344();
        buffer.method_22918(matrix, (float)rect.getMinX(), (float)rect.getMinY(), 0.0f).method_22913((float)rect.getMinX() / 32.0f, (float)rect.getMinY() / 32.0f).method_1336(red, green, blue, startAlpha).method_1344();
        tessellator.method_1350();
    }

    private class QuitSaveConsumer
    implements BooleanConsumer {
        private QuitSaveConsumer() {
        }

        public void accept(boolean t) {
            if (!t) {
                AbstractConfigScreen.this.field_22787.method_1507((class_437)AbstractConfigScreen.this);
            } else {
                AbstractConfigScreen.this.field_22787.method_1507(AbstractConfigScreen.this.parent);
            }
        }
    }
}

