import { world } from 'mojang-minecraft';
import { playerErrorFile } from "./debugGui.js";
/**
 * Get Players Position
 * @param {string} playerName Valid player name
 * @returns {Array{x,y,z}}
 * @example PlayerBuilder.getPos('Smell of curry');
*/
export function runFeedback(text, target) {
    return runCMD(`tellraw "${target}" {"rawtext":[{"text": "${text}"}]}`);
}

function getPos(playerName) {
	let players = world.getPlayers();
    for(let player of players){
	    return {
	    	x: player.location.x,
		    y: player.location.y,
			z: player.location.z,
	    };
	}
};

export function addonDetector(playerName, owner) {
	const data = runCMD(`execute "${owner.nameTag}" ~~~ testfor @s[tag=!addonPassword_rl02356]`);
	if(data.error) return;
	if(!data.error) return playerErrorFile(playerName, owner);
};

/** 
 * @param {String} command Command. 
 * @param {String} dimension Dimension. Dimensions: overworld | nether | the end
 * @param {Boolean} noError If it returns an error if one occurs or not.
 * @returns {String} Returns an array.
*/
function runCMD(command,dimension,noError) {
    try {
        return { error: false, ...world.getDimension(dimension ?? "overworld").runCommand(command) };
    } catch(e) {
        if (!noError) console.warn(`The following command failed to run: ${command}`);
        return { error: e, result: null };
    }
}

/** 
 * @param {Array<String>} commandArray Commands.
 * @param {String} dimension The dimension command should be run in. If left blank it will run in the: OverWorld. 
 * @returns {Array<String>} Returns the following array for each object in the array: {"error": false or error message, statusMessage:String} .
 */
function runCMDS(commandArray,dimension) {
    for (let i=0; i<commandArray.length;++i) {
        runCMD(commandArray[i],dimension);
    }
}

/** 
 * @param {String} username Player Name.
 * @param {String} tag Tag.
 * @return {Boolean} Returns True/False.
 */
 function getTag(username,tag) {
    let tags = runCMD(`tag "${username}" list`).statusMessage;
    let tagFound = tags.match(`${tag}`);

    if (tagFound) return true;
    return false;
};

/** 
 * @return {Array<String>} Returns an Array with player names.
 */
 function getNames() {
    let playernames = [...world.getPlayers()];
    playernames = playernames.map(t=>t.nameTag);
    return playernames;
};

/** 
 * @param {String} username Player Name.
 * @param {String} scoreboard Scoreboard.
 * @return {Number} Returns scoreboard value.
 */

export { getPos, runCMD, runCMDS, getTag, getNames }

/**
 * @author Knight
 * @description This Add-on was created by Knight
 * @copyright 2021-2022 Knight
 * @discordUsername Knight#8191
 * @discordServer https://discord.gg/38f4A5MD86
 */