
import * as minecraft from 'mojang-minecraft';
import { runCMDS, runCMD } from "../aoenFantasy/utilities.js";
import { testTag, executeCommand } from "../aoenFantasy/functions/newutils.js";

export function swordOfTallTargetSet(player) {
	const testing = runCMD(`execute "${player.nameTag}" ~~~ testfor @s[tag=lookingTarget]`);
	if(testing.error) return;
	var querys=new minecraft.EntityRaycastOptions();
	querys.maxDistance = 30;
	let targets= player.getEntitiesFromViewVector(querys);
	targets[0].runCommand('particle finalfantasy:tall_sword_charging ~~0.3~');
};

export function swordOfTallTarget(player) {
	const test = runCMD(`execute "${player.nameTag}" ~~~ testfor @s[tag=searchTarget]`);
	if(test.error) return;
	var query=new minecraft.EntityRaycastOptions();
	query.maxDistance = 30;
	let target= player.getEntitiesFromViewVector(query);
	target[0].runCommand(`tp "${player.nameTag}" ^^0.3^1.5 facing @s`);
	player.runCommand('tag @s remove searchTarget');
};

export function searchTargetTrident(player) {
	const testP = runCMD(`execute "${player.nameTag}" ~~~ testfor @s[tag=searchTargetTrident]`);
	if(testP.error) return;
	var queryP=new minecraft.EntityRaycastOptions();
	queryP.maxDistance = 8;
	let targetP= player.getEntitiesFromViewVector(queryP);
	targetP[0].runCommand('tag @s add targetTr');
	player.runCommand('tag @s remove searchTargetTrident');
};