
import {
  BlockLocation,
  MinecraftBlockTypes,
  MinecraftItemTypes,
  BlockProperties,
  Direction,
  world,
  Location,
} from "mojang-minecraft";
import { runFeedback, addonDetector, getPos, getTag, runCMDS, runCMD } from "./utilities.js";
import { configuration } from "./config.js";
import { searchTargetTrident, swordOfTallTargetSet, swordOfTallTarget } from "./swordoftallTarget.js";
import { applyParticle } from "./functions/particles";
import { worldDate } from "./functions/date";
import { giftPotBreak } from "./functions/giftpot_destroy";
import { executeCommand } from "./functions/newutils";
const finalfantasy_Item = configuration.ff_items;

world.events.itemUse.subscribe((data) => {
	let player = data.source
	let item = data.item
	if (!finalfantasy_Item.includes(item.id)) return;
	const testItem = player.runCommand(`testfor @s[tag=!addonPassword_item02380]`);
	if(testItem.error) return;
	runFeedback("[Server] [§dFinal Fantasy§r§f] : error at >> 'player.json' <<", player.nameTag);
});
	
world.events.blockBreak.subscribe(eventData => {
	giftPotBreak(eventData)
});

world.events.tick.subscribe((data) => {
	let players = world.getPlayers();
	for(let player of players){
		worldDate(player);
		swordOfTallTargetSet(player);
		swordOfTallTarget(player);
		searchTargetTrident(player);
		var cmds = runCMDS([
			`function fixViviScore`,
			`function grass_step`
		]);
		addonDetector(player.nameTag, player);
		const advsget = player.runCommand(`testfor @s[hasitem={item=ravemontod:ifrit_soul},tag=!"advs.ifrit_soul"]`);
		if(!advsget.error) return runCMDS([
			`tellraw "${player.nameTag}" {"rawtext":[{"text": "§f§r${player.nameTag} §ahas been got advanment §r§f[§eThe Ifrit Owner§r§f]"}]}`,
			`tag "${player.nameTag}" add "advs.ifrit_soul"`
		]);
		
		const goExploler= player.runCommand(`testfor @s[hasitem={item=aoen:ifrit_shoes},tag=!"advs.ifrit_shoes"]`);
		if(!goExploler.error) return runCMDS([
			`tellraw "${player.nameTag}" {"rawtext":[{"text": "§f§r${player.nameTag} §ahas been got advanment §r§f[§eGo Explore§r§f]"}]}`,
			`tag "${player.nameTag}" add "advs.ifrit_shoes"`
		]);
		applyParticle(player);
	}
});