
import * as minecraft from 'mojang-minecraft';

export function itemTransform(){
	var config={
		unique: 0,
		secs: 0,
		dims: [minecraft.world.getDimension("overworld"), minecraft.world.getDimension("nether"), minecraft.world.getDimension("the end")]
	}
	
	for(let dim of config["dims"]){
		var q=new minecraft.EntityRaycastOptions();
		q.type = "item";
		const items = dim.getEntities(q);
		for(item of items){
			var monsterSpawn = item.runCommand(`testfor @s[name="monster_spawn"]`)
			var mobSpawn = item.runCommand(`testfor @s[name="mob_spawn"]`)
			var itemEvent = item.runCommand(`testfor @s[name="item_event"]`)
			if(monsterSpawn){
				item.runCommand(`summon zombie ~~~ minecraft:zombie_baby "Baa!!"`)
				item.runCommand(`kill @s`)
			} else if(itemEvent){
				item.runCommand(`summon armor_stand ~~~ finalfantasy:cstevent "item"`)
				item.runCommand(`kill @s`)
			} else if(mobSpawn){
				item.runCommand(`summon chicken ~~~ minecraft:from_egg "uwu"`)
				item.runCommand(`kill @s`)
			}
		}
	}
}