import { world } from 'mojang-minecraft';
import { runFeedback, getPos, getTag, runCMDS, runCMD } from "./utilities.js";
import {
    ActionFormData,
    ModalFormData,
    MessageFormData
} from "mojang-minecraft-ui"
/**
 * Get Players Position
 * @param {string} playerName Valid player name
 * @returns {Array{x,y,z}}
 * @example PlayerBuilder.getPos('Smell of curry');
*/
export function playerErrorFile(player, owner) {
    let debug = new MessageFormData()
    debug.title("entities/player.json")
    debug.body(`§dFinal Fantasy Addon\n\n§cUnknow Error on:\n§r§fplayer.json\n§emake sure you put this addon on §bthe top row§r§f\nError on: Duplicate on player.json`)
    debug.button1("§cContinue?")
    debug.button2("§aHow to Fix?")
	
	debug.show(owner).then(eventData => {
		const { isCanceled, selection } = eventData
		if (isCanceled === true) return runCMDS([
			`tag "${owner.nameTag}" remove addonPassword_rl02356`
		]);
		switch(selection) {
			case 0:
				runFeedback('helpPage.howTo.fixplayerError.text', player);
				runCMDS([
					`tag "${owner.nameTag}" add addonPassword_rl02356`
				]);
				break;
			case 1:
				runCMDS([
					`tag "${owner.nameTag}" add addonPassword_rl02356`
				]);
				break;
		}
	})
};
