
import { getPos, Block } from '../../../library/Minecraft.js';
import { getBlock, blockHasDatas, blockHasData, getItemTag, realisticBlockBreak } from '../../../library/blockApi.js';
import { debugError } from '../../../library/debugUi.js';
import { particleOnce } from '../../../library/particles.js';
export function blockStone(block) {
	
	const {x, y, z} = getPos(block, block.id)
    var posX = Math.floor(x)
    var posY = Math.floor(y)
    var posZ = Math.floor(z)
    if(!posX) return debugError(`Error]> cant find block pos X`);
    if(!posY) return debugError(`Error]> cant find block pos Y`);
    if(!posZ) return debugError(`Error]> cant find block pos Z`);
	const isBlock = getBlock(
		block.id,
		posX,
		posY,
		posZ
	);
	if(!isBlock) return debugError(`Error]> cant find block Data`);
	const onPlace = blockHasDatas(isBlock, 'minecraft:on_player_placing', 'minecraft:player_place');
	if(onPlace) particleOnce(
		'test:block_placed',
		posX,
		posY,
		posZ
	);
	const blockBreak = blockHasDatas(isBlock, 'minecraft:on_player_destroyed', 'minecraft:player_destroy', 'minecraft:block_destroy');
	if(!blockBreak) return;
	const itemOnBreaking = getItemTag('slot.weapon.mainhand');
	switch (itemOnBreaking) {
        case "minecraft:is_pickaxe":
            return realisticBlockBreak([
	            'minecraft:stone',
				'0.5',
				'minecraft:cobblestone'
            ]);
        default:
            return realisticBlockBreak([
	            'minecraft:stone',
				'0.5'
            ]);
    }
};