/*
 * Decompiled with CFR 0.152.
 */
package com.github.samarium150.structurescompass.util;

import com.github.samarium150.structurescompass.config.StructuresCompassConfig;
import com.github.samarium150.structurescompass.util.GeneralUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class StructureUtils {
    public static List<StructureFeature<?>> allowedStructures;
    public static HashMap<String, List<String>> structuresDimensionMap;

    StructureUtils() {
    }

    public static ResourceLocation getResourceForStructure(@Nonnull StructureFeature<?> structure) {
        return ForgeRegistries.STRUCTURE_FEATURES.getKey(structure);
    }

    @Nullable
    public static StructureFeature<?> getStructureForResource(ResourceLocation resource) {
        return (StructureFeature)ForgeRegistries.STRUCTURE_FEATURES.getValue(resource);
    }

    @Nonnull
    public static List<StructureFeature<?>> getAllowedStructures() {
        ArrayList result = new ArrayList();
        for (StructureFeature structureFeature : ForgeRegistries.STRUCTURE_FEATURES) {
            ResourceLocation res = structureFeature.getRegistryName();
            if (res == null || StructureUtils.isStructureBanned(res.toString())) continue;
            result.add(structureFeature);
        }
        return result;
    }

    public static boolean isStructureBanned(String name) {
        boolean flag = StructuresCompassConfig.filterMode.get() == StructuresCompassConfig.Mode.whitelist;
        ArrayList filters = (ArrayList)StructuresCompassConfig.filter.get();
        for (String filter : filters) {
            String rx = GeneralUtils.convertToRegex(filter);
            boolean matching = name.matches(rx);
            if (flag && matching) {
                return false;
            }
            if (!matching) continue;
            return true;
        }
        return flag;
    }

    @Nonnull
    public static String getStructureName(@Nonnull StructureFeature<?> structure) {
        ResourceLocation registry = structure.getRegistryName();
        return registry == null ? "" : registry.toString();
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public static String getLocalizedStructureName(@Nonnull String resource) {
        if (resource.equals("")) {
            return "";
        }
        int split = resource.indexOf(":");
        if (split == -1) {
            return resource;
        }
        String source = resource.substring(0, split);
        String name = resource.substring(split + 1);
        return I18n.m_118938_((String)String.format("structure.%s.%s", source, name), (Object[])new Object[0]);
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public static String getLocalizedStructureName(@Nonnull StructureFeature<?> structure) {
        return StructureUtils.getLocalizedStructureName(StructureUtils.getStructureName(structure));
    }

    @Nonnull
    public static List<String> getDimensions(@Nonnull ServerLevel world, StructureFeature<?> structure) {
        ArrayList<String> dims = new ArrayList<String>();
        MinecraftServer server = world.m_142572_();
        server.m_129785_().forEach(w -> {
            if (w.m_7726_().m_8481_().m_62218_().m_47917_(structure)) {
                dims.add(w.m_46472_().m_135782_().toString());
            }
        });
        return dims;
    }

    @Nonnull
    public static String getDimensions(@Nonnull StructureFeature<?> structure) {
        List dims = structuresDimensionMap.getOrDefault(StructureUtils.getResourceForStructure(structure).toString(), new ArrayList());
        return dims == null ? "" : dims.toString();
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public static String getLocalizedDimensionName(@Nonnull String resource) {
        int split = resource.indexOf(":");
        if (split == -1) {
            return resource;
        }
        String source = resource.substring(0, split);
        String name = resource.substring(split + 1);
        return I18n.m_118938_((String)String.format("dimension.%s.%s", source, name), (Object[])new Object[0]);
    }

    public static String getStructureSource(@Nonnull StructureFeature<?> structure) {
        if (StructureUtils.getResourceForStructure(structure) == null) {
            return "";
        }
        String registry = StructureUtils.getResourceForStructure(structure).toString();
        String name = registry.substring(0, registry.indexOf(":"));
        if (name.equals("minecraft")) {
            return "Minecraft";
        }
        Optional source = ModList.get().getModContainerById(name);
        if (source.isPresent()) {
            return ((ModContainer)source.get()).getModInfo().getDisplayName();
        }
        return name;
    }

    @Nonnull
    public static Vec3 getDistance(@Nonnull BlockPos pos, @Nonnull Entity entity) {
        double disX = (double)Math.round(((double)pos.m_123341_() - entity.m_20185_()) * 100.0) / 100.0;
        double disY = pos.m_123342_() == 0 ? 0.0 : (double)Math.round(((double)pos.m_123342_() - entity.m_20186_()) * 100.0) / 100.0;
        double disZ = (double)Math.round(((double)pos.m_123343_() - entity.m_20189_()) * 100.0) / 100.0;
        return new Vec3(disX, disY, disZ);
    }
}

