/*
 * Decompiled with CFR 0.152.
 */
package com.github.samarium150.structurescompass.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Base64;

public interface Serializer<T extends Serializable> {
    default public String serialize(T obj) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(out);
        oos.writeObject(obj);
        oos.close();
        return Base64.getEncoder().encodeToString(out.toByteArray());
    }

    default public T deserialize(String s) throws IOException, ClassNotFoundException {
        byte[] data = Base64.getDecoder().decode(s);
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));
        Serializable obj = (Serializable)ois.readObject();
        ois.close();
        return (T)obj;
    }
}

