/*
 * Decompiled with CFR 0.152.
 */
package com.github.samarium150.structurescompass.util;

import com.github.samarium150.structurescompass.config.HUDPosition;
import com.github.samarium150.structurescompass.config.StructuresCompassConfig;
import com.github.samarium150.structurescompass.util.GeneralUtils;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class RenderUtils {
    private static final Minecraft minecraft = Minecraft.m_91087_();
    private static final Font fontRenderer = RenderUtils.minecraft.f_91062_;

    private RenderUtils() {
    }

    private static void drawStringLeft(PoseStack matrixStack, String string, int x, int y, int color) {
        fontRenderer.m_92883_(matrixStack, string, (float)x, (float)y, color);
    }

    private static void drawStringRight(PoseStack matrixStack, String string, int x, int y, int color) {
        fontRenderer.m_92883_(matrixStack, string, (float)x, (float)y, color);
    }

    public static void drawConfiguredStringOnHUD(PoseStack matrixStack, String string, int xOffset, int yOffset, int color, int relLineOffset) {
        yOffset += (relLineOffset + (Integer)StructuresCompassConfig.overlayLineOffset.get()) * 9;
        if (StructuresCompassConfig.hudPosition.get() == HUDPosition.LEFT) {
            RenderUtils.drawStringLeft(matrixStack, string, xOffset + (Integer)StructuresCompassConfig.xOffset.get() - 5, yOffset + (Integer)StructuresCompassConfig.yOffset.get() - 14, color);
        } else {
            RenderUtils.drawStringRight(matrixStack, string, minecraft.m_91268_().m_85445_() - fontRenderer.m_92895_(string) - xOffset - (Integer)StructuresCompassConfig.xOffset.get() + 5, yOffset + (Integer)StructuresCompassConfig.yOffset.get() - 14, color);
        }
    }

    public static void updateBuffer(@Nonnull BufferBuilder buffer, int startX, int startY, int endX, int endY) {
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        buffer.m_5483_((double)startX, (double)endY, 0.0).m_5752_();
        buffer.m_5483_((double)endX, (double)endY, 0.0).m_5752_();
        buffer.m_5483_((double)endX, (double)startY, 0.0).m_5752_();
        buffer.m_5483_((double)startX, (double)startY, 0.0).m_5752_();
    }

    public static void drawRect(int left, int top, int right, int bottom, int color) {
        if (left < right) {
            Integer[] integerArray = new Integer[2];
            integerArray[0] = right;
            right = left;
            integerArray[1] = right;
            left = GeneralUtils.swap(integerArray);
        }
        if (top < bottom) {
            Integer[] integerArray = new Integer[2];
            integerArray[0] = bottom;
            bottom = top;
            integerArray[1] = bottom;
            top = GeneralUtils.swap(integerArray);
        }
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        RenderSystem.m_69478_();
        RenderSystem.m_69472_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.m_157429_((float)red, (float)green, (float)blue, (float)alpha);
        RenderUtils.updateBuffer(buffer, left, top, right, bottom);
        tesselator.m_85914_();
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
    }
}

