/*
 * Decompiled with CFR 0.152.
 */
package com.github.samarium150.structurescompass.util;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class GeneralUtils {
    public static final String MOD_ID = "structurescompass";
    public static final Logger logger = LogManager.getLogger((String)"structurescompass");

    private GeneralUtils() {
    }

    @SafeVarargs
    public static <T> T swap(T ... args) {
        return args[0];
    }

    @Nonnull
    public static List<String> splitEqually(@Nonnull String text, int size) {
        ArrayList<String> ret = new ArrayList<String>((text.length() + size - 1) / size);
        for (int start = 0; start < text.length(); start += size) {
            ret.add(text.substring(start, Math.min(text.length(), start + size)));
        }
        return ret;
    }

    @Nonnull
    public static String convertToRegex(@Nonnull String glob) {
        StringBuilder regex = new StringBuilder("^");
        block5: for (int i = 0; i < glob.length(); i = (int)((char)(i + 1))) {
            char c = glob.charAt(i);
            switch (c) {
                case '*': {
                    regex.append(".*");
                    continue block5;
                }
                case '?': {
                    regex.append(".");
                    continue block5;
                }
                case '.': {
                    regex.append("\\.");
                    continue block5;
                }
                default: {
                    regex.append(c);
                }
            }
        }
        regex.append("$");
        return regex.toString();
    }
}

