/*
 * Decompiled with CFR 0.152.
 */
package com.github.samarium150.structurescompass.network.packet;

import com.github.samarium150.structurescompass.item.StructuresCompassItem;
import com.github.samarium150.structurescompass.network.packet.Packet;
import com.github.samarium150.structurescompass.util.ItemUtils;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public final class CompassSkipExistingChunksPacket
implements Packet {
    private final Boolean skip;

    public CompassSkipExistingChunksPacket(Boolean skip) {
        this.skip = skip;
    }

    public CompassSkipExistingChunksPacket(@Nonnull FriendlyByteBuf buffer) {
        this.skip = buffer.readBoolean();
    }

    @Override
    public void toBytes(@Nonnull FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.skip.booleanValue());
    }

    @Override
    public void handle(@Nonnull Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            ItemStack stack = ItemUtils.getHeldStructuresCompass((Player)player);
            if (!stack.m_41619_() && player != null) {
                StructuresCompassItem.setSkip(this.skip, stack);
            }
        });
        context.setPacketHandled(true);
    }
}

