/*
 * Decompiled with CFR 0.152.
 */
package com.github.samarium150.structurescompass.item;

import com.github.samarium150.structurescompass.config.StructuresCompassConfig;
import com.github.samarium150.structurescompass.network.StructuresCompassNetwork;
import com.github.samarium150.structurescompass.network.packet.CompassSearchPacket;
import com.github.samarium150.structurescompass.network.packet.RequestSyncPacket;
import com.github.samarium150.structurescompass.util.ItemUtils;
import com.github.samarium150.structurescompass.util.StructureUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class StructuresCompassItem
extends Item {
    public static final String NAME = "structures_compass";
    private static final String STRUCTURE_TAG = "Structure";
    private static final String DIM_TAG = "Dimension";
    private static final String POS_TAG = "Position";
    private static final String SKIP_TAG = "SkipExistingChunks";

    public StructuresCompassItem() {
        super(new Item.Properties().m_41491_(CreativeModeTab.f_40756_).m_41487_(1).m_41497_(Rarity.COMMON));
    }

    @Nonnull
    public static ItemStack setStructureName(String name, @Nonnull ItemStack stack) {
        CompoundTag tag = ItemUtils.getOrCreateItemTag(stack);
        if (tag != null) {
            tag.m_128365_(STRUCTURE_TAG, (Tag)StringTag.m_129297_((String)name));
            stack.m_41751_(tag);
        }
        return stack;
    }

    @Nullable
    public static String getStructureName(@Nonnull ItemStack stack) {
        CompoundTag tag = ItemUtils.getItemTag(stack);
        return tag != null ? tag.m_128461_(STRUCTURE_TAG) : null;
    }

    public static void setPos(BlockPos pos, @Nonnull ItemStack stack) {
        CompoundTag tag = ItemUtils.getOrCreateItemTag(stack);
        if (tag != null) {
            tag.m_128365_(POS_TAG, (Tag)LongTag.m_128882_((long)pos.m_121878_()));
            stack.m_41751_(tag);
        }
    }

    @Nullable
    public static BlockPos getPos(@Nonnull ItemStack stack) {
        CompoundTag tag = ItemUtils.getItemTag(stack);
        return tag != null && tag.m_128425_(POS_TAG, 4) ? BlockPos.m_122022_((long)tag.m_128454_(POS_TAG)) : null;
    }

    public static void setDimension(String dimension, @Nonnull ItemStack stack) {
        CompoundTag tag = ItemUtils.getOrCreateItemTag(stack);
        if (tag != null) {
            tag.m_128365_(DIM_TAG, (Tag)StringTag.m_129297_((String)dimension));
            stack.m_41751_(tag);
        }
    }

    @Nullable
    public static String getDimension(@Nonnull ItemStack stack) {
        CompoundTag tag = ItemUtils.getItemTag(stack);
        return tag != null ? tag.m_128461_(DIM_TAG) : null;
    }

    public static void setSkip(Boolean skip, @Nonnull ItemStack stack) {
        CompoundTag tag = ItemUtils.getOrCreateItemTag(stack);
        if (tag != null) {
            if (!skip.booleanValue()) {
                ItemUtils.removeTag(stack, SKIP_TAG);
                return;
            }
            tag.m_128365_(SKIP_TAG, (Tag)ByteTag.m_128273_((boolean)true));
            stack.m_41751_(tag);
        }
    }

    public static boolean isSkip(@Nonnull ItemStack stack) {
        CompoundTag tag = ItemUtils.getItemTag(stack);
        return tag != null && tag.m_128471_(SKIP_TAG);
    }

    public static void search(@Nonnull ServerLevel world, Player player, @Nonnull StructureFeature<?> structure, ItemStack stack) {
        ResourceLocation registry = structure.getRegistryName();
        assert (registry != null);
        StructuresCompassItem.setStructureName(registry.toString(), stack);
        StructuresCompassItem.sendTranslatedMessage("string.structurescompass.msg_searching", player);
        BlockPos pos = world.m_8717_(structure, player.m_142538_(), ((Integer)StructuresCompassConfig.radius.get()).intValue(), StructuresCompassItem.isSkip(stack));
        StructuresCompassItem.sendTranslatedMessage("string.structurescompass.msg_done", player);
        if (pos == null) {
            ItemUtils.removeTag(stack, DIM_TAG);
            ItemUtils.removeTag(stack, POS_TAG);
        } else {
            Vec3 dis = StructureUtils.getDistance(pos, (Entity)player);
            double distance = (double)Math.round(dis.m_82553_() * 100.0) / 100.0;
            if (distance > (Double)StructuresCompassConfig.maxDistance.get()) {
                ItemUtils.removeTag(stack, DIM_TAG);
                ItemUtils.removeTag(stack, POS_TAG);
            } else {
                StructuresCompassItem.setDimension(world.m_46472_().m_135782_().toString(), stack);
                StructuresCompassItem.setPos(pos, stack);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void sendMessage(String msg, @Nonnull Player entity) {
        entity.m_6352_((Component)new TextComponent(msg), entity.m_142081_());
    }

    private static void sendTranslatedMessage(String translationKey, @Nonnull Player entity) {
        entity.m_6352_((Component)new TranslatableComponent(translationKey), entity.m_142081_());
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level world, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21205_();
        if (world.f_46443_) {
            if (player.m_6047_()) {
                StructuresCompassNetwork.channel.sendToServer((Object)new RequestSyncPacket());
            } else {
                String name = StructuresCompassItem.getStructureName(stack);
                if (name == null) {
                    StructuresCompassItem.sendMessage(I18n.m_118938_((String)"string.structurescompass.msg_no_target", (Object[])new Object[0]), player);
                    return super.m_7203_(world, player, hand);
                }
                StructureFeature structure = (StructureFeature)StructureFeature.f_67012_.get((Object)name.replace("minecraft:", ""));
                if (structure == null) {
                    StructuresCompassItem.sendMessage(I18n.m_118938_((String)"string.structurescompass.msg_error_name", (Object[])new Object[0]) + name, player);
                    return super.m_7203_(world, player, hand);
                }
                StructuresCompassNetwork.channel.sendToServer((Object)new CompassSearchPacket(StructureUtils.getResourceForStructure(structure)));
            }
        }
        return super.m_7203_(world, player, hand);
    }
}

