/*
 * Decompiled with CFR 0.152.
 */
package com.github.samarium150.structurescompass.gui;

import com.github.samarium150.structurescompass.gui.StructureSearchEntry;
import com.github.samarium150.structurescompass.gui.StructureSearchList;
import com.github.samarium150.structurescompass.gui.TransparentButton;
import com.github.samarium150.structurescompass.gui.TransparentTextField;
import com.github.samarium150.structurescompass.item.StructuresCompassItem;
import com.github.samarium150.structurescompass.network.StructuresCompassNetwork;
import com.github.samarium150.structurescompass.network.packet.CompassSearchPacket;
import com.github.samarium150.structurescompass.network.packet.CompassSkipExistingChunksPacket;
import com.github.samarium150.structurescompass.util.StructureUtils;
import com.github.samarium150.structurescompass.util.sort.Category;
import com.github.samarium150.structurescompass.util.sort.NameCategory;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class StructuresCompassScreen
extends Screen {
    private final List<StructureFeature<?>> allowedStructures = StructureUtils.allowedStructures;
    private final ItemStack stack;
    private List<StructureFeature<?>> structuresMatchingSearch;
    private StructureSearchList selectionList;
    private Category category;
    private Button startSearchButton;
    private Button sortByButton;
    private Button skipExistingChunksButton;
    private EditBox searchTextField;
    private boolean skip;
    private StructureFeature<?> selected;

    public StructuresCompassScreen(@Nonnull ItemStack stack) {
        super((Component)new TranslatableComponent("string.structurescompass.select_structure"));
        this.stack = stack;
        this.structuresMatchingSearch = new ArrayList(this.allowedStructures);
        this.category = new NameCategory();
        this.skip = StructuresCompassItem.isSkip(stack);
    }

    private void setup() {
        this.f_169369_.clear();
        this.startSearchButton = (Button)this.m_142416_((GuiEventListener)new TransparentButton(10, 40, 110, 20, (Component)new TranslatableComponent("string.structurescompass.start_searching"), onPress -> {
            StructureSearchEntry entry = (StructureSearchEntry)this.selectionList.m_93511_();
            if (entry != null) {
                entry.search();
            }
        }));
        this.sortByButton = (Button)this.m_142416_((GuiEventListener)new TransparentButton(10, 65, 110, 20, (Component)new TextComponent(I18n.m_118938_((String)"string.structurescompass.sort_by", (Object[])new Object[0]) + ": " + this.category.getLocalizedName()), onPress -> {
            this.category = this.category.next();
            this.sortByButton.m_93666_((Component)new TextComponent(I18n.m_118938_((String)"string.structurescompass.sort_by", (Object[])new Object[0]) + ": " + this.category.getLocalizedName()));
            this.selectionList.refresh();
            this.restoreSelected();
        }));
        this.skipExistingChunksButton = (Button)this.m_142416_((GuiEventListener)new TransparentButton(10, 90, 110, 20, (Component)new TextComponent(I18n.m_118938_((String)"string.structurescompass.skip_existing_chunks", (Object[])new Object[0]) + ": " + this.skip), onPress -> {
            this.skip = !this.skip;
            this.skipExistingChunksButton.m_93666_((Component)new TextComponent(I18n.m_118938_((String)"string.structurescompass.skip_existing_chunks", (Object[])new Object[0]) + ": " + this.skip));
        }));
        this.m_142416_((GuiEventListener)new TransparentButton(10, this.f_96544_ - 30, 110, 20, (Component)new TranslatableComponent("gui.cancel"), onPress -> {
            assert (this.f_96541_ != null);
            this.f_96541_.m_91152_(null);
        }));
        this.searchTextField = (EditBox)this.m_7787_((GuiEventListener)new TransparentTextField(this.f_96547_, 130, 10, 140, 20, (Component)new TranslatableComponent("string.structurescompass.search")));
    }

    public void selectStructure(StructureSearchEntry entry) {
        boolean bl = this.startSearchButton.f_93623_ = entry != null;
        if (entry != null) {
            this.selected = entry.getStructure();
        }
    }

    public List<StructureFeature<?>> sortStructures() {
        List<StructureFeature<?>> structures = this.structuresMatchingSearch;
        structures.sort(new NameCategory());
        structures.sort(this.category);
        return this.structuresMatchingSearch;
    }

    public void search(@Nonnull StructureFeature<?> structure) {
        assert (this.f_96541_ != null);
        StructuresCompassNetwork.channel.sendToServer((Object)new CompassSkipExistingChunksPacket(this.skip));
        StructuresCompassNetwork.channel.sendToServer((Object)new CompassSearchPacket(structure.getRegistryName()));
        this.f_96541_.m_91152_(null);
    }

    public void processSearchTerm() {
        this.structuresMatchingSearch = new ArrayList();
        for (StructureFeature<?> structure : this.allowedStructures) {
            String temp = "";
            if (!this.searchTextField.m_94155_().isEmpty() && this.searchTextField.m_94155_().charAt(0) == '#') {
                temp = StructureUtils.getDimensions(structure);
            }
            if (!(!this.searchTextField.m_94155_().isEmpty() && this.searchTextField.m_94155_().charAt(0) == '@' && StructureUtils.getStructureSource(structure).toLowerCase().contains(this.searchTextField.m_94155_().substring(1).toLowerCase()) || !temp.isEmpty() && temp.toLowerCase().contains(this.searchTextField.m_94155_().substring(1).toLowerCase())) && !StructureUtils.getLocalizedStructureName(structure).toLowerCase().contains(this.searchTextField.m_94155_().toLowerCase())) continue;
            this.structuresMatchingSearch.add(structure);
        }
        this.selectionList.refresh();
        this.restoreSelected();
    }

    public void restoreSelected() {
        if (this.selected != null && this.structuresMatchingSearch.contains(this.selected)) {
            this.selectionList.selectStructure(this.selected);
        }
        this.selectionList.restoreScrollAmount();
    }

    protected void m_7856_() {
        String selected;
        assert (this.f_96541_ != null);
        this.f_96541_.f_91068_.m_90926_(true);
        this.setup();
        if (this.selectionList == null) {
            this.selectionList = new StructureSearchList(this, this.f_96541_, this.f_96543_ + 110, this.f_96544_, 40, this.f_96544_, 45);
        }
        if ((selected = StructuresCompassItem.getStructureName(this.stack)) != null) {
            this.selectionList.selectStructure(StructureUtils.getStructureForResource(new ResourceLocation(selected)));
            this.selectionList.m_5755_(true);
            this.selectionList.restoreScrollAmount();
        }
        this.m_7787_((GuiEventListener)this.selectionList);
    }

    public void m_96624_() {
        this.searchTextField.m_94120_();
    }

    public void m_6305_(@Nonnull PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        this.selectionList.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.searchTextField.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        StructuresCompassScreen.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)I18n.m_118938_((String)"string.structurescompass.select_structure", (Object[])new Object[0]), (int)65, (int)15, (int)0xFFFFFF);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        boolean ret = super.m_7933_(keyCode, scanCode, modifiers);
        if (this.searchTextField.m_93696_()) {
            this.processSearchTerm();
            return true;
        }
        return ret;
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        boolean ret = super.m_5534_(codePoint, modifiers);
        if (this.searchTextField.m_93696_()) {
            this.processSearchTerm();
            return true;
        }
        return ret;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        return this.selectionList.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7861_() {
        super.m_7861_();
        assert (this.f_96541_ != null);
        this.f_96541_.f_91068_.m_90926_(false);
    }
}

