/*
 * Decompiled with CFR 0.152.
 */
package io.github.samarium150.minecraft.mod.structures_compass.util;

import io.github.samarium150.minecraft.mod.structures_compass.init.ItemRegistry;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public abstract class ItemUtils {
    private ItemUtils() {
    }

    public static boolean isStackItemStructuresCompass(@Nonnull ItemStack stack) {
        return stack.m_41720_() == ItemRegistry.STRUCTURES_COMPASS.get();
    }

    @Nullable
    public static CompoundTag getOrCreateItemTag(@Nonnull ItemStack stack) {
        if (ItemUtils.isStackItemStructuresCompass(stack)) {
            CompoundTag tag = stack.m_41783_();
            return tag == null ? new CompoundTag() : tag;
        }
        return null;
    }

    @Nullable
    public static CompoundTag getItemTag(@Nonnull ItemStack stack) {
        return ItemUtils.isStackItemStructuresCompass(stack) ? stack.m_41783_() : null;
    }

    public static void removeTag(@Nonnull ItemStack stack, String TAG_NAME) {
        if (stack.m_41720_() == ItemRegistry.STRUCTURES_COMPASS.get()) {
            CompoundTag tag = stack.m_41783_();
            if (tag == null) {
                return;
            }
            tag.m_128473_(TAG_NAME);
            stack.m_41751_(tag);
        }
    }

    public static ItemStack getHeldItem(Player player, Item item) {
        if (player == null) {
            return ItemStack.f_41583_;
        }
        if (!player.m_21205_().m_41619_() && player.m_21205_().m_41720_() == item) {
            return player.m_21205_();
        }
        if (!player.m_21206_().m_41619_() && player.m_21206_().m_41720_() == item) {
            return player.m_21206_();
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getHeldStructuresCompass(Player player) {
        return ItemUtils.getHeldItem(player, (Item)ItemRegistry.STRUCTURES_COMPASS.get());
    }
}

