/*
 * Decompiled with CFR 0.152.
 */
package io.github.samarium150.minecraft.mod.structures_compass.network.packet;

import io.github.samarium150.minecraft.mod.structures_compass.item.StructuresCompassItem;
import io.github.samarium150.minecraft.mod.structures_compass.network.packet.Packet;
import io.github.samarium150.minecraft.mod.structures_compass.util.ItemUtils;
import io.github.samarium150.minecraft.mod.structures_compass.util.StructureUtils;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraftforge.network.NetworkEvent;

public final class CompassSearchPacket
implements Packet {
    private final ResourceLocation resource;

    public CompassSearchPacket(ResourceLocation resource) {
        this.resource = resource;
    }

    public CompassSearchPacket(@Nonnull FriendlyByteBuf buffer) {
        this.resource = buffer.m_130281_();
    }

    @Override
    public void toBytes(@Nonnull FriendlyByteBuf buffer) {
        buffer.m_130085_(this.resource);
    }

    @Override
    public void handle(@Nonnull Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            ItemStack stack = ItemUtils.getHeldStructuresCompass((Player)player);
            if (!stack.m_41619_() && player != null) {
                ServerLevel world = (ServerLevel)player.f_19853_;
                StructureFeature<?> structure = StructureUtils.getStructureForResource(this.resource);
                if (structure != null) {
                    new Thread(() -> StructuresCompassItem.search(world, (Player)player, structure, stack)).start();
                }
            }
        });
        context.setPacketHandled(true);
    }
}

