/*
 * Decompiled with CFR 0.152.
 */
package io.github.samarium150.minecraft.mod.structures_compass.item;

import io.github.samarium150.minecraft.mod.structures_compass.item.StructuresCompassItem;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class StructuresCompassItemProperty
implements ClampedItemPropertyFunction {
    private final Angle r1 = new Angle();
    private final Angle r2 = new Angle();

    private double getFrameRotation(@Nonnull ItemFrame frameEntity) {
        Direction direction = frameEntity.m_6350_();
        int i = direction.m_122434_().m_122478_() ? 90 * direction.m_122421_().m_122540_() : 0;
        return Mth.m_14098_((int)(180 + direction.m_122416_() * 90 + frameEntity.m_31823_() * 45 + i));
    }

    private static boolean closeEnough(@Nonnull Entity entity, @Nonnull BlockPos pos) {
        return entity.m_20182_().m_82531_((double)pos.m_123341_() + 0.5, entity.m_20182_().m_7098_(), (double)pos.m_123343_() + 0.5) < (double)1.0E-5f;
    }

    private static double getAngle(@Nonnull Vec3 vector, @Nonnull Entity entity) {
        return Math.atan2(vector.m_7094_() - entity.m_20189_(), vector.m_7096_() - entity.m_20185_());
    }

    public float m_142187_(@Nonnull ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity livingEntity, int p) {
        LivingEntity entity;
        Object object = entity = livingEntity != null ? livingEntity : stack.m_41609_();
        if (entity == null) {
            return 0.0f;
        }
        if (world == null && entity.f_19853_ instanceof ClientLevel) {
            world = (ClientLevel)entity.f_19853_;
        }
        if (world == null) {
            return 0.0f;
        }
        BlockPos pos = StructuresCompassItem.getPos(stack);
        if (pos != null && world.m_46472_().m_135782_().toString().equals(StructuresCompassItem.getDimension(stack)) && !StructuresCompassItemProperty.closeEnough((Entity)entity, pos)) {
            boolean flag = entity instanceof Player && ((Player)entity).m_7578_();
            double d1 = 0.0;
            if (flag) {
                d1 = entity.m_146908_();
            } else if (entity instanceof ItemFrame) {
                d1 = this.getFrameRotation((ItemFrame)entity);
            } else if (entity instanceof ItemEntity) {
                d1 = 180.0f - ((ItemEntity)entity).m_32008_(0.5f) / ((float)Math.PI * 2) * 360.0f;
            } else if (livingEntity != null) {
                d1 = livingEntity.f_20883_;
            }
            d1 = Mth.m_14109_((double)(d1 / 360.0), (double)1.0);
            double d2 = StructuresCompassItemProperty.getAngle(Vec3.m_82512_((Vec3i)pos), (Entity)entity) / 6.2831854820251465;
            double d3 = flag ? d2 + this.r1.wobble(world, 0.5 - (d1 - 0.25)) : 0.5 - (d1 - 0.25 - d2);
            return Mth.m_14091_((float)((float)d3), (float)1.0f);
        }
        return Mth.m_14091_((float)((float)(this.r2.wobble(world, Math.random()) + (double)((float)stack.hashCode() / 2.1474836E9f))), (float)1.0f);
    }

    private static class Angle {
        private double rotation = 0.0;
        private double delta = 0.0;
        private long lastUpdateTick;

        private Angle() {
        }

        private boolean isOutdated(long lastUpdateTick) {
            return this.lastUpdateTick != lastUpdateTick;
        }

        private double wobble(ClientLevel world, double amount) {
            if (world != null && this.isOutdated(world.m_46467_())) {
                this.lastUpdateTick = world.m_46467_();
                double d0 = amount - this.rotation;
                d0 = Mth.m_14109_((double)(d0 + 0.5), (double)1.0) - 0.5;
                this.delta += d0 * 0.1;
                this.delta *= 0.8;
                this.rotation = Mth.m_14109_((double)(this.rotation + this.delta), (double)1.0);
            }
            return this.rotation;
        }
    }
}

