/*
 * Decompiled with CFR 0.152.
 */
package io.github.samarium150.minecraft.mod.structures_compass.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.samarium150.minecraft.mod.structures_compass.gui.StructureSearchEntry;
import io.github.samarium150.minecraft.mod.structures_compass.gui.StructuresCompassScreen;
import io.github.samarium150.minecraft.mod.structures_compass.util.RenderUtils;
import io.github.samarium150.minecraft.mod.structures_compass.util.StructureUtils;
import java.util.HashMap;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class StructureSearchList
extends ObjectSelectionList<StructureSearchEntry> {
    private final StructuresCompassScreen screen;
    private final HashMap<String, StructureSearchEntry> map = new HashMap();

    public StructureSearchList(StructuresCompassScreen screen, Minecraft minecraft, int widthIn, int heightIn, int topIn, int bottomIn, int slotHeightIn) {
        super(minecraft, widthIn, heightIn, topIn, bottomIn, slotHeightIn);
        this.screen = screen;
        this.refresh();
    }

    public StructuresCompassScreen getScreen() {
        return this.screen;
    }

    public void selectStructure(StructureSearchEntry entry) {
        this.m_6987_((AbstractSelectionList.Entry)entry);
        this.screen.selectStructure(entry);
    }

    public void selectStructure(StructureFeature<?> structure) {
        this.selectStructure(this.map.get(StructureUtils.getStructureName(structure)));
    }

    public void refresh() {
        this.m_93516_();
        for (StructureFeature<?> structure : this.screen.sortStructures()) {
            StructureSearchEntry entry = new StructureSearchEntry(this, structure);
            this.m_7085_((AbstractSelectionList.Entry)entry);
            this.map.put(StructureUtils.getStructureName(structure), entry);
        }
        this.selectStructure((StructureSearchEntry)null);
        this.m_93410_(0.0);
        this.m_5755_(false);
    }

    public void restoreScrollAmount() {
        if (this.m_93511_() != null) {
            this.m_5755_(true);
            this.m_93410_(this.m_93517_() + (double)(this.f_93387_ * 2));
        }
    }

    protected int m_5756_() {
        return super.m_5756_() + 20;
    }

    public int m_5759_() {
        return super.m_5759_() + 50;
    }

    protected boolean m_7987_(int index) {
        return index >= 0 && index < this.m_6702_().size() && ((Object)((Object)((StructureSearchEntry)((Object)this.m_6702_().get(index))))).equals(this.m_93511_());
    }

    protected void m_93451_(@Nonnull PoseStack matrixStack, int x, int y, int mouseX, int mouseY, float partialTicks) {
        for (int i = 0; i < this.m_5773_(); ++i) {
            int top = this.m_7610_(i);
            int bottom = top + this.f_93387_;
            if (bottom + this.f_93389_ < this.f_93390_ || top > this.f_93391_) continue;
            StructureSearchEntry entry = (StructureSearchEntry)this.m_93500_(i);
            int h = this.f_93387_ - 4;
            int w = this.m_5759_();
            if (this.m_7987_(i)) {
                int insideLeft = this.f_93393_ + this.f_93388_ / 2 - this.m_5759_() / 2 + 2;
                RenderUtils.drawRect(insideLeft - 4, top - 4, insideLeft + this.m_5759_() + 4, top + this.f_93387_, 0x7F000000);
            }
            int left = this.m_5747_();
            entry.m_6311_(matrixStack, i, top, left, w, h, mouseX, mouseY, this.m_5953_(mouseX, mouseY) && Objects.equals(this.m_93412_(mouseX, mouseY), (Object)entry), partialTicks);
        }
    }

    public void m_6305_(@Nonnull PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_93451_(matrixStack, this.m_5747_(), this.f_93390_ + 4 - (int)this.m_93517_(), mouseX, mouseY, partialTicks);
    }
}

