/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.loadmyresources.pack;

import com.google.common.base.CharMatcher;
import com.google.common.collect.Sets;
import de.keksuccino.loadmyresources.pack.PackHandler;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.IoSupplier;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class LMRPackResources
extends PathPackResources {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final boolean ON_WINDOWS = Util.m_137581_() == Util.OS.WINDOWS;
    private static final CharMatcher BACKSLASH_MATCHER = CharMatcher.is((char)'\\');
    private final File file = PackHandler.resourcesDirectory;

    public LMRPackResources() {
        super("loadmyresources.hiddenpack", PackHandler.resourcesDirectory.toPath(), true);
    }

    public <T> T m_5550_(@NotNull MetadataSectionSerializer<T> serializer) throws IOException {
        Object o;
        try (InputStream in = Minecraft.m_91087_().m_91098_().m_215595_(PackHandler.DUMMY_PACK_META);){
            o = LMRPackResources.m_10214_(serializer, (InputStream)in);
        }
        return (T)o;
    }

    @NotNull
    public Set<String> m_5698_(@NotNull PackType type) {
        HashSet s = Sets.newHashSet();
        File[] files = this.file.listFiles((FileFilter)DirectoryFileFilter.DIRECTORY);
        if (files != null) {
            for (File f : files) {
                String path = LMRPackResources.getRelativePath(this.file, f);
                if (path.equals(path.toLowerCase(Locale.ROOT))) {
                    s.add(path.substring(0, path.length() - 1));
                    continue;
                }
                this.logWarning(path);
            }
        }
        return s;
    }

    private static String getPathFromLocation(PackType p_10227_, ResourceLocation p_10228_) {
        return String.format(Locale.ROOT, "%s/%s/%s", p_10227_.m_10305_(), p_10228_.m_135827_(), p_10228_.m_135815_());
    }

    @Nullable
    public IoSupplier<InputStream> m_214146_(@NotNull PackType packType, @NotNull ResourceLocation location) {
        try {
            File f = this.getFile(LMRPackResources.getPathFromLocation(location));
            if (f != null) {
                return IoSupplier.m_246697_((Path)f.toPath());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Nullable
    private File getFile(String p_10282_) {
        try {
            File file1 = new File(this.file, p_10282_);
            if (file1.isFile() && LMRPackResources.validatePath(file1, p_10282_)) {
                return file1;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static boolean validatePath(File p_10274_, String p_10275_) throws IOException {
        String s = p_10274_.getCanonicalPath();
        if (ON_WINDOWS) {
            s = BACKSLASH_MATCHER.replaceFrom((CharSequence)s, '/');
        }
        return s.endsWith(p_10275_);
    }

    private static String getPathFromLocation(ResourceLocation location) {
        return String.format("%s/%s", location.m_135827_(), location.m_135815_());
    }

    public void m_8031_(@NotNull PackType packType, @NotNull String namespace, @NotNull String resourcePreNamePath, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PackResources.ResourceOutput output) {
        this.listFiles(new File(new File(this.file, namespace), resourcePreNamePath), namespace, resourcePreNamePath + "/", output);
    }

    private void listFiles(File file, String string, String string2, PackResources.ResourceOutput output) {
        File[] files = file.listFiles();
        if (files != null) {
            for (File file2 : files) {
                if (file2.isDirectory()) {
                    this.listFiles(file2, string, string2 + file2.getName() + "/", output);
                    continue;
                }
                if (file2.getName().endsWith(".mcmeta")) continue;
                try {
                    String string3 = string2 + file2.getName();
                    ResourceLocation resourceLocation = ResourceLocation.m_214293_((String)string, (String)string3);
                    if (resourceLocation == null) {
                        LOGGER.warn("Invalid path in datapack: {}:{}, ignoring", (Object)string, (Object)string3);
                        continue;
                    }
                    output.accept((Object)resourceLocation, (Object)IoSupplier.m_246697_((Path)file2.toPath()));
                }
                catch (ResourceLocationException var13) {
                    LOGGER.error(var13.getMessage());
                }
            }
        }
    }

    protected static String getRelativePath(File p_10218_, File p_10219_) {
        return p_10218_.toURI().relativize(p_10219_.toURI()).getPath();
    }

    protected void logWarning(String p_10231_) {
        LOGGER.warn("ResourcePack: ignored non-lowercase namespace: {} in {}", (Object)p_10231_, (Object)this.file);
    }

    public boolean isHidden() {
        return true;
    }
}

