import { world, BlockLocation, BlockProperties } from 'mojang-minecraft'

function grow(){
    let players = world.getPlayers()
    for (let player of players){
        if (player.isSneaking){
            if (!player.hasTag("treesneak")){
                player.addTag("treesneak")
                let blockLocations = new BlockLocation(player.location.x + 2, player.location.y + 2, player.location.z + 2).blocksBetween(new BlockLocation(player.location.x - 2, player.location.y - 2, player.location.z - 2))
    
                for (const bl of blockLocations) {
                    let block = player.dimension.getBlock(bl)
                    if(block.id == "minecraft:sapling" && block.permutation.getProperty(BlockProperties.saplingType).value == 'oak'){
                        if (Math.random()*10<1){
                            player.runCommand(`setblock ${bl.x} ${bl.y} ${bl.z} air`)
                            player.runCommand(`fill ${bl.x} ${bl.y} ${bl.z} ${bl.x} ${bl.y+5} ${bl.z} log 0 replace air`)
                            player.runCommand(`fill ${bl.x-2} ${bl.y+3} ${bl.z-2} ${bl.x+2} ${bl.y+4} ${bl.z+2} leaves 0 replace air`)
                            player.runCommand(`fill ${bl.x-1} ${bl.y+5} ${bl.z-1} ${bl.x+1} ${bl.y+6} ${bl.z+1} leaves 0 replace air`)
                            player.runCommand(`fill ${bl.x-1} ${bl.y+6} ${bl.z-1} ${bl.x-1} ${bl.y+6} ${bl.z-1} air 0 replace leaves`)
                            player.runCommand(`fill ${bl.x-1} ${bl.y+6} ${bl.z+1} ${bl.x-1} ${bl.y+6} ${bl.z+1} air 0 replace leaves`)
                            player.runCommand(`fill ${bl.x+1} ${bl.y+6} ${bl.z-1} ${bl.x+1} ${bl.y+6} ${bl.z-1} air 0 replace leaves`)
                            player.runCommand(`fill ${bl.x+1} ${bl.y+6} ${bl.z+1} ${bl.x+1} ${bl.y+6} ${bl.z+1} air 0 replace leaves`)
                        }
                        player.runCommand(`particle minecraft:crop_growth_emitter ${bl.x} ${bl.y} ${bl.z}`)
                    }
                    else if(block.id == "minecraft:sapling" && block.permutation.getProperty(BlockProperties.saplingType).value == 'birch'){
                        if (Math.random()*10<1){
                            player.runCommand(`setblock ${bl.x} ${bl.y} ${bl.z} air`)
                            player.runCommand(`fill ${bl.x} ${bl.y} ${bl.z} ${bl.x} ${bl.y+5} ${bl.z} log 2 replace air`)
                            player.runCommand(`fill ${bl.x-2} ${bl.y+3} ${bl.z-2} ${bl.x+2} ${bl.y+4} ${bl.z+2} leaves 2 replace air`)
                            player.runCommand(`fill ${bl.x-1} ${bl.y+5} ${bl.z-1} ${bl.x+1} ${bl.y+6} ${bl.z+1} leaves 2 replace air`)
                            player.runCommand(`fill ${bl.x-1} ${bl.y+6} ${bl.z-1} ${bl.x-1} ${bl.y+6} ${bl.z-1} air 0 replace leaves`)
                            player.runCommand(`fill ${bl.x-1} ${bl.y+6} ${bl.z+1} ${bl.x-1} ${bl.y+6} ${bl.z+1} air 0 replace leaves`)
                            player.runCommand(`fill ${bl.x+1} ${bl.y+6} ${bl.z-1} ${bl.x+1} ${bl.y+6} ${bl.z-1} air 0 replace leaves`)
                            player.runCommand(`fill ${bl.x+1} ${bl.y+6} ${bl.z+1} ${bl.x+1} ${bl.y+6} ${bl.z+1} air 0 replace leaves`)
                        }
                        player.runCommand(`particle minecraft:crop_growth_emitter ${bl.x} ${bl.y} ${bl.z}`)
                    }
                    else if(block.id == "vatonage:cobblestone_sapling"){
                        if (Math.random()*10<1){
                            player.runCommand(`setblock ${bl.x} ${bl.y} ${bl.z} air`)
                            player.runCommand(`fill ${bl.x} ${bl.y} ${bl.z} ${bl.x} ${bl.y+5} ${bl.z} vatonage:cobblestone_wood 0 replace air`)
                            player.runCommand(`fill ${bl.x-2} ${bl.y+3} ${bl.z-2} ${bl.x+2} ${bl.y+4} ${bl.z+2} vatonage:cobblestone_leaves 0 replace air`)
                            player.runCommand(`fill ${bl.x-1} ${bl.y+5} ${bl.z-1} ${bl.x+1} ${bl.y+6} ${bl.z+1} vatonage:cobblestone_leaves 0 replace air`)
                            player.runCommand(`fill ${bl.x-1} ${bl.y+6} ${bl.z-1} ${bl.x-1} ${bl.y+6} ${bl.z-1} air 0 replace vatonage:cobblestone_leaves`)
                            player.runCommand(`fill ${bl.x-1} ${bl.y+6} ${bl.z+1} ${bl.x-1} ${bl.y+6} ${bl.z+1} air 0 replace vatonage:cobblestone_leaves`)
                            player.runCommand(`fill ${bl.x+1} ${bl.y+6} ${bl.z-1} ${bl.x+1} ${bl.y+6} ${bl.z-1} air 0 replace vatonage:cobblestone_leaves`)
                            player.runCommand(`fill ${bl.x+1} ${bl.y+6} ${bl.z+1} ${bl.x+1} ${bl.y+6} ${bl.z+1} air 0 replace vatonage:cobblestone_leaves`)
                        }
                        player.runCommand(`particle minecraft:crop_growth_emitter ${bl.x} ${bl.y} ${bl.z}`)
                    }
                    else if(block.id == "vatonage:coal_sapling"){
                        if (Math.random()*10<1){
                            player.runCommand(`setblock ${bl.x} ${bl.y} ${bl.z} air`)
                            player.runCommand(`fill ${bl.x} ${bl.y} ${bl.z} ${bl.x} ${bl.y+5} ${bl.z} vatonage:coal_wood 0 replace air`)
                            player.runCommand(`fill ${bl.x-2} ${bl.y+3} ${bl.z-2} ${bl.x+2} ${bl.y+4} ${bl.z+2} vatonage:coal_leaves 0 replace air`)
                            player.runCommand(`fill ${bl.x-1} ${bl.y+5} ${bl.z-1} ${bl.x+1} ${bl.y+6} ${bl.z+1} vatonage:coal_leaves 0 replace air`)
                            player.runCommand(`fill ${bl.x-1} ${bl.y+6} ${bl.z-1} ${bl.x-1} ${bl.y+6} ${bl.z-1} air 0 replace vatonage:coal_leaves`)
                            player.runCommand(`fill ${bl.x-1} ${bl.y+6} ${bl.z+1} ${bl.x-1} ${bl.y+6} ${bl.z+1} air 0 replace vatonage:coal_leaves`)
                            player.runCommand(`fill ${bl.x+1} ${bl.y+6} ${bl.z-1} ${bl.x+1} ${bl.y+6} ${bl.z-1} air 0 replace vatonage:coal_leaves`)
                            player.runCommand(`fill ${bl.x+1} ${bl.y+6} ${bl.z+1} ${bl.x+1} ${bl.y+6} ${bl.z+1} air 0 replace vatonage:coal_leaves`)
                        }
                        player.runCommand(`particle minecraft:crop_growth_emitter ${bl.x} ${bl.y} ${bl.z}`)
                    }
                    else if(block.id == "vatonage:iron_sapling"){
                        if (Math.random()*10<1){
                            player.runCommand(`setblock ${bl.x} ${bl.y} ${bl.z} air`)
                            player.runCommand(`fill ${bl.x} ${bl.y} ${bl.z} ${bl.x} ${bl.y+5} ${bl.z} vatonage:iron_wood 0 replace air`)
                            player.runCommand(`fill ${bl.x-2} ${bl.y+3} ${bl.z-2} ${bl.x+2} ${bl.y+4} ${bl.z+2} vatonage:iron_leaves 0 replace air`)
                            player.runCommand(`fill ${bl.x-1} ${bl.y+5} ${bl.z-1} ${bl.x+1} ${bl.y+6} ${bl.z+1} vatonage:iron_leaves 0 replace air`)
                            player.runCommand(`fill ${bl.x-1} ${bl.y+6} ${bl.z-1} ${bl.x-1} ${bl.y+6} ${bl.z-1} air 0 replace vatonage:iron_leaves`)
                            player.runCommand(`fill ${bl.x-1} ${bl.y+6} ${bl.z+1} ${bl.x-1} ${bl.y+6} ${bl.z+1} air 0 replace vatonage:iron_leaves`)
                            player.runCommand(`fill ${bl.x+1} ${bl.y+6} ${bl.z-1} ${bl.x+1} ${bl.y+6} ${bl.z-1} air 0 replace vatonage:iron_leaves`)
                            player.runCommand(`fill ${bl.x+1} ${bl.y+6} ${bl.z+1} ${bl.x+1} ${bl.y+6} ${bl.z+1} air 0 replace vatonage:iron_leaves`)
                        }
                        player.runCommand(`particle minecraft:crop_growth_emitter ${bl.x} ${bl.y} ${bl.z}`)
                    }
                    else if(block.id == "vatonage:gold_sapling"){
                        if (Math.random()*10<1){
                            player.runCommand(`setblock ${bl.x} ${bl.y} ${bl.z} air`)
                            player.runCommand(`fill ${bl.x} ${bl.y} ${bl.z} ${bl.x} ${bl.y+5} ${bl.z} vatonage:gold_wood 0 replace air`)
                            player.runCommand(`fill ${bl.x-2} ${bl.y+3} ${bl.z-2} ${bl.x+2} ${bl.y+4} ${bl.z+2} vatonage:gold_leaves 0 replace air`)
                            player.runCommand(`fill ${bl.x-1} ${bl.y+5} ${bl.z-1} ${bl.x+1} ${bl.y+6} ${bl.z+1} vatonage:gold_leaves 0 replace air`)
                            player.runCommand(`fill ${bl.x-1} ${bl.y+6} ${bl.z-1} ${bl.x-1} ${bl.y+6} ${bl.z-1} air 0 replace vatonage:gold_leaves`)
                            player.runCommand(`fill ${bl.x-1} ${bl.y+6} ${bl.z+1} ${bl.x-1} ${bl.y+6} ${bl.z+1} air 0 replace vatonage:gold_leaves`)
                            player.runCommand(`fill ${bl.x+1} ${bl.y+6} ${bl.z-1} ${bl.x+1} ${bl.y+6} ${bl.z-1} air 0 replace vatonage:gold_leaves`)
                            player.runCommand(`fill ${bl.x+1} ${bl.y+6} ${bl.z+1} ${bl.x+1} ${bl.y+6} ${bl.z+1} air 0 replace vatonage:gold_leaves`)
                        }
                        player.runCommand(`particle minecraft:crop_growth_emitter ${bl.x} ${bl.y} ${bl.z}`)
                    }
                    else if(block.id == "vatonage:redstone_sapling"){
                        if (Math.random()*10<1){
                            player.runCommand(`setblock ${bl.x} ${bl.y} ${bl.z} air`)
                            player.runCommand(`fill ${bl.x} ${bl.y} ${bl.z} ${bl.x} ${bl.y+5} ${bl.z} vatonage:redstone_wood 0 replace air`)
                            player.runCommand(`fill ${bl.x-2} ${bl.y+3} ${bl.z-2} ${bl.x+2} ${bl.y+4} ${bl.z+2} vatonage:redstone_leaves 0 replace air`)
                            player.runCommand(`fill ${bl.x-1} ${bl.y+5} ${bl.z-1} ${bl.x+1} ${bl.y+6} ${bl.z+1} vatonage:redstone_leaves 0 replace air`)
                            player.runCommand(`fill ${bl.x-1} ${bl.y+6} ${bl.z-1} ${bl.x-1} ${bl.y+6} ${bl.z-1} air 0 replace vatonage:redstone_leaves`)
                            player.runCommand(`fill ${bl.x-1} ${bl.y+6} ${bl.z+1} ${bl.x-1} ${bl.y+6} ${bl.z+1} air 0 replace vatonage:redstone_leaves`)
                            player.runCommand(`fill ${bl.x+1} ${bl.y+6} ${bl.z-1} ${bl.x+1} ${bl.y+6} ${bl.z-1} air 0 replace vatonage:redstone_leaves`)
                            player.runCommand(`fill ${bl.x+1} ${bl.y+6} ${bl.z+1} ${bl.x+1} ${bl.y+6} ${bl.z+1} air 0 replace vatonage:redstone_leaves`)
                        }
                        player.runCommand(`particle minecraft:crop_growth_emitter ${bl.x} ${bl.y} ${bl.z}`)
                    }
                    else if(block.id == "vatonage:lapis_sapling"){
                        if (Math.random()*10<1){
                            player.runCommand(`setblock ${bl.x} ${bl.y} ${bl.z} air`)
                            player.runCommand(`fill ${bl.x} ${bl.y} ${bl.z} ${bl.x} ${bl.y+5} ${bl.z} vatonage:lapis_wood 0 replace air`)
                            player.runCommand(`fill ${bl.x-2} ${bl.y+3} ${bl.z-2} ${bl.x+2} ${bl.y+4} ${bl.z+2} vatonage:lapis_leaves 0 replace air`)
                            player.runCommand(`fill ${bl.x-1} ${bl.y+5} ${bl.z-1} ${bl.x+1} ${bl.y+6} ${bl.z+1} vatonage:lapis_leaves 0 replace air`)
                            player.runCommand(`fill ${bl.x-1} ${bl.y+6} ${bl.z-1} ${bl.x-1} ${bl.y+6} ${bl.z-1} air 0 replace vatonage:lapis_leaves`)
                            player.runCommand(`fill ${bl.x-1} ${bl.y+6} ${bl.z+1} ${bl.x-1} ${bl.y+6} ${bl.z+1} air 0 replace vatonage:lapis_leaves`)
                            player.runCommand(`fill ${bl.x+1} ${bl.y+6} ${bl.z-1} ${bl.x+1} ${bl.y+6} ${bl.z-1} air 0 replace vatonage:lapis_leaves`)
                            player.runCommand(`fill ${bl.x+1} ${bl.y+6} ${bl.z+1} ${bl.x+1} ${bl.y+6} ${bl.z+1} air 0 replace vatonage:lapis_leaves`)
                        }
                        player.runCommand(`particle minecraft:crop_growth_emitter ${bl.x} ${bl.y} ${bl.z}`)
                    }
                    else if(block.id == "vatonage:diamond_sapling"){
                        if (Math.random()*10<1){
                            player.runCommand(`setblock ${bl.x} ${bl.y} ${bl.z} air`)
                            player.runCommand(`fill ${bl.x} ${bl.y} ${bl.z} ${bl.x} ${bl.y+5} ${bl.z} vatonage:diamond_wood 0 replace air`)
                            player.runCommand(`fill ${bl.x-2} ${bl.y+3} ${bl.z-2} ${bl.x+2} ${bl.y+4} ${bl.z+2} vatonage:diamond_leaves 0 replace air`)
                            player.runCommand(`fill ${bl.x-1} ${bl.y+5} ${bl.z-1} ${bl.x+1} ${bl.y+6} ${bl.z+1} vatonage:diamond_leaves 0 replace air`)
                            player.runCommand(`fill ${bl.x-1} ${bl.y+6} ${bl.z-1} ${bl.x-1} ${bl.y+6} ${bl.z-1} air 0 replace vatonage:diamond_leaves`)
                            player.runCommand(`fill ${bl.x-1} ${bl.y+6} ${bl.z+1} ${bl.x-1} ${bl.y+6} ${bl.z+1} air 0 replace vatonage:diamond_leaves`)
                            player.runCommand(`fill ${bl.x+1} ${bl.y+6} ${bl.z-1} ${bl.x+1} ${bl.y+6} ${bl.z-1} air 0 replace vatonage:diamond_leaves`)
                            player.runCommand(`fill ${bl.x+1} ${bl.y+6} ${bl.z+1} ${bl.x+1} ${bl.y+6} ${bl.z+1} air 0 replace vatonage:diamond_leaves`)
                        }
                        player.runCommand(`particle minecraft:crop_growth_emitter ${bl.x} ${bl.y} ${bl.z}`)
                    }
                    else if(block.id == "vatonage:emerald_sapling"){
                        if (Math.random()*10<1){
                            player.runCommand(`setblock ${bl.x} ${bl.y} ${bl.z} air`)
                            player.runCommand(`fill ${bl.x} ${bl.y} ${bl.z} ${bl.x} ${bl.y+5} ${bl.z} vatonage:emerald_wood 0 replace air`)
                            player.runCommand(`fill ${bl.x-2} ${bl.y+3} ${bl.z-2} ${bl.x+2} ${bl.y+4} ${bl.z+2} vatonage:emerald_leaves 0 replace air`)
                            player.runCommand(`fill ${bl.x-1} ${bl.y+5} ${bl.z-1} ${bl.x+1} ${bl.y+6} ${bl.z+1} vatonage:emerald_leaves 0 replace air`)
                            player.runCommand(`fill ${bl.x-1} ${bl.y+6} ${bl.z-1} ${bl.x-1} ${bl.y+6} ${bl.z-1} air 0 replace vatonage:emerald_leaves`)
                            player.runCommand(`fill ${bl.x-1} ${bl.y+6} ${bl.z+1} ${bl.x-1} ${bl.y+6} ${bl.z+1} air 0 replace vatonage:emerald_leaves`)
                            player.runCommand(`fill ${bl.x+1} ${bl.y+6} ${bl.z-1} ${bl.x+1} ${bl.y+6} ${bl.z-1} air 0 replace vatonage:emerald_leaves`)
                            player.runCommand(`fill ${bl.x+1} ${bl.y+6} ${bl.z+1} ${bl.x+1} ${bl.y+6} ${bl.z+1} air 0 replace vatonage:emerald_leaves`)
                        }
                        player.runCommand(`particle minecraft:crop_growth_emitter ${bl.x} ${bl.y} ${bl.z}`)
                    }
                    else if(block.id == "vatonage:quartz_sapling"){
                        if (Math.random()*10<1){
                            player.runCommand(`setblock ${bl.x} ${bl.y} ${bl.z} air`)
                            player.runCommand(`fill ${bl.x} ${bl.y} ${bl.z} ${bl.x} ${bl.y+5} ${bl.z} vatonage:quartz_wood 0 replace air`)
                            player.runCommand(`fill ${bl.x-2} ${bl.y+3} ${bl.z-2} ${bl.x+2} ${bl.y+4} ${bl.z+2} vatonage:quartz_leaves 0 replace air`)
                            player.runCommand(`fill ${bl.x-1} ${bl.y+5} ${bl.z-1} ${bl.x+1} ${bl.y+6} ${bl.z+1} vatonage:quartz_leaves 0 replace air`)
                            player.runCommand(`fill ${bl.x-1} ${bl.y+6} ${bl.z-1} ${bl.x-1} ${bl.y+6} ${bl.z-1} air 0 replace vatonage:quartz_leaves`)
                            player.runCommand(`fill ${bl.x-1} ${bl.y+6} ${bl.z+1} ${bl.x-1} ${bl.y+6} ${bl.z+1} air 0 replace vatonage:quartz_leaves`)
                            player.runCommand(`fill ${bl.x+1} ${bl.y+6} ${bl.z-1} ${bl.x+1} ${bl.y+6} ${bl.z-1} air 0 replace vatonage:quartz_leaves`)
                            player.runCommand(`fill ${bl.x+1} ${bl.y+6} ${bl.z+1} ${bl.x+1} ${bl.y+6} ${bl.z+1} air 0 replace vatonage:quartz_leaves`)
                        }
                        player.runCommand(`particle minecraft:crop_growth_emitter ${bl.x} ${bl.y} ${bl.z}`)
                    }
                }
            }
        }
        else{
            player.removeTag("treesneak")
        }
    }
}

let i = 0
world.events.tick.subscribe(() => {
    i++
    if (i>5){
        i = 0
        grow()
    }
})