import { world, Items, ItemStack } from 'mojang-minecraft'
import { ActionFormData, ModalFormData } from 'mojang-minecraft-ui'

let items = [[`minecraft:ancient_debris`,"blocks/ancient_debris",64,0],[`minecraft:apple`,"items/apple",2,0],[`minecraft:arrow`,"items/arrow",2,0],[`minecraft:baked_potato`,"items/baked_potato",1,0],[`minecraft:basalt`,"blocks/basalt",1,0],[`minecraft:bedrock`,"blocks/bedrock",10000,0],[`minecraft:beef`,"items/beef",2,0],[`minecraft:beetroot`,"items/beetroot",1,0],[`minecraft:blackstone`,"blocks/blackstone",1,0],[`minecraft:blaze_powder`,"items/blaze_powder",4,0],[`minecraft:blaze_rod`,"items/blaze_rod",8,0],[`minecraft:bone`,"items/bone",3,0],[`minecraft:bone_meal`,"items/bone_meal",1,0],[`minecraft:book`,"items/book",7,0],[`minecraft:bread`,"items/bread",3,0],[`minecraft:cactus`,"blocks/cactus_top",1,0],[`minecraft:carrot`,"items/carrot",1,0],[`minecraft:clay_ball`,"items/clay_ball",1,0],[`minecraft:coal`,"items/coal",4,0],[`minecraft:cod`,"items/cod",1,0],[`minecraft:diamond`,"items/diamond",64,0],[`minecraft:dirt`,"blocks/dirt",1,0],[`minecraft:cobblestone`,"blocks/cobblestone",1,0],[`minecraft:dragon_egg`,"blocks/dragon_egg",69420,0],[`minecraft:egg`,"items/egg",3,0],[`minecraft:emerald`,"items/emerald",64,0],[`minecraft:enchanted_golden_apple`,"items/enchanted_golden_apple",2305,0],[`minecraft:emerald_block`,"blocks/emerald_block",576,0],[`minecraft:diamond_block`,"blocks/diamond_block",576,0],[`minecraft:coal_block`,"blocks/coal_block",36,0],[`minecraft:end_stone`,"blocks/end_stone",5,0],[`minecraft:ender_pearl`,"items/ender_pearl",16,0],[`minecraft:ender_eye`,"items/ender_eye",20,0],[`minecraft:experience_bottle`,"items/experience_bottle",4,0],[`minecraft:feather`,"items/feather",1,0],[`minecraft:flint`,"items/flint",1,0],[`minecraft:ghast_tear`,"items/ghast_tear",8,0],[`minecraft:glass`,"items/glass",1,0],[`minecraft:gold_ingot`,"items/gold_ingot",32,0],[`minecraft:gold_block`,"blocks/gold_block",288,0],
[`minecraft:glowstone`,"blocks/glowstone",4,0],[`minecraft:glowstone_dust`,"items/glowstone_dust",1,0],[`minecraft:golden_apple`,"items/golden_apple",258,0],[`minecraft:grass`,"blocks/grass",1,0],[`minecraft:gravel`,"items/gravel",1,0],[`minecraft:gunpowder`,"items/gunpowder",4,0],[`minecraft:heart_of_the_sea`,"items/heart_of_the_sea",256,0],[`minecraft:honeycomb`,"items/honeycomb",7,0],[`minecraft:iron_ingot`,"items/iron_ingot",16,0],[`minecraft:iron_block`,"blocks/iron_block",144,0],[`minecraft:kelp`,"items/kelp",1,0],[`minecraft:lapis_lazuli`,"items/lapis_lazuli",8,0],[`minecraft:lapis_block`,"blocks/lapis_block",72,0],[`minecraft:leather`,"items/leather",2,0],[`minecraft:magma_cream`,"items/magma_cream",5,0],[`minecraft:melon_slice`,"items/melon_slice",1,0],[`minecraft:mutton`,"items/mutton",1,0],[`minecraft:nautilus_shell`,"items/nautilus_shell",16,0],[`minecraft:nether_star`,"items/nether_star",1000,0],[`minecraft:nether_wart`,"items/nether_wart",16,0],[`minecraft:netherite_ingot`,"items/netherite_ingot",384,0],[`minecraft:netherite_block`,"blocks/netherite_block",3456,0],[`minecraft:netherite_scrap`,"items/netherite_scrap",64,0],[`minecraft:netherrack`,"blocks/netherrack",1,0],[`minecraft:obsidian`,"blocks/obsidian",16,0],[`minecraft:paper`,"items/paper",1,0],[`minecraft:planks`,"blocks/planks_oak",1,0],[`minecraft:poisonous_potato`,"items/poisonous_potato",500,0],[`minecraft:potato`,"items/potato",1,0],[`minecraft:porkchop`,"items/porkchop",1,0],[`minecraft:prismarine`,"blocks/prismarine",6,0],[`minecraft:prismarine_crystals`,"items/prismarine_crystals",3,0],[`minecraft:prismarine_shard`,"items/prismarine_shard",2,0],[`minecraft:pufferfish`,"items/pufferfish",7,0],[`minecraft:pumpkin`,"blocks/pumpkin",6,0],[`minecraft:quartz`,"items/quartz",3,0],[`minecraft:rabbit`,"items/rabbit",2,0],[`minecraft:rabbit_foot`,"items/rabbit_foot",7,0],[`minecraft:redstone`,"items/redstone",4,0],
[`minecraft:redstone_block`,"blocks/redstone_block",36,0],[`minecraft:rotten_flesh`,"items/rotten_flesh",1,0],[`minecraft:saddle`,"items/saddle",128,0],[`minecraft:salmon`,"items/salmon",1,0],[`minecraft:sand`,"blockss/sand",1,0],[`minecraft:sapling`,"items/sapling",1,0],[`minecraft:scute`,"items/scute",16,0],[`minecraft:shulker_shell`,"items/shulker_shell",16,0],[`minecraft:slime_ball`,"items/slime_ball",1,0],[`minecraft:soul_sand`,"blocks/soul_sand",3,0],[`minecraft:soul_soil`,"blocks/soul_soil",2,0],[`minecraft:spider_eye`,"items/spider_eye",8,0],[`minecraft:sponge`,"items/sponge",8,0],[`minecraft:sugar`,"items/sugar",1,0],[`minecraft:sugar_cane`,"items/sugar_cane",1,0],[`minecraft:sweet_berries`,"items/sweet_berries",2,0],[`minecraft:totem`,"items/totem",256,0],[`minecraft:tropical_fish`,"items/tropical_fish",6,0],[`minecraft:wheat`,"items/wheat",1,0],[`minecraft:wheat_seeds`,"items/wheat_seeds",1,0],[`minecraft:wool`,"blocks/wool_white",4,0],[`minecraft:string`,"items/string",1,0],[`minecraft:log`,"blocks/log_oak_top",4,0],[`minecraft:copper_ingot`,"items/copper_ingot",8,0],[`minecraft:copper_block`,"blocks/copper_block",72,0]]

function giveItem(player,amount,sel){
    player.runCommand(`scoreboard players remove @s vmc ${sel[2]*amount}`)
    for (let i = 0; i < amount; i++) {
        let item = new ItemStack(Items.get(sel[0]), 1, sel[3])
        
        let inventory = player.getComponent('inventory').container
        if (inventory.emptySlotsCount > 0) {
            inventory.addItem(item)
        }
        else {
            player.dimension.spawnItem(item, player.location)
        }
    }
}

function showVMC(player){
    const form = new ActionFormData()
        .title("Transmutation Table")
        .body(`§l§2${world.scoreboard.getObjective("vmc").getScore(player.scoreboard)} VMC`)
        .button("§4Convert Held Item Into VMC",`textures/items/bucket_lava`)
    
    let temp = []
    for (const i of items){
        if (player.hasTag(i[0]+"VMC") && world.scoreboard.getObjective("vmc").getScore(player.scoreboard) >= i[2]){
            temp.push(i)
            form.button(i[0].split(":")[1].replace("_"," ")+" "+i[2]+" VMC",`textures/${i[1]}`)
        }
    }
    form.show(player).then(response => {
        player.removeTag("inemcmenu")
        if (!response.isCanceled) {
            if (response.selection == 0){
                addVMC(player)
            }
            else{
                let sel = temp[response.selection-1]
                if(world.scoreboard.getObjective("vmc").getScore(player.scoreboard) >= sel[2]){
                    new ModalFormData()
                    .title("Transmutation Table")
                    .slider(`§2§l${sel[0].split(":")[1].replace("_"," ")}\n§rHow many items do you want to create?`, 1, world.scoreboard.getObjective("vmc").getScore(player.scoreboard)/sel[2], 1, Math.min(Math.round(world.scoreboard.getObjective("vmc").getScore(player.scoreboard)/sel[2] / 2), 64))
                    .textField('Or use this Textbox', '')
                    .show(player).then(response2 => {
                        if (!response2.isCanceled) {
                            let text = parseInt(response2.formValues[1])
                            let slide = response2.formValues[0]
                            if (text && text>0 && world.scoreboard.getObjective("vmc").getScore(player.scoreboard) >= sel[2]*text){
                                giveItem(player,text,sel)
                            }
                            else if (world.scoreboard.getObjective("vmc").getScore(player.scoreboard) >= sel[2]*slide){
                                giveItem(player,slide,sel)
                            }
                        }
                        showVMC(player)
                    })
                }
            }
        }
    })
}

function addVMC(player){
    let item = player.getComponent("inventory").container.getItem(player.selectedSlot)
    if (item){
        for (const i of items){
            if (item.id == i[0]){
                player.runCommand(`scoreboard players add @s vmc ${i[2]*item.amount}`)
                player.runCommand(`replaceitem entity @s slot.weapon.mainhand 0 air`)
                player.addTag(i[0]+"VMC")
            }
        }
    }
}

world.events.itemUseOn.subscribe(v => {
    let player = v.source
    if (!player.hasTag("inemcmenu") && player.dimension.getBlock(v.blockLocation).id == "vatonage:transmutation_table"){
        player.addTag("inemcmenu")
        showVMC(player)
    }
})