import { world, MinecraftEffectTypes } from 'mojang-minecraft'
import { ActionFormData } from 'mojang-minecraft-ui'

world.events.entityCreate.subscribe(v => {
    if (v.entity.hasComponent(`minecraft:movement`) && v.entity.nameTag == "" && !v.entity.hasTag("Scaled")){
        let distance = Math.abs(v.entity.location.x)+Math.abs(v.entity.location.z)
        if (distance > 200){
            if (Math.floor(distance/300)>255){
                v.entity.addEffect(MinecraftEffectTypes.healthBoost,100000,255,false)
            }
            else{
                v.entity.addEffect(MinecraftEffectTypes.healthBoost,100000,Math.floor(distance/300),false)
            }
            v.entity.getComponent('health').setCurrent(v.entity.getComponent('health').value+1000)
        }
        if (distance > 400){
            v.entity.addEffect(MinecraftEffectTypes.strength,100000,Math.floor(Math.sqrt(distance)/30),false)
        }
        v.entity.addTag("Scaled")

        if (distance > 200 && Math.ceil(Math.random()*100) < 8){
            v.entity.addEffect(MinecraftEffectTypes.speed,100000,1)
        }
        if (distance > 1000 && Math.ceil(Math.random()*100) < 8){
            v.entity.addEffect(MinecraftEffectTypes.speed,100000,2)
        }
        if (distance > 2000 && Math.ceil(Math.random()*100) < 6){
            v.entity.addEffect(MinecraftEffectTypes.speed,100000,3)
        }
        if (distance > 5000 && Math.ceil(Math.random()*100) < 10){
            v.entity.addEffect(MinecraftEffectTypes.speed,100000,4)
        }
        if (distance > 300 && Math.ceil(Math.random()*100) < 5){
            v.entity.addEffect(MinecraftEffectTypes.regeneration,100000,1)
        }
        if (distance > 1500 && Math.ceil(Math.random()*100) < 5){
            v.entity.addEffect(MinecraftEffectTypes.regeneration,100000,2)
        }
        if (distance > 2500 && Math.ceil(Math.random()*100) < 5){
            v.entity.addEffect(MinecraftEffectTypes.regeneration,100000,3)
        }
        if (distance > 3500 && Math.ceil(Math.random()*100) < 5){
            v.entity.addEffect(MinecraftEffectTypes.regeneration,100000,4)
        }
        if (distance > 5000 && Math.ceil(Math.random()*100) < 5){
            v.entity.addEffect(MinecraftEffectTypes.regeneration,100000,5)
        }
        if (distance > 10000 && Math.ceil(Math.random()*100) < 5){
            v.entity.addEffect(MinecraftEffectTypes.regeneration,100000,6)
        }
        if (distance > 1000 && Math.ceil(Math.random()*100) < 2){
            v.entity.addEffect(MinecraftEffectTypes.invisibility,100000,1)
        }
        if (distance > 2000 && Math.ceil(Math.random()*100) < 4){
            v.entity.addEffect(MinecraftEffectTypes.invisibility,100000,1)
        }
        if (distance > 5000 && Math.ceil(Math.random()*100) < 5){
            v.entity.addEffect(MinecraftEffectTypes.invisibility,100000,1,false)
        }
        if (distance > 1000 && Math.ceil(Math.random()*100) < 3){
            v.entity.addEffect(MinecraftEffectTypes.resistance,100000,1)
        }
        if (distance > 2000 && Math.ceil(Math.random()*100) < 2){
            v.entity.addEffect(MinecraftEffectTypes.resistance,100000,2)
        }
        if (distance > 4000 && Math.ceil(Math.random()*100) < 2){
            v.entity.addEffect(MinecraftEffectTypes.resistance,100000,3)
        }
        if (distance > 6000 && Math.ceil(Math.random()*100) < 2){
            v.entity.addEffect(MinecraftEffectTypes.resistance,100000,4)
        }
        if (distance > 1000 && Math.ceil(Math.random()*100) < 2){
            v.entity.addEffect(MinecraftEffectTypes.fireResistance,100000,1)
        }
        if (distance > 3000 && Math.ceil(Math.random()*100) < 4){
            v.entity.addEffect(MinecraftEffectTypes.fireResistance,100000,1)
        }
        if (distance > 6000 && Math.ceil(Math.random()*100) < 6){
            v.entity.addEffect(MinecraftEffectTypes.fireResistance,100000,1)
        }
        if (distance > 1000 && Math.ceil(Math.random()*100) < 2){
            v.entity.addEffect(MinecraftEffectTypes.fireResistance,100000,1)
            v.entity.addTag("ScalingFire")
        }
        if (distance > 3000 && Math.ceil(Math.random()*100) < 2){
            v.entity.addEffect(MinecraftEffectTypes.fireResistance,100000,1)
            v.entity.addTag("ScalingFire")
        }
        if (distance > 2000 && Math.ceil(Math.random()*100) < 1){
            v.entity.addEffect(MinecraftEffectTypes.fireResistance,100000,1)
            v.entity.addTag("ScalingLava")
        }
        if (distance > 4000 && Math.ceil(Math.random()*100) < 2){
            v.entity.addEffect(MinecraftEffectTypes.fireResistance,100000,1)
            v.entity.addTag("ScalingLava")
        }
        if (distance > 1000 && Math.ceil(Math.random()*100) < 2){
            v.entity.addEffect(MinecraftEffectTypes.waterBreathing,100000,1)
            v.entity.addTag("ScalingWater")
        }
        if (distance > 2000 && Math.ceil(Math.random()*100) < 2){
            v.entity.addEffect(MinecraftEffectTypes.waterBreathing,100000,1)
            v.entity.addTag("ScalingWater")
        }
        if (distance > 3000 && Math.ceil(Math.random()*100) < 3){
            v.entity.addEffect(MinecraftEffectTypes.waterBreathing,100000,1)
            v.entity.addTag("ScalingWater")
        }
        if (distance > 2000 && Math.ceil(Math.random()*100) < 3){
            v.entity.addEffect(MinecraftEffectTypes.slowFalling,100000,1)
        }
        if (distance > 4000 && Math.ceil(Math.random()*100) < 4){
            v.entity.addEffect(MinecraftEffectTypes.slowFalling,100000,1)
        }
        if (distance > 2000 && Math.ceil(Math.random()*100) < 2){
            v.entity.addEffect(MinecraftEffectTypes.jumpBoost,100000,1)
        }
        if (distance > 4000 && Math.ceil(Math.random()*100) < 3){
            v.entity.addEffect(MinecraftEffectTypes.jumpBoost,100000,2)
        }
        if (distance > 6000 && Math.ceil(Math.random()*100) < 4){
            v.entity.addEffect(MinecraftEffectTypes.jumpBoost,100000,3)
        }
    }
    else if (v.entity.hasComponent(`minecraft:movement`)){
        v.entity.getComponent('health').setCurrent(v.entity.getComponent('health').value+1000)
    }
})