import { world } from 'mojang-minecraft'

export class Timeout {
    #ticks
    #callback
    #paramsToPass
    #tick

    constructor(ticks, callback, ...paramsToPass) {
        this.#ticks = ticks
        this.#callback = callback
        this.#paramsToPass = paramsToPass

        this.#tick = this.#_tick.bind(this)

        world.events.tick.subscribe(this.#tick)
    }

    #_tick() {
        this.#ticks--
        if (this.#ticks <= 0) {
            world.events.tick.unsubscribe(this.#tick)
            this.#callback.apply(null, this.#paramsToPass)
            return
        }
    }
}