import { world } from 'mojang-minecraft'
import { ActionFormData } from 'mojang-minecraft-ui'

function deroman(num){
    if (num == "I"){
        return 1
    }
    else if (num == "II"){
        return 2
    }
    else if (num == "III"){
        return 3
    }
    else if (num == "IV"){
        return 4
    }
    else if (num == "V"){
        return 5
    }
    else if (num == "VI"){
        return 6
    }
    else if (num == "VII"){
        return 7
    }
    else if (num == "VIII"){
        return 8
    }
    else if (num == "IX"){
        return 9
    }
    else if (num == "X"){
        return 10
    }
    else{
        return 1
    }
}

world.events.entityHit.subscribe(v=> {
    if (v.hitEntity && v.entity && v.entity.getComponent("inventory")){
        let player = v.entity
        let item = player.getComponent("inventory").container.getItem(player.selectedSlot)
        if (item){
            let lore = item.getLore()
            if (lore[0].includes("Enchant DMG")){
                let health = v.hitEntity.getComponent('health')
                health.setCurrent(health.current - (lore[0].substring(lore[0].indexOf("+")+1,lore[0].indexOf("Enchant DMG")-1)))
            }
            if (lore[0].includes("Lightning")){
                v.hitEntity.runCommand("summon lightning_bolt")
            }
            if (lore[0].includes("Poison")){
                let level = deroman(lore[0].substring(lore[0].indexOf("Poison")+7,lore[0].indexOf(" ",lore[0].indexOf("Poison")+7)))
                v.hitEntity.runCommand(`effect @e[r=${1+(level/2)},type=!player,type=!item,type=!xp_orb] poison ${level*3} ${level-1}`)
            }
            if (lore[0].includes("Wither")){
                let level = deroman(lore[0].substring(lore[0].indexOf("Wither")+7,lore[0].indexOf(" ",lore[0].indexOf("Wither")+7)))
                v.hitEntity.runCommand(`effect @e[r=${1+(level/2)},type=!player,type=!item,type=!xp_orb] wither ${level*2} ${level-1}`)
            }
            if (lore[0].includes("Levitating")){
                let level = deroman(lore[0].substring(lore[0].indexOf("Levitating")+11,lore[0].indexOf(" ",lore[0].indexOf("Levitating")+11)))
                v.hitEntity.runCommand(`effect @e[r=${2+(level/2)},type=!player,type=!item,type=!xp_orb] levitation 1 ${(level*2)+3}`)
            }
            if (lore[0].includes("Melting")){
                v.hitEntity.runCommand("fill ~ ~ ~ ~ ~ ~ flowing_lava 1 replace air")
            }
            if (lore[0].includes("Exploding")){
                v.hitEntity.runCommand("summon tnt")
            }
            if (lore[0].includes("Absorbing")){
                player.runCommand("effect @s absorption 10 0 true")
            }
            if (lore[0].includes("Lifesteal")){
                let level = deroman(lore[0].substring(lore[0].indexOf("Lifesteal")+10,lore[0].indexOf(" ",lore[0].indexOf("Lifesteal")+10)))
                player.runCommand(`effect @s regeneration ${level+2} ${level-1}`)
            }
            if (lore[0].includes("Slowing")){
                let level = deroman(lore[0].substring(lore[0].indexOf("Slowing")+8,lore[0].indexOf(" ",lore[0].indexOf("Slowing")+8)))
                v.hitEntity.runCommand(`effect @e[r=${1+(level/2)},type=!player,type=!item,type=!xp_orb] slowness ${level*2} ${level-1}`)
            }
        }
    }
})

function enchant(player,item,level){
    if (player.hasTag(`enoughexp${level}`)){
        let lore = ""
        let itemlore = item.getLore()[0]
        if (!itemlore){
            itemlore=""
        }
        let count = 0
        let levelid = "I"
        if(level == 1){
            levelid = "I"
        }
        else if(level == 2){
            levelid = "II"
        }
        else if(level == 3){
            levelid = "III"
        }
        else if(level == 4){
            levelid = "IV"
        }
        else if(level == 5){
            levelid = "V"
        }
        else if(level == 6){
            levelid = "VI"
        }
        else if(level == 7){
            levelid = "VII"
        }
        else if(level == 8){
            levelid = "VIII"
        }
        else if(level == 9){
            levelid = "IX"
        }
        else if(level == 10){
            levelid = "X"
        }
        while (lore == "" && count < 30){
            let rng = Math.floor(Math.random()*120)
            count = count + 1
            if (rng < 10 && level >= 3 && !itemlore.includes("Melting")){
                lore = "\n§4Melting "
            }
            else if (rng > 10 && rng<=20 && level >= 6 && !itemlore.includes("Lightning")){
                lore = "\n§eLightning "
            }
            else if (rng > 20 && rng<=25 && level >= 5 && !itemlore.includes("Exploding")){
                lore = "\n§cExploding "
            }
            else if (rng > 25 && rng<=35 && !itemlore.includes("Levitating")){
                lore = "\n§dLevitating "+levelid+" "
            }
            else if (rng > 35 && rng<=45 && !itemlore.includes("Lifesteal")){
                lore = "\n§5Lifesteal "+levelid+" "
            }
            else if (rng > 45 && rng<=55 && !itemlore.includes("Poison")){
                lore = "\n§aPoison "+levelid+" "
            }
            else if (rng > 55 && rng<=65 && level >= 4 && !itemlore.includes("Absorbing")){
                lore = "\n§6Absorbing "
            }
            else if (rng > 65 && rng<=75 && !itemlore.includes("Poison")){
                lore = "\n§aPoison "+levelid+" "
            }
            else if (rng > 75 && rng<=85 && !itemlore.includes("Wither")){
                lore = "\n§0Wither "+levelid+" "
            }
            else if (rng > 85 && rng<=110 && !itemlore.includes("Enchant DMG") && !itemlore.includes("Damage")){
                lore = "\n§1+"+level*2+" Enchant DMG"
            }
            else if (rng > 110 && rng<=120 && !itemlore.includes("Slowing")){
                lore = "\n§9Slowing "+levelid+" "
            }
        }
        if (!lore == ""){
            item.setLore([itemlore + lore])
            player.getComponent("inventory").container.setItem(player.selectedSlot,item)
            if (level-1 <= 4){
                player.runCommand(`xp -${(level)*10}L @p`)
            }
            else{
                player.runCommand(`xp -${((level-5)*5)+50}L @p`)
            }
        }
    }
}

world.events.itemUseOn.subscribe(v => {
    let player = v.source
    if (!player.hasTag("inenchmenu") && player.dimension.getBlock(v.blockLocation).id == "vatonage:custom_enchantment_table"){
        player.addTag("inenchmenu")
        const form = new ActionFormData()
            .title("Custom Enchantment Table")
            .body("Select an enchant to apply to the item you are holding. Each time you enchant it will add 1 enchantment to the item, and you can enchant items multiple times to add as many enchantments as you want.")
            .button("Tier 1 Enchant\n§2§l10 Levels",`textures/items/rotten_flesh`)
            .button("Tier 2 Enchant\n§2§l20 Levels",`textures/items/stick`)
            .button("Tier 3 Enchant\n§2§l30 Levels",`textures/items/wood_sword`)
            .button("Tier 4 Enchant\n§2§l40 Levels",`textures/items/stone_sword`)
            .button("Tier 5 Enchant\n§2§l50 Levels",`textures/items/gold_sword`)
            .button("Tier 6 Enchant\n§2§l55 Levels",`textures/items/iron_sword`)
            .button("Tier 7 Enchant\n§2§l60 Levels",`textures/items/diamond_sword`)
            .button("Tier 8 Enchant\n§2§l65 Levels",`textures/items/netherite_sword`)
            .button("Tier 9 Enchant\n§2§l70 Levels",`textures/items/trident`)
            .button("Tier 10 Enchant\n§2§l75 Levels",`textures/items/experience_bottle`)
        form.show(player).then(response => {
            
            player.removeTag("inenchmenu")
            if (!response.isCanceled) {
                let item = player.getComponent("inventory").container.getItem(player.selectedSlot)
                if (item){
                    if (!item.id.includes("helmet") && !item.id.includes("chestplate") && !item.id.includes("leggings") && !item.id.includes("boots")){
                        if(item.id.includes("sword") || item.id.includes("trident") || item.id.includes("axe") || item.hasComponent("minecraft:durability")){
                            enchant(player,item,response.selection+1)
                        }
                    }
                }
            }
        })
    }
})